#include "Base/light.fxh"

uniform extern float4x4 g_WVP 	     : XDL2SM_WORLD_VIEW_PROJECTION;
uniform extern float4x4 g_World	     : XDL2SM_WORLD;
uniform extern float4x4 g_WorldIT    : XDL2SM_WORLD_INVERSE_TRANSPOSE;
uniform extern float4x4 g_View       : XDL2SM_VIEW;

uniform extern float4 g_Ambient  : XDL2SV_MATERIAL_AMBIENT;
uniform extern float4 g_Diffuse  : XDL2SV_MATERIAL_DIFFUSE;
uniform extern float4 g_Specular : XDL2SV_MATERIAL_SPECULAR;
uniform extern float4 g_Emissive : XDL2SV_MATERIAL_EMISSIVE;

uniform extern float4 g_EyePos : XDL2SV_EYE_POSITION;

uniform extern texture g_Texture : XDL2ST_TEXTURE_1;
uniform extern float4x4 g_TextM  : XDL2SM_TEXTURE_1_TRANSFORM;

uniform extern texture g_Texture2 : XDL2ST_TEXTURE_2;
uniform extern float4x4 g_TextM2  : XDL2SM_TEXTURE_2_TRANSFORM;

uniform extern texture g_Shadow : XDL2ST_TEXTURE_8;
uniform extern float4x4 g_LightVP : XDL2SM_CUSTOM_0;

uniform extern float4 g_Lights[2] : XDL2SV_LIGHT_POSITION;
uniform extern  float4 g_LightColors[2] : XDL2SV_LIGHT_COLOR;

uniform extern float g_Time : XDL2SF_CUSTOM_0 = 0.0f;

sampler texSample = sampler_state
{
	Texture = <g_Texture>;

    	MinFilter = Anisotropic;
    	MagFilter = Linear;
    
    	MaxAnisotropy = 4;
};

sampler texSample2 = sampler_state
{
	Texture = <g_Texture2>;

    	MinFilter = Anisotropic;
    	MagFilter = Anisotropic;
    
    	MaxAnisotropy = 8;
};

sampler shadowSample = sampler_state
{
	Texture = <g_Shadow>;
	MinFilter = Point;
	MagFilter = Point;
	MipFilter = Point;
	AddressU = Clamp;
	AddressV = Clamp;
};

void ShadowVS(float3 pos : POSITION0,
	      out float4 posT : POSITION0,
	      out float2 depth : TEXCOORD0)
{
	posT = mul(float4(pos,1.0f),g_WVP);
	depth = posT.zw;
}

float4 ShadowPS(float2 depth : TEXCOORD0) : COLOR
{
	return depth.x/depth.y;
}

struct VertexShaderOut
{
	float4 pos  : POSITION0;
	float3 normal  : TEXCOORD0;
	float3 posW : TEXCOORD1;
	float2 tex : TEXCOORD2;
	float4 oz : TEXCOORD3;
};

VertexShaderOut VertexShader(float3 posa : POSITION0, float3 normal : NORMAL0, float2 tex : TEXCOORD0, float3 normal2 : NORMAL1)
{
	VertexShaderOut vso = (VertexShaderOut)0;	

	vso.normal = normal;

	vso.pos = mul( float4(posa,1.0f), g_WVP );
	vso.posW = mul( float4(posa,1.0f), g_World );
	vso.normal = mul( float4(normal,0.0f), g_WorldIT );
	vso.tex = 1-mul(tex,g_TextM);
	float4x4 lwvp = mul(g_World,g_LightVP);
	vso.oz = mul(float4(posa,1.0f),lwvp);
	
	return vso;
}

static const float SHADOW_SIZE = 1024;
static const float SHADOW_BIAS = 0.000125;

float4 PixelShader(float3 normal : TEXCOORD0, float3 pos : TEXCOORD1, float2 tex : TEXCOORD2, float4 oz : TEXCOORD3) : COLOR
{
	normal = normalize(normal);
	
	oz.xy /= oz.w;
	oz.x = 0.5*oz.x + 0.5;
	oz.y = -0.5*oz.y + 0.5;

	float depth = oz.z/oz.w;

	float sscale = 0.5f;
	float sspec = 0.0f;
	
	if(oz.x <= 1.0f && oz.x >= 0.0f)
		sscale = (tex2D(shadowSample,oz.xy).r + SHADOW_BIAS) < depth ? 0.5f : 1.0f;

	sspec = sscale < 1.0f ? 0.1f : 1.0f;

	float3 toEye = normalize(g_EyePos-pos);

	float3 lightVec = normalize(g_Lights[0].xyz-pos);
	float4 pdiff = sscale*LightDiffuse(normal,lightVec);

	lightVec = normalize(g_Lights[1].xyz-pos);
	pdiff += LightDiffuse(normal,lightVec)*g_LightColors[1]*10*(1/distance(pos,g_Lights[1]));

	float4 detspec = tex2D(texSample2,tex*1.5);
	float4 texc = tex2D(texSample,tex);	

	float4 diffuse = detspec*g_Diffuse*pdiff*texc;

	float4 col = (diffuse);
	return g_Emissive+(col*2);
}

technique Shadow
{
	pass P0
	{
		vertexShader = compile vs_2_0 ShadowVS();
		pixelShader = compile ps_2_0 ShadowPS();
	}

	pass P1 
	{
		vertexShader = compile vs_2_0 VertexShader();
		pixelShader = compile ps_2_0 PixelShader();
		//CullMode = None;
	}
}

