uniform extern texture  g_Texture    : XDL2ST_TEXTURE_0;
float g_Intensity : XDL2SF_CUSTOM_0 = 1.0f;

sampler texSample = sampler_state
{
	Texture = <g_Texture>;

	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = LINEAR;
};


static const int g_cKernelSize = 13;

float2 PixelKernelX[g_cKernelSize] =
{
    { -6, 0 },
    { -5, 0 },
    { -4, 0 },
    { -3, 0 },
    { -2, 0 },
    { -1, 0 },
    {  0, 0 },
    {  1, 0 },
    {  2, 0 },
    {  3, 0 },
    {  4, 0 },
    {  5, 0 },
    {  6, 0 },
};

float2 PixelKernelY[g_cKernelSize] =
{
    { 0, -6 },
    { 0, -5 },
    { 0, -4 },
    { 0, -3 },
    { 0, -2 },
    { 0, -1 },
    { 0,  0 },
    { 0,  1 },
    { 0,  2 },
    { 0,  3 },
    { 0,  4 },
    { 0,  5 },
    { 0,  6 },
};


static const float BlurWeights[g_cKernelSize] = 
{
    0.002216,
    0.008764,
    0.026995,
    0.064759,
    0.120985,
    0.176033,
    0.199471,
    0.176033,
    0.120985,
    0.064759,
    0.026995,
    0.008764,
    0.002216,
};

float4 BloomShaderColor(float2 tex : TEXCOORD0) : COLOR
{
	float4 c = tex2D(texSample,tex);
	return c*c*2*g_Intensity;
}

float4 BloomShaderHoriz(float2 tex : TEXCOORD0) : COLOR
{
	float4 col = 0;
	
	float depth = 2.0f;

	for(int i = 0; i < g_cKernelSize; i++)
	{
		col+=float4( tex2D( texSample, tex+PixelKernelX[i]*(1.0f/400.0f)*depth ).xyz ,1.0f)*BlurWeights[i];
	}

	return float4(col.xyz,depth);
	
}

float4 BloomShaderVert(float2 tex : TEXCOORD0) : COLOR
{

	float4 col = 0;

	float depth = 2.0f;

	for(int i = 0; i < g_cKernelSize; i++)
	{
		col+=float4( tex2D( texSample, tex+PixelKernelY[i]*(1.0f/300.0f)*depth ).xyz ,1.0f)*BlurWeights[i];
	}

	return col;
	
}

technique Bloom
{
	pass P0
	{
		vertexShader = null;
		pixelShader = compile ps_2_0 BloomShaderColor();
		ZEnable = FALSE;

		
		AlphaBlendEnable = TRUE;
		SrcBlend = One;
		DestBlend = One;
	}

	pass P1
	{
		vertexShader = null;
		pixelShader = compile ps_2_0 BloomShaderHoriz();
		ZEnable = FALSE;
	}

	pass P2
	{
		vertexShader = null;
		pixelShader = compile ps_2_0 BloomShaderVert();
		ZEnable = FALSE;

	}

}