/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.fmod3;

import java.io.File;
import java.lang.reflect.Method;
import java.nio.FloatBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.fmod3.FMODException;
import org.lwjgl.fmod3.FMusic;
import org.lwjgl.fmod3.FSound;
import org.lwjgl.fmod3.FSoundDSPUnit;

public class FMOD {
    private static HashMap[] callbacks = new HashMap[17];
    static FSoundDSPUnit fmodClearUnit;
    static FSoundDSPUnit fmodClipAndCopyUnit;
    static FSoundDSPUnit fmodMusicUnit;
    static FSoundDSPUnit fmodSFXUnit;
    static FSoundDSPUnit fmodFFTUnit;
    static FloatBuffer fmodFFTBuffer;
    public static final int FMUSIC_INSTCALLBACK = 0;
    public static final int FMUSIC_ORDERCALLBACK = 1;
    public static final int FMUSIC_ROWCALLBACK = 2;
    public static final int FMUSIC_ZXXCALLBACK = 3;
    public static final int FSOUND_DSPCALLBACK = 4;
    public static final int FSOUND_STREAMCALLBACK = 5;
    public static final int FSOUND_ALLOCCALLBACK = 6;
    public static final int FSOUND_REALLOCCALLBACK = 7;
    public static final int FSOUND_FREECALLBACK = 8;
    public static final int FSOUND_OPENCALLBACK = 9;
    public static final int FSOUND_CLOSECALLBACK = 10;
    public static final int FSOUND_METADATACALLBACK = 11;
    public static final int FSOUND_READCALLBACK = 12;
    public static final int FSOUND_SEEKCALLBACK = 13;
    public static final int FSOUND_TELLCALLBACK = 14;
    public static final int FSOUND_ENDCALLBACK = 15;
    public static final int FSOUND_SYNCCALLBACK = 16;
    protected static boolean created;
    public static final int FMOD_ERR_NONE = 0;
    public static final int FMOD_ERR_BUSY = 1;
    public static final int FMOD_ERR_UNINITIALIZED = 2;
    public static final int FMOD_ERR_INIT = 3;
    public static final int FMOD_ERR_ALLOCATED = 4;
    public static final int FMOD_ERR_PLAY = 5;
    public static final int FMOD_ERR_OUTPUT_FORMAT = 6;
    public static final int FMOD_ERR_COOPERATIVELEVEL = 7;
    public static final int FMOD_ERR_CREATEBUFFER = 8;
    public static final int FMOD_ERR_FILE_NOTFOUND = 9;
    public static final int FMOD_ERR_FILE_FORMAT = 10;
    public static final int FMOD_ERR_FILE_BAD = 11;
    public static final int FMOD_ERR_MEMORY = 12;
    public static final int FMOD_ERR_VERSION = 13;
    public static final int FMOD_ERR_INVALID_PARAM = 14;
    public static final int FMOD_ERR_NO_EAX = 15;
    public static final int FMOD_ERR_CHANNEL_ALLOC = 17;
    public static final int FMOD_ERR_RECORD = 18;
    public static final int FMOD_ERR_MEDIAPLAYER = 19;
    public static final int FMOD_ERR_CDDEVICE = 20;
    private static boolean initialized;
    private static String JNI_LIBRARY_NAME;
    public static final String VERSION = "1.0beta4";
    static final int JNI_VERSION = 1;

    static void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        FMOD.loadLibrary(JNI_LIBRARY_NAME);
        int nativeVersion = FMOD.getNativeLibraryVersion();
        if (nativeVersion != 1) {
            throw new LinkageError("Version mismatch: jar version is '1', native libary version is '" + nativeVersion + "'");
        }
        for (int i = 0; i < callbacks.length; ++i) {
            FMOD.callbacks[i] = new HashMap();
        }
    }

    private static void loadLibrary(final String lib_name) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String library_path = System.getProperty("org.lwjgl.librarypath");
                if (library_path != null) {
                    System.load(library_path + File.separator + System.mapLibraryName(lib_name));
                } else {
                    System.loadLibrary(lib_name);
                }
                return null;
            }
        });
    }

    private static native int getNativeLibraryVersion();

    public static boolean isCreated() {
        return created;
    }

    public static void create() throws FMODException {
        if (created) {
            return;
        }
        try {
            String[] fmodPaths = LWJGLUtil.getLibraryPaths((String[])new String[]{"fmod", "fmod.dll", "fmod", "libfmod.so", "fmod", "static-ignored"}, (ClassLoader)FMOD.class.getClassLoader());
            LWJGLUtil.log((String)("Found " + fmodPaths.length + " FMOD paths"));
            FMOD.nCreate(fmodPaths);
            created = true;
        }
        catch (LWJGLException le) {
            throw new FMODException(le.getMessage());
        }
    }

    protected static native void nCreate(String[] var0);

    public static void destroy() {
        if (!created) {
            return;
        }
        FSound.FSOUND_Close();
        FMusic.FMUSIC_StopAllSongs();
        created = false;
        FMOD.nDestroy();
    }

    private static String getPathFromJWS(String libname) {
        try {
            LWJGLUtil.log((String)("getPathFromJWS: searching for: " + libname));
            ClassLoader o = FMOD.class.getClassLoader();
            Class<?> c = o.getClass();
            Method findLibrary = c.getMethod("findLibrary", String.class);
            Object[] arguments = new Object[]{libname};
            return (String)findLibrary.invoke((Object)o, arguments);
        }
        catch (Exception e) {
            LWJGLUtil.log((String)("Failure locating FMOD using classloader:" + e));
            return null;
        }
    }

    protected static native void nDestroy();

    static void registerCallback(int type, long handle, Object handled, Object callbackHandler) {
        Long callbackID = new Long(handle);
        ArrayList<WrappedCallback> callbackList = (ArrayList<WrappedCallback>)callbacks[type].get(callbackID);
        if (callbackList == null) {
            if (callbackHandler == null) {
                LWJGLUtil.log((String)("No callbackhandlers registered for handle: " + handle));
            } else {
                callbackList = new ArrayList<WrappedCallback>();
                callbacks[type].put(callbackID, callbackList);
            }
        }
        if (callbackHandler == null) {
            callbacks[type].remove(callbackID);
        } else {
            callbackList.add(new WrappedCallback(handled, callbackHandler));
        }
    }

    static ArrayList getCallbacks(int type, long handle) {
        return (ArrayList)callbacks[type].get(new Long(handle));
    }

    public static native String FMOD_ErrorString(int var0);

    static {
        JNI_LIBRARY_NAME = "lwjgl-fmod3";
        FMOD.initialize();
    }

    static class WrappedCallback {
        Object handled;
        Object callback;

        WrappedCallback(Object handled, Object callback) {
            this.handled = handled;
            this.callback = callback;
        }
    }
}

