#ifndef VECTOR_HPP
#define VECTOR_HPP

#include <GL/gl.h>
#include <cmath>

struct Vector2 { 
  Vector2(float x, float y) : x(x), y(y) { 
    // Empty
  };

  Vector2() : x(0), y(0) {
    // Empty
  };

  Vector2(const Vector2 &rhs) {
    x = rhs.x;
    y = rhs.y;
  }

  Vector2 rotate(float angle) const {
    Vector2 rotated(0,0);
    rotated.x = cos(angle) * x + sin(angle) * y;
    rotated.y = - sin(angle) * x + cos(angle) * y;
    return rotated;
  };

  Vector2 operator + (const Vector2 &rhs) {
    return Vector2(x + rhs.x, y + rhs.y);
  };

  Vector2 operator * (const float& f) {
    return Vector2(x*f, y*f);
  };

  Vector2 operator - (const Vector2 &rhs) {
    return Vector2(x - rhs.x, y - rhs.y);
  };

  void gl() {
    glVertex2f( x,y );
  }

  float x,y;
};

struct Vector3 {
  Vector3(float x, float y, float z) : x(x), y(y), z(z) {
    // Empty
  };

  Vector3() : x(0), y(0), z(0) {
  };

  void set(float newx, float newy, float newz) { x = newx; y = newy; z = newz; };

  float x, y, z;
};

// XXX: Choose for storing faces as vectors or as points, but not both

struct IndexFace3 {
  int v0, v1, v2;
  Vector3 normal;
};

struct Face3 {
  Vector3 p0, p1, p2;
  Vector3 normal;
  double distance;
};

struct Face4 {
  Vector3 p0, p1, p2, p3;
  Vector3 normal;
  double distance;
  double r, g, b;
};

#endif
