#ifndef HERMITE_HPP
#define HERMITE_HPP

#include "vector.hpp"

/**
 * Hermite curve.
 *
 * Given a set of points (p0, p1, p2, p3) and a value in the range 0.0 to 1.0,
 * we generate points on the Hermite curve from p1 to p2.
 * 
 * The curve goes through points p1 and p2.  The direction of the curve in
 * these points is the same as that for the line segments (p0, p1) and (p2, p3),
 * respectively.
 *
 * p0
 *   \
 *    \
 *     p1 --- p2
 *              \
 *               \
 *                p3
 */
class Hermite {
public:
  Hermite(Vector3 p0, Vector3 p1, Vector3 p2, Vector3 p3);
  void setCoords(Vector3 p0, Vector3 p1, Vector3 p2, Vector3 p3);
  Vector3 interpolate(float t);
private:
  float interpolate(float t, float p0, float p1, float p2, float p3);
  Vector3 _p0, _p1, _p2, _p3;
};

#endif
