#include "dance.hpp"
#include "graphics.hpp"
#include "font.hpp"
#include "types.hpp"

const char* DANCE = "dance.png";

const int MAN_INDEX[] = { 0, 1, 0, 2, };

void blot_circle(double x0, double y0, double width, double height) {
  x0 -= width / 2.0;
  y0 -= height / 2.0;

  double x1 = x0 + width;
  double y1 = y0 + height;

  glBegin(GL_QUADS);

  glTexCoord2f(0.0, 0.0);
  glVertex3f(x0, y0, 0.0);

  glTexCoord2f(1.0, 0.0);
  glVertex3f(x1, y0, 0.0);

  glTexCoord2f(1.0, 1.0);
  glVertex3f(x1, y1, 0.0);

  glTexCoord2f(0.0, 1.0);
  glVertex3f(x0, y1, 0.0);

  glEnd();
}

GLuint create_circle(int width, int height) {
  GLuint texture;
  uint32* buffer = (uint32*) new GLuint[width * height * 4 * sizeof(uint32)];

  for (int i = 0; i < height; i++) {
    for (int j = 0; j < width; j++) {
      int offset = i * width + j;
      double x = (double) j / height;
      double y = (double) i / width;
      double cx = 0.5;
      double cy = 0.5;
      double dist = 1.0 - sqrt((x - cx) * (x - cx) + (y - cy) * (y - cy)) * sqrt(4.0);
      if (dist < 0.0) {
	dist = 0.0;
      }
      int r = (int) (0xff * dist) & 0xff;
      int g = (int) (0xff * dist) & 0xff;
      int b = (int) (0xff * dist) & 0xff;
      int alpha = (int) (0xff * dist) & 0xff;
      buffer[offset] = 0x01000000 * alpha | 0x00010000 * b | 0x00000001 * r | 0x00000100 * g;
    }
  }

  glGenTextures(1, &texture);
  glBindTexture(GL_TEXTURE_2D, texture);
  glTexImage2D(GL_TEXTURE_2D, 0, 4, width, height, 0, GL_RGBA, GL_UNSIGNED_BYTE, buffer);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

  delete buffer;
  return texture;
}

Dance::Dance() {
  _font = getFontDance();
  _blot = create_circle(256, 256);
  _t0 = 0.0;
  _t1 = 0.0;
  _dance_time = 0.0;
  _drop_time = 0.0;
  _bounce_time = 0.0;
}

void Dance::effect(double time, int stage) {
  if (stage == 0) {
    _t0 = time;
    return;
  }
  _dance_time = time - _t0;

  if (stage != 3) {
    _t1 = time;
    _bounce_time = _dance_time;
  } else {
    _drop_time = time - _t1;
  }

  glMatrixMode(GL_MODELVIEW);

  glDisable(GL_LIGHTING);

  glLoadIdentity();
  glTranslatef(-1.0, -1.0, -4.0);

  // Draw background circle
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glOrtho(0.0, 640.0, 480.0, 0.0, 0.0, 1000);

  glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
  glEnable(GL_BLEND);		
  glEnable(GL_TEXTURE_2D);
  glBindTexture(GL_TEXTURE_2D, _blot);

  double width = 32 * 4;
  double height = 45 * 4;
  double x = 900.0 - _dance_time * 64.0;
//   double x = 500.0 - _dance_time * 64.0;
  double y = 435.0;
  y += _drop_time * 500.0;
  glColor3f(0.0, 0.0, 0.0);
  blot_circle(x, y, 500, 400);
  glColor3f(1.0, 1.0, 1.0);

  glMatrixMode(GL_PROJECTION);

  // Draw dancing mans
  glBlendFunc(GL_ONE, GL_SRC_ALPHA);
  glEnable(GL_BLEND);		

  // Make mans bounce!
  y -= fabs(sin(_bounce_time * 11)) * 50;

  // Make mans drop!

  int man = (int) (_dance_time * 6.0) % 4;
  _font->paint((int) (x - width / 2.0),(int) (y + height / 2.0), (int) (x + width / 2.0), (int) (y - height / 2.0), 'a' + MAN_INDEX[man]);

  glDisable(GL_BLEND);
  glMatrixMode(GL_MODELVIEW);
}

