#ifndef CUBEBITMAP_HPP
#define CUBEBITMAP_HPP

#include "effect.hpp"

class CubeBitmap : Effect {
public:
  CubeBitmap(int nWidth, int nHeight);
  void effect(double t, int stage);
private:
  void set_demo_bitmap(double t);
  void draw();
  double* _pixmap0;
  double* _pixmap1;
  double* _pixmap2;
  int _n_width;
  int _n_height;

  /* 0.0 = disabled, 1.0 = fully enabled */
  double _scale;
  /* 0.0 = disabled, 1.0 = fully enabled */
  double _rotate;

  /* 0.0 = disabled, 1.0 = fully enabled */
  double _randomize;

  double _time;
};

#endif
