#include <GL/gl.h>
#include <GL/glu.h>

#include <cstdlib>
#include <cmath>
#include <iostream>

#include "background.hpp"
#include "graphics.hpp"

const char* ECFH_LOGO = "ecfh_256.png";

#define WIDTH 512.0
#define HEIGHT 512.0

Background::Background() {
  _textureId = load_texture_from_file(ECFH_LOGO, 1);
  _prev_stage = -1;
}

void Background::effect(double time, int stage) {
  if (_prev_stage != stage) {
    _prev_stage = stage;
    _t0 = time;
  }

  double local_time = time - _t0;

  _x_offset = 640.0 - 512.0;
  if (stage == 0) {
    _y_offset = 480.0 - local_time * 350.0;
    if (_y_offset < 0.0) {
      _y_offset = 0.0;
    }
  } else {
    _y_offset = 0.0;
  }

  if ((stage == 16) || (stage == 9)) {
    _x_offset = 640.0 - 512.0 + local_time * 350.0;
    if (_x_offset < 0.0) {
      _x_offset = 0.0;
    }
  } else {
    _x_offset = 640.0 - 512.0;
  }

  if ((stage > 9) && (stage < 12)) {
    _x_offset = 1000.0;
  }
  if ((stage >= 12) && (stage <= 13)) {
    _x_offset = 1000.0; //640.0 - 512.0 + 32.0;
  }



  paint();
}

void Background::paint() {
  glDisable(GL_LIGHTING);
  // TODO: This is too messy. Clean up.

  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glLoadIdentity();
  glTranslatef(0.0f, 0.0f, -1.0);

  glMatrixMode(GL_PROJECTION);
  glPushMatrix();
  glLoadIdentity();
  glOrtho(0.0, 640.0, 480.0, 0.0, 0.0, 1000);

  glEnable(GL_TEXTURE_2D);
  glBindTexture(GL_TEXTURE_2D, _textureId);

  double z = 0.0;

  glBegin(GL_QUADS);
  glNormal3f(0.0, 0.0, 1.0);

  // Set background color
  glTexCoord2f(0.0, 0.0);

  // draw top part in background color
  glVertex3f(0.0, 0.0, z);
  glVertex3f(_x_offset + WIDTH, 0.0, z);
  glVertex3f(_x_offset + WIDTH, _y_offset, z);
  glVertex3f(0.0, _y_offset, z);

  // draw left border in background color
  glVertex3f(0.0, 0.0, z);
  glVertex3f(_x_offset, 0.0, z);
  glVertex3f(_x_offset, _y_offset + HEIGHT, z);
  glVertex3f(0.0, _y_offset + HEIGHT, z);

  // draw background image
  glTexCoord2f(0.0, 0.0);
  glVertex3f(_x_offset, _y_offset, z);
  glTexCoord2f(1.0, 0.0);
  glVertex3f(_x_offset + WIDTH, _y_offset, z);
  glTexCoord2f(1.0, 1.0);
  glVertex3f(_x_offset + WIDTH, _y_offset + HEIGHT, z);
  glTexCoord2f(0.0, 1.0);
  glVertex3f(_x_offset, _y_offset + HEIGHT, z);

  glEnd();

  glDisable(GL_TEXTURE_2D);
  glPopMatrix();

  glMatrixMode(GL_MODELVIEW);
  glPopMatrix();

  glColor3f(1.0, 1.0, 1.0);

  glEnable(GL_LIGHTING);
}

