;******************************************************************************
; credits.asm
; 2006/11/05
; Martin Veilleux
;******************************************************************************
;==============================================================================
; INCLUDES
;==============================================================================
;==============================================================================
; DEFINITIONS
;==============================================================================
TCTX    ftitle
TVAR    ftitle.pos  ,vec3_size
TVAR    ftitle.str ,4
TVAR    ftitle.fnt ,4
ENDT    ftitle

TCTX    pbtitle
TVAR    pbtitle.polar   ,12
TVAR    pbtitle.dist    ,4
TVAR    pbtitle.pos     ,vec3_size
TVAR    pbtitle.str     ,4
TVAR    pbtitle.fnt     ,4
ENDT    pbtitle
%assign FTF_MOVEBLUR  0x0200
;==============================================================================
; MACROS
;==============================================================================
;==============================================================================
section .data
;==============================================================================
gBeamCubeScale: dd 0.1,0.1,0.25
gBeamCube: dd 0,0,gtexFlare1d,0,0.1,0.015,-1.0,0xdaafee,240.0,192.0,160.0,0
dd gtexFlare, 0.16

creditEventTotal: dd 11
creditEvents:
dd 0.0, 2.0, 1.4, _renderOnOff, 0,EVENTF_FADEOUT
dd 241.0, 2.0, 1.4, _renderOnOff, 0,EVENTF_FADEOUT | EVENTF_REV
dd 3.0, 26.0, 0, _renderText, 0,0
dd 207.0, 11.5, 0, _renderText, 0,0
dd 2.0, 28.0, 0.2, _renderBeamCube, 0,EVENTF_FADEIO
dd 206.0, 16.0, 0.2, _renderBeamCube, 0,EVENTF_FADEIO
dd 0.75, 2.0, 0.4, _fadeWhite, 0,EVENTF_FADEIO
dd 29.0, 1.0, 1.0, _fadeWhite, 0,EVENTF_FADEIN
dd 206.0, 1.0, 1.0, _fadeWhite, 0,EVENTF_FADEOUT
dd 221.0, 1.0, 1.0, _fadeWhite, 0,EVENTF_FADEIN
dd 241.0, 1.0, 1.0, _fadeWhite, 0,EVENTF_FADEOUT

pbtitleEventTotal: dd 7
pbtitleEvents:
dd 3.0, 2.0, 0.5, _passbyTitle, gpbTitle1, EVENTF_FADEOUT
dd 8.0, 2.0, 2.0, _passbyTitle, gpbTitle2, EVENTF_FADEOUT
dd 12.0, 2.0, 1.5, _passbyTitle, gpbTitle3, EVENTF_FADEOUT
dd 17.0, 1.0, 1.0, _passbyTitle, gpbTitle4, EVENTF_FADEOUT
dd 20.0, 1.0, 1.0, _passbyTitle, gpbTitle5, EVENTF_FADEOUT
dd 23.0, 1.0, 1.0, _passbyTitle, gpbTitle6, EVENTF_FADEOUT
dd 207.0, 1.5, 1.5, _passbyTitle, gpbTitle10, EVENTF_FADEOUT

titleTransDist: dd 0.05
titleEventTotal: dd 24
titleEvents:
dd 5.0, 3.0, 2.0, _fadeTitle, gfTitle1, FTF_MOVEBLUR | EVENTF_FADEOUT
dd 10.0, 2.0, 2.0, _fadeTitle, gfTitle2, FTF_MOVEBLUR | EVENTF_FADEOUT
dd 14.0, 3.0, 2.0, _fadeTitle, gfTitle3, FTF_MOVEBLUR | EVENTF_FADEOUT

dd 18.0, 2.0, 0.8, _fadeTitle, gfTitle4, FTF_MOVEBLUR | EVENTF_FADEOUT
dd 17.8, 2.0, 0.9, _fadeTitle, gfTitle5, FTF_MOVEBLUR | EVENTF_FADEIO
dd 21.0, 2.0, 0.8, _fadeTitle, gfTitle6, FTF_MOVEBLUR | EVENTF_FADEOUT
dd 20.8, 2.0, 0.9, _fadeTitle, gfTitle7, FTF_MOVEBLUR | EVENTF_FADEIO
dd 24.0, 4.0, 0.8, _fadeTitle, gfTitle8, FTF_MOVEBLUR | EVENTF_FADEOUT
dd 23.8, 2.0, 0.9, _fadeTitle, gfTitle9, FTF_MOVEBLUR | EVENTF_FADEIO
dd 26.0, 2.0, 0.9, _fadeTitle, gfTitle7, FTF_MOVEBLUR | EVENTF_FADEIO

dd 208.5, 1.5, 1.0, _fadeTitle, gfTitle10, FTF_MOVEBLUR | EVENTF_FADEOUT

dd 210.0, 1.2, 0.5, _fadeTitle, gfTitle11, FTF_MOVEBLUR | EVENTF_FADEIO
dd 210.6, 1.2, 0.5, _fadeTitle, gfTitle12, FTF_MOVEBLUR | EVENTF_FADEIO
dd 211.2, 1.2, 0.5, _fadeTitle, gfTitle13, FTF_MOVEBLUR | EVENTF_FADEIO
dd 211.8, 1.2, 0.5, _fadeTitle, gfTitle14, FTF_MOVEBLUR | EVENTF_FADEIO
dd 212.4, 1.2, 0.5, _fadeTitle, gfTitle15, FTF_MOVEBLUR | EVENTF_FADEIO
dd 213.0, 1.2, 0.5, _fadeTitle, gfTitle16, FTF_MOVEBLUR | EVENTF_FADEIO
dd 213.6, 1.2, 0.5, _fadeTitle, gfTitle17, FTF_MOVEBLUR | EVENTF_FADEIO
dd 214.2, 1.2, 0.5, _fadeTitle, gfTitle18, FTF_MOVEBLUR | EVENTF_FADEIO
dd 214.8, 1.2, 0.5, _fadeTitle, gfTitle19, FTF_MOVEBLUR | EVENTF_FADEIO
dd 215.4, 1.2, 0.5, _fadeTitle, gfTitle20, FTF_MOVEBLUR | EVENTF_FADEIO
dd 216.0, 1.2, 0.5, _fadeTitle, gfTitle21, FTF_MOVEBLUR | EVENTF_FADEIO
dd 216.6, 1.2, 0.5, _fadeTitle, gfTitle22, FTF_MOVEBLUR | EVENTF_FADEIO
dd 217.2, 1.2, 0.5, _fadeTitle, gfTitle23, FTF_MOVEBLUR | EVENTF_FADEIO



creditsFont3D: dd 4, 1.00, 2.0,2.0,5.0
gpbTitle1:
dd 0.006,0.99,0.25, 400.0, 0,0,220.0, sTitle1, creditsFont3D
gpbTitle2:
dd -0.05,3.1,6.25, 350.0, 0,0,220.0, sTitle2, creditsFont3D
gpbTitle3:
dd 0.006,0.01,-0.25, -400.0, 0,0,220.0, sTitle3, creditsFont3D
gpbTitle4:
dd 0.006,0.30,-0.25, -400.0, 0,-30.0,190.0, sTitle4, creditsFont3D
gpbTitle5:
dd 0.006,1.70,-0.25, -400.0, 0,-30.0,190.0, sTitle5, creditsFont3D
gpbTitle6:
dd 0.006,1.98,-0.25, -400.0, 0,-30.0,190.0, sTitle6, creditsFont3D
gpbTitle10:
dd 2.00,4.99,0.25, 450.0, 0,0,220.0, sTitle7, creditsFont3D
gfTitle1:
dd 0,0,220.0, sTitle1, creditsFont3D
gfTitle2:
dd 0,0,220.0, sTitle2, creditsFont3D
gfTitle3:
dd 0,0,220.0, sTitle3, creditsFont3D
gfTitle4:
dd 0,-30.0,190.0, sTitle4, creditsFont3D
gfTitle5:
dd 0,40.0,220.0, sPeople1, creditsFont3D
gfTitle6:
dd 0,-30.0,190.0, sTitle5, creditsFont3D
gfTitle7:
dd 0,40.0,220.0, sPeople2, creditsFont3D
gfTitle8:
dd 0,-30.0,190.0, sTitle6, creditsFont3D
gfTitle9:
dd 0,40.0,220.0, sPeople3, creditsFont3D
gfTitle10:
dd 0,0,220.0, sTitle7, creditsFont3D

gfTitle11:
dd -10.0,-40.0,220.0, sDemogr1, creditsFont3D
gfTitle12:
dd 10.0,40.0,220.0, sDemogr2, creditsFont3D
gfTitle13:
dd 0.0,-30.0,220.0, sDemogr3, creditsFont3D
gfTitle14:
dd -10.0,30.0,220.0, sDemogr4, creditsFont3D
gfTitle15:
dd 0.0,-30.0,220.0, sDemogr5, creditsFont3D
gfTitle16:
dd 10.0,30.0,220.0, sDemogr6, creditsFont3D
gfTitle17:
dd 10.0,-40.0,220.0, sDemogr7, creditsFont3D
gfTitle18:
dd -10.0,40.0,220.0, sDemogr8, creditsFont3D
gfTitle19:
dd 0.0,-40.0,300.0, sDemogr9, creditsFont3D
gfTitle20:
dd 10.0,40.0,220.0, sDemogr10, creditsFont3D
gfTitle21:
dd 0.0,-30.0,220.0, sDemogr11, creditsFont3D
gfTitle22:
dd -10.0,30.0,220.0, sDemogr12, creditsFont3D
gfTitle23:
dd -10.0,-40.0,220.0, sDemogr13, creditsFont3D

DEFSTRX sTitle1, b,r,a,i,n,s,t,o,r,m
DEFSTRX sTitle2, p,r,e,s,e,n,t,s
DEFSTRX sTitle3, s,o,l,a,r,i,s
DEFSTRX sTitle4, m,u,s,i,c
DEFSTRX sTitle5, c,o,d,e
DEFSTRX sTitle6, g,f,x
DEFSTRX sTitle7, g,r,e,e,t,i,n,g,s
DEFSTRX sPeople1, m,i,c,e
DEFSTRX sPeople2, d,u,f,f,m,a,n
DEFSTRX sPeople3, c,r,i,t,i,k,i,l,l

DEFSTRX sDemogr1, a,a,r,d,b,e,i
DEFSTRX sDemogr2, a,s,d
DEFSTRX sDemogr3, c,o,n,s,p,i,r,a,c,y
DEFSTRX sDemogr4, f,a,i,r,l,i,g,h,t
DEFSTRX sDemogr5, f,a,r,b,r,a,u,s,c,h
DEFSTRX sDemogr6, h,a,u,j,o,b,b
DEFSTRX sDemogr7, k,e,w,l,e,r,s
DEFSTRX sDemogr8, m,f,x
DEFSTRX sDemogr9, p,o,r,t,a,l,SP,p,r,o,c,e,s,s
DEFSTRX sDemogr10, r,e,b,e,l,s
DEFSTRX sDemogr11, t,b,l
DEFSTRX sDemogr12, t,r,a,c,t,i,o,n
DEFSTRX sDemogr13, x,p,l,s,v

;==============================================================================
section .bss
;==============================================================================
divPlane: resb vec4_size
;==============================================================================
section .text
;==============================================================================
;==============================================================================
SDECL   _initCredits, 0
;==============================================================================
    CCALL   _PS_init, gBeamCube, 128
    CCALL   _PS_resetWcube, gBeamCube
.exit:
DECLEND
;==============================================================================
SDECL   _renderCredits, 0
;==============================================================================
;font texture rotation
    CCALL   _getTimeMat, RTmatrix, 14166, 19082,[beatTimer +timer.sec]

    TexClear    myscene +scene.fb
    TexClear    myscene +scene.zb
    RasSetCam myscene +scene.cam
    CCALL   _loopEventAll, creditEvents, [creditEventTotal]
.exit:
DECLEND
;==============================================================================
SDECL   _renderBeamCube, 0
;==============================================================================
    LCTX    esp
    LARG    4, _ratio, _total, _fade

    mov     eax,dword[%$_fade]
    mov     dword[gBeamCube +wcubePSb.c +rgbaUP.a],eax
    CCALL   _PS_updateWcube, gBeamCube, [RTM_dt]

    RasSetFpgm _FPGM_RGBxT0add
    ObjSetScale gBeamCubeScale
    M33id   OBJ_tform +objtform.rm
    V3setNull    OBJ_tform +objtform.rm +matrix.t
    CCALL   _PS_renderWcubeB, gBeamCube
.exit:
DECLEND
;==============================================================================
SDECL _renderOnOff, 0
;==============================================================================
    MPUSH   ebp
    LCTX    ebp
    LARG    4, _ratio, _total, _fade
    LVAR    beam_size, lbeam
    LVAR    vec4_size, p1, p2
    LVAR    4, mdist
    LENTER
;set beam orientation & len
    lea     eax,[%$p1]
    mov     dword[%$lbeam +beam.p1],eax
    lea     eax,[%$p2]
    mov     dword[%$lbeam +beam.dir],eax

    mov     dword[%$p1 +vec3.z],REAL_1
    xor     eax,eax
    mov     dword[%$p1 +vec3.y],eax
    mov     dword[%$p1 +vec3.x],eax
;set length
    fild    dword[myscene +scene.fb +tex.w]
    fadd    st0
    fdiv    dword[myscene +scene.cam +camera.scale]
    fmul    dword[%$_ratio]
    fabs
    fstp    dword[%$lbeam +beam.len]
;set diam
    fld1
    fsub    dword[%$_fade]
    mov     dword[%$mdist],80
    fimul   dword[%$mdist]
    mov     dword[%$mdist],REAL_1D10
    fadd    dword[%$mdist]
    fstp    dword[%$lbeam +beam.diam]
;set tex
    mov     dword[%$lbeam +beam.tex],gtexFlare
    xor     eax,eax
    mov     dword[%$lbeam +beam.endtex],eax
    mov     dword[%$lbeam +beam.flags],BEAMF_OFFSET
    rgbaUnpack %$lbeam +beam.color, PACKB2DW(0,64,80,192)
;render horiz beam
    RasSetFpgm _FPGM_RGBxT0add
    xor     eax,eax
    mov     dword[%$p2 +vec3.x],REAL_1
    mov     dword[%$p2 +vec3.y],eax
    mov     dword[%$p2 +vec3.z],eax
    mov     dword[%$lbeam +beam.angle], REAL_PID4
    lea     eax,[%$lbeam]
    CCALL   _BEAM_render, eax
    mov     dword[%$lbeam +beam.angle],REAL_PID4 | REAL_SIGNMASK
    lea     eax,[%$lbeam]
    CCALL   _BEAM_render, eax
;render vert beam
    RasSetFpgm _FPGM_RGBxT0add
    xor     eax,eax
    mov     dword[%$p2 +vec3.y],REAL_1
    mov     dword[%$p2 +vec3.x],eax
    mov     dword[%$lbeam +beam.angle],REAL_PID4
    lea     eax,[%$lbeam]
    CCALL   _BEAM_render, eax
    mov     dword[%$lbeam +beam.angle],REAL_PID4 | REAL_SIGNMASK
    lea     eax,[%$lbeam]
    CCALL   _BEAM_render, eax
.exit:
    LEXIT
    MPOP    ebp
DECLEND
;==============================================================================
SDECL _fadeWhite, 0
;==============================================================================
    LCTX    esp
    LARG    4, _ratio, _total, _fade
    LVAR    4, blendf

    mov     dword[%$blendf], 256
    fld     dword[%$_fade]
    fimul   dword[%$blendf]
    fistp   dword[%$blendf]
    mov     eax,dword[%$blendf]
    cmp     eax,255
    jle     .endClip
    mov     eax,255
.endClip:
    mov     edx,eax
    shl     edx,16
    mov     dh,al
    mov     dl,al
    CCALL   _TEX_sadd, myscene +scene.fb, edx
.exit:
DECLEND
;==============================================================================
SDECL _renderText, 0
;==============================================================================
;set render constant
    RasSetCulling CULLING_BACK
    RasSetFpgm _FPGM_RGBxT0_Z
    RasSetVpgm _VPGM_RGBT0
;    mov     edx,dword[gbboard +billboard.data]
;    lea     edx,[edx +tex_size*11]
;    cmp     dword[edx +tex.data],0
;    jne     .setTex
    mov     edx,gtexFont
.setTex:
    RasSetTex 0, edx

;set obj constant
    ObjSetFlags 0, 0, 0
    ObjSetVpgm _VPGM_title

    RasSetScene myscene
    CCALL   _loopEventAll, pbtitleEvents, [pbtitleEventTotal]
    CCALL   _loopEventAll, titleEvents, [titleEventTotal]

    RasSetFpgm _FPGM_RGBxT0add
    RasSetScene glrscene
    and     byte[RAS_main +raster.bb +tex.flags],~TEXF_FULL
    or      byte[RAS_main +raster.fb +tex.flags],TEXF_FULL | TEXF_BLUR
    CCALL   _loopEventAll, titleEvents, [titleEventTotal]
    test    byte[RAS_main +raster.bb +tex.flags],TEXF_FULL
    jz      .endRadial
    CCALL   _TEX32_upsample, myscene +scene.fb, glrscene +scene.bb

.endRadial:
    RasSetScene myscene
.exit:
DECLEND
;==============================================================================
SDECL _passbyTitle, 0
;==============================================================================
    MPUSH   esi,ebp
    LCTX    ebp
    LARG    4, _ratio, _total, _fade, _data, _flags
    LVAR    vec4_size, qr, qrUp, qrTilt
    LVAR    4, aX, aY
    LENTER
    mov     esi,dword[%$_data]
    mov     dword[divPlane +vec4.w],REAL_BIG
;set position
    fldpi
    fmul    dword[esi +pbtitle.polar]
    fstp    dword[%$aX]
    fldpi
    fmul    dword[esi +pbtitle.polar +4]
    fstp    dword[%$aY]
    lea     eax,[%$qr]
    QuatFromPolar eax,[%$aX],[%$aY]
    lea     eax,[%$qr]
    Quat2m33 OBJ_tform +objtform.rm, eax
    fld1
    fsub    dword[%$_ratio]
    fmul    dword[esi +pbtitle.dist]
    fld     dword[OBJ_tform +objtform.rm +matrix.n +vec3.x]
    fmul    st1
    fadd    dword[esi +pbtitle.pos +vec3.x]
    fstp    dword[OBJ_tform +objtform.rm +matrix.t +vec3.x]
    fld     dword[OBJ_tform +objtform.rm +matrix.n +vec3.y]
    fmul    st1
    fadd    dword[esi +pbtitle.pos +vec3.y]
    fstp    dword[OBJ_tform +objtform.rm +matrix.t +vec3.y]
    fmul    dword[OBJ_tform +objtform.rm +matrix.n +vec3.z]
    fadd    dword[esi +pbtitle.pos +vec3.z]
    fstp    dword[OBJ_tform +objtform.rm +matrix.t +vec3.z]
    fldpi
    fchs
    fmul    dword[Real1d2]
    fmul    dword[%$_fade]
    fstp    dword[%$aX]
    lea     eax,[%$qrUp]
    QuatFromAA eax,OBJ_tform +objtform.rm +matrix.v, [%$aX]
;set tilt
    fldpi
    fmul    dword[esi +pbtitle.polar +8]
    fmul    dword[%$_fade]
    fstp    dword[%$aX]
    lea     eax,[%$qrTilt]
    QuatFromPolar eax,[%$aX],0
;set rotation
    fldpi
    fmul    dword[esi +pbtitle.polar]
    fmul    dword[%$_fade]
    fstp    dword[%$aX]
    fldpi
    fmul    dword[esi +pbtitle.polar +4]
    fmul    dword[%$_fade]
    fstp    dword[%$aY]
    lea     eax,[%$qr]
    QuatFromPolar eax,[%$aX],[%$aY]
    lea     eax,[%$qr]
    lea     edx,[%$qrTilt]
    QuatMul eax,eax,edx
    lea     eax,[%$qr]
    lea     edx,[%$qrUp]
    QuatMul eax,edx,eax
    lea     eax,[%$qr]
    Quat2m33 OBJ_tform +objtform.srm, eax
    M33transpose OBJ_tform +objtform.rm, OBJ_tform +objtform.srm

    CCALL   _FONT3D_render, [esi +pbtitle.str], [esi +pbtitle.fnt]
.exit:
    LEXIT
    MPOP    esi,ebp
DECLEND
;==============================================================================
SDECL _fadeTitle, 0
;==============================================================================
    MPUSH   esi,ebp
    LCTX    ebp
    LARG    4, _ratio, _total, _fade, _data, _flags
    LVAR    vec3_size, movpos, viewCoord
    LENTER
;dont blur if moving blur & not fading
    test    byte[RAS_main +raster.fb +tex.flags],TEXF_BLUR
    jz      .endCondBlur
    test    dword[%$_flags],EVENTF_FADEIO
    jnz     .endCondBlur
    test    dword[%$_flags],FTF_MOVEBLUR
    jnz     .exit
.endCondBlur:
;comp position
    mov     esi,dword[%$_data]
    V3eq    %$movpos, esi +ftitle.pos
    mov     dword[divPlane +vec4.w],REAL_BIG
    test    dword[%$_flags],EVENTF_FADEIO
    jz      .dorender
;plane normal is 1,0,0 so Ax +By +Cz +D = x + D
;comp D
    CCALL   _FONT3D_getWidth, [esi +ftitle.str], [esi +ftitle.fnt]
    fld     st0
    fld     dword[%$_fade]
    test    dword[%$_flags],EVENTF_FADEOUT
    jz      .endRevFade
    fld1
    fsubrp  st1
.endRevFade:
    fmulp   st1
    fxch    st1
    fmul    dword[Real1d2]
    fsubp   st1
    fadd    dword[esi +ftitle.pos +vec3.x]
    test    dword[%$_flags],FTF_MOVEBLUR
    jz      .endMoveBlur
    fst     dword[%$movpos +vec3.x]
.endMoveBlur:
    fchs
    fstp    dword[divPlane +vec4.w]
;set A
    fld1
    test    dword[%$_flags],EVENTF_FADEOUT
    jnz     .endRev
    fchs
    xor     dword[divPlane +vec4.w],REAL_SIGNMASK
.endRev:
    fstp    dword[divPlane +vec4.x]
    xor     eax,eax
    mov     dword[divPlane +vec4.y],eax
    mov     dword[divPlane +vec4.z],eax
.dorender:
    M33id OBJ_tform +objtform.rm
    V3eq    OBJ_tform +objtform.rm +matrix.t, esi +ftitle.pos
    test    byte[RAS_main +raster.fb +tex.flags],TEXF_FULL
    jz      .endClr
    TexClear RAS_main +raster.fb
.endClr:
    CCALL   _FONT3D_render, [esi +ftitle.str], [esi +ftitle.fnt]
;do post blur
    test    byte[RAS_main +raster.fb +tex.flags],TEXF_BLUR
    jz      .endBlur
;set glare variables
    lea     eax,[%$movpos]
    lea     edx,[%$viewCoord]
    CCALL   _space2view, edx,eax,RAS_main +raster.fb
    test    eax,eax
    jz      .endBlur
    CCALL   _TEX32_glare, RAS_main +raster.fb, [%$viewCoord], [%$viewCoord +4], 235, 15, 60, 255
    test    byte[RAS_main +raster.bb +tex.flags],TEXF_FULL
    jz      .is1stPass
    TexAdd  RAS_main +raster.bb,RAS_main +raster.fb
    jmp     .endAcc
.is1stPass:
    TexBlit RAS_main +raster.bb,RAS_main +raster.fb
.endAcc:
    or      byte[RAS_main +raster.bb +tex.flags],TEXF_FULL
    or      byte[RAS_main +raster.fb +tex.flags],TEXF_FULL
.endBlur:
.exit:
    LEXIT
    MPOP    esi,ebp
DECLEND
;==============================================================================
SDECL _space2view, 0
;==============================================================================
    MPUSH   esi
    LCTX    esp
    LARG    4, _v2, _v3, _scene
    LVAR    4, isInside

    mov     esi,dword[%$_scene]
    mov     eax,dword[%$_v3]
    fld     dword[esi +scene.cam +camera.scale]
    fdiv    dword[eax +vec3.z]
    mov     edx,dword[%$_v2]
    fld     dword[eax +vec3.x]
    fmul    st1
    fld     dword[eax +vec3.y]
    fmulp   st2
    fadd    dword[esi +scene.cam +camera.w]   ;x y
    fld     dword[esi +scene.cam +camera.h]
    faddp   st2
    fistp   dword[edx +vec3.x]
    fistp   dword[edx +vec3.y]

    xor     eax,eax
    mov     dword[%$isInside],eax
    cmp     dword[edx +vec3.x],eax
    jle     .exit
    cmp     dword[edx +vec3.y],eax
    jle     .exit
    mov     eax,dword[esi +scene.fb +tex.w]
    cmp     dword[edx +vec3.x],eax
    jge     .exit
    mov     eax,dword[esi +scene.fb +tex.h]
    cmp     dword[edx +vec3.y],eax
    jge     .exit
    mov     byte[%$isInside],1
%ifdef _USE_THIS_
    cmp     dword[edx +vec3.x],eax
    jge     .clipMaxW
    mov     dword[edx +vec3.x],eax
    jmp     .clipMinH
.clipMaxW:
    mov     eax,dword[esi +scene.fb +tex.w]
    cmp     dword[edx +vec3.x],eax
    jl      .clipMinH
    dec     eax
    mov     dword[edx +vec3.x],eax
.clipMinH:
    xor     eax,eax
    cmp     dword[edx +vec3.y],eax
    jge     .clipMaxH
    mov     dword[edx +vec3.y],eax
    jmp     .exit
.clipMaxH:
    mov     eax,dword[esi +scene.fb +tex.h]
    cmp     dword[edx +vec3.y],eax
    jl      .exit
    dec     eax
    mov     dword[edx +vec3.y],eax
%endif
.exit:
    mov     eax,dword[%$isInside]
    MPOP    esi
DECLEND
;==============================================================================
SDECL _VPGM_title
;==============================================================================
    MPUSH   ebp
    LCTX    ebp
    LARG    4, _pvert
    LVAR    vec4_size, norm
    LENTER
;set tex coord
    mov     edx,dword[%$_pvert]
    lea     eax,[edx +vertex.nx]
    lea     edx,[%$norm]
    M33mulV3 edx,RTmatrix,eax
;    fld     dword[edx +vertex.ny]
;    fld     dword[edx +vertex.nx]
    fld     dword[%$norm +vec3.y]
    fld     dword[%$norm +vec3.x]
    fld     dword[RAS_main +raster.xtinfo +xtexinfo.uvMaxD2]
    fmul to st1
    fmul to st2
    fadd to st1
    faddp   st2
    mov     edx,dword[%$_pvert]
    fstp    dword[edx +vertex.u0]
    fstp    dword[edx +vertex.v0]
;set color
    mov     eax,REAL_FIX8
    mov     dword[edx +vertex.c +rgbaUP.b],eax
    mov     dword[edx +vertex.c +rgbaUP.g],eax
    mov     dword[edx +vertex.c +rgbaUP.r],eax

    cmp     dword[divPlane +vec4.w],REAL_BIG
    je      .exit
    CCALL   _VPGM_planeDivide, edx,divPlane,[titleTransDist]
.exit:
    LEXIT
    MPOP    ebp
DECLEND
;==============================================================================
SDECL _VPGM_planeDivide
;==============================================================================
    MPUSH   edi
    LCTX    esp
    LARG    4, _pvert, _plane, _rcpFogW

    mov     edi,dword[%$_pvert]
    mov     eax,dword[%$_plane]
    V3dot   eax,edi
    mov     eax,dword[%$_plane]
    fadd    dword[eax +vec4.w]
    fldz
    _FCOMP  st1
    jc      .exit
    fabs
    fmul    dword[%$_rcpFogW]
    fld1
    _FCOM   st1
    jnc     .modulate
    xor     eax,eax
    ffreep  st0
    mov     dword[edi +vertex.c +rgbaUP.b],eax
    mov     dword[edi +vertex.c +rgbaUP.g],eax
    mov     dword[edi +vertex.c +rgbaUP.r],eax
    mov     dword[edi +vertex.c +rgbaUP.a],eax
    jmp     .exit
.modulate:
    fsubrp  st1
    fld     dword[edi +vertex.c +rgbaUP.b]
    fmul    st1
    fld     dword[edi +vertex.c +rgbaUP.g]
    fmul    st2
    fld     dword[edi +vertex.c +rgbaUP.r]
    fmul    st3
    fxch    st1
    fld     dword[edi +vertex.c +rgbaUP.a]
    fmul    st4
    fxch    st3
    fstp    dword[edi +vertex.c +rgbaUP.b]
    fstp    dword[edi +vertex.c +rgbaUP.g]
    fstp    dword[edi +vertex.c +rgbaUP.r]
    fstp    dword[edi +vertex.c +rgbaUP.a]
.exit:
    ffreep  st0
    MPOP    edi
DECLEND
;==============================================================================
