#include <iostream>

using namespace std;

const int NUM_FILAS = 4;
const int NUM_COLUMNAS = 7;

bool EXISTE_MURO_DERECHO(int i, int j) {
  return((i==0 && (j==1 || j==3)) || (i==1 && j!=4) ||
         (i==2 && j!=1 && j!=3)   || (i==3 && (j==3 || j==5)));
}

bool EXISTE_MURO_INFERIOR(int i, int j) {
  return((i==0 && (j==0 || j==5)) ||
         (i==1 && (j==3 || j==4)) || (i==2 && j==1));
}

void Postscript(ostream & fsal=cout) {
  float escala;
  fsal << "%!PS-Adobe-2.0 EPSF-2.0\n";
  if (NUM_FILAS > 80  ||  NUM_COLUMNAS > 55)
    escala = 80.0/NUM_FILAS < 55.0/NUM_COLUMNAS ?
             80.0/NUM_FILAS : 55.0/NUM_COLUMNAS;
  else
    escala = 1.0;
  fsal << "%%BoundingBox: 0 0 " << ((int)(NUM_COLUMNAS*escala)+4)*10;
  fsal << " " << ((int)(NUM_FILAS*escala)+4)*10 << "\n";
  fsal << "newpath 0 " << ((int)(NUM_FILAS*escala)+4)*10;
  fsal << " moveto 0 0 lineto " << ((int)(NUM_COLUMNAS*escala)+4)*10;
  fsal << " 0 lineto " <<  ((int)(NUM_COLUMNAS*escala)+4)*10;
  fsal << " " << ((int)(NUM_FILAS*escala)+4)*10;
  fsal << " lineto closepath clip\n";
  fsal << escala << " " << escala << " scale\n";
  fsal << "/unidad {10 mul} def\n";

  fsal << "/vector [\n";
  for (int i=0 ; i < NUM_FILAS ; i++) {
    for (int j=0 ; j < NUM_COLUMNAS ; j++) {
      if (EXISTE_MURO_INFERIOR(i,j))  
        fsal << "1 ";
      else
        fsal << "0 ";
      if (EXISTE_MURO_DERECHO(i,j))  
        fsal << "1 ";
      else
        fsal << "0 ";
    }
    fsal << "\n";
  }
  fsal << "] def\n";

  fsal << "newpath\n";
  fsal << "2 unidad " << NUM_FILAS+1 << " unidad moveto\n";
  fsal << "0 " << NUM_COLUMNAS*2 << " " << NUM_FILAS*NUM_COLUMNAS*2-1 << " {";
  fsal << "    /i exch def\n";
  fsal << "    0 2 " << NUM_COLUMNAS*2-1 <<   " {";
  fsal << "        /j exch def\n";
  fsal << "        vector i j add get 1 eq {\n";
  fsal << "            1 unidad 0 unidad rlineto\n";
  fsal << "        }{\n";
  fsal << "            1 unidad 0 unidad rmoveto\n";
  fsal << "        } ifelse\n";
  fsal << "        0 unidad vector i j add 1 add get unidad rlineto\n";
  fsal << "        0 unidad vector i j add 1 add get -1 mul unidad rmoveto\n";
  fsal << "    } for\n";
  fsal << "    j 2 add 2 div -1 mul unidad -1 unidad rmoveto\n";
  fsal << "} for\n";
  fsal << "stroke\n";

  fsal << "newpath\n";
  fsal << "2 setlinewidth\n";
  fsal << "2 unidad " << NUM_FILAS+1 << " unidad moveto\n";
  fsal << "0 unidad " << -NUM_FILAS+1 << " unidad rlineto\n";
  fsal << NUM_COLUMNAS << " unidad 0 unidad rlineto\n";
  fsal << "0 unidad 1 unidad rmoveto\n";
  fsal << "0 unidad " << NUM_FILAS-1 << " unidad rlineto\n";
  fsal << -NUM_COLUMNAS << " unidad 0 unidad rlineto\n";
  fsal << "stroke\n";
  fsal << "showpage\n";
}

int main ()  {
  Postscript();
}
