#include <windows.h>
#define KEYDOWN(vk_code) ((GetAsyncKeyState(vk_code) &0x8000) ? 1:0)
#include "defines.h"
#include "texture.h"
#include "baseGraphObj.h"
#include "globals.h"
#include "samples.h"
#include "menuSystem.h"
#include <math.h>
#include <gl/glut.h>

CMainMenuGraph::CMainMenuGraph()
{
	//initialize  
vertices[0]=-3.0;vertices[1]=-3.0;vertices[2]=3.0; // vertex 0..
vertices[3]=3.0;vertices[4]=-3.0;vertices[5]=3.0;  //vertex 1..
vertices[6]=3.0;vertices[7]=3.0;vertices[8]=3.0; //vertex 2..
vertices[9]=-3.0;vertices[10]=3.0;vertices[11]=3.0; //vertex 3..
vertices[12]=3.0;vertices[13]=-3.0;vertices[14]=-3.0; //vertex 4..
vertices[15]=-3.0;vertices[16]=-3.0;vertices[17]=-3.0; //vertex 5..
vertices[18]=-3.0;vertices[19]=3.0;vertices[20]=-3.0; //vertex 6...
vertices[21]=3.0;vertices[22]=3.0;vertices[23]=-3.0; //vertex 7...

index[0] =0; index[1]=1; index[2]=2; index[3]=3; // front side..
index[4] =4; index[5]=5; index[6]=6; index[7]=7; //back side..
index[8]=3; index[9]=2; index[10]=7; index[11]=6; //top side..
index[12]=5; index[13]=4; index[14]=1; index[15]=0; // bottom side..
index[16]=5; index[17]=0; index[18]=3; index[19]=6; // left side..
index[20]=1; index[21]=4; index[22]=7; index[23]=2; // right side.. 
//finished with this .. .aight....

normals[0]=0.0;normals[1]=0.0; normals[2]=1.0; //front side normal
normals[3]=0.0;normals[4]=0.0; normals[5]=-1.0; //back side normal
normals[6]=0.0;normals[7]=1.0; normals[8]=0.0; //top side normal..
normals[9]=0.0;normals[10]=-1.0; normals[11]=0.0; //bottom side normal..
normals[12]=-1.0;normals[13]=0.0; normals[14]=0.0; //left side normal...
normals[15]=1.0;normals[16]=0.0; normals[17]=0.0; //right side normal..

//now for  the texture coordinates..
textCoords[0] = -1.0; textCoords[1]=-1.0;textCoords[2]=1.0;
textCoords[3] = 1.0; textCoords[4]=-1.0;textCoords[5]=1.0;
textCoords[6]= 1.0; textCoords[7]=1.0; textCoords[8]=1.0;
textCoords[9]=-1.0; textCoords[10]=1.0;textCoords[11]=1.0;



}

void CMainMenuGraph::renderIt()
{
	bool back=false;
	static int it=0.01;
	static float var=1.5;
	static float stuff=0.0;
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);
	texture.activate();
	glLoadIdentity();
	
	glTranslatef(0.0,0.0,-10.0);
glScalef(1.8,1.8,0.4);
	glBegin(GL_QUADS);
	for(int i =0; i<(6);i++)
	{
		
		glNormal3f(normals[i*3],normals[i*3+1],normals[i*3+2]);
		//glTexCoord3f(textCoords[0],textCoords[1],textCoords[2]);
		glTexCoord2f(0.0,sin(var));
		glVertex3f(vertices[index[i*4]*3+0],vertices[index[i*4]*3+1],vertices[index[i*4]*3+2]);

		glNormal3f(normals[i*3],normals[i*3+1],normals[i*3+2]);
		//glTexCoord3f(textCoords[3],textCoords[4],textCoords[5]);
		glTexCoord2f(1.0,1.0);
		glVertex3f(vertices[index[i*4+1]*3+0],vertices[index[i*4+1]*3+1],vertices[index[i*4+1]*3+2]);

		glNormal3f(normals[i*3],normals[i*3+1],normals[i*3+2]);
		//glTexCoord3f(textCoords[6],textCoords[7],textCoords[8]);
		glTexCoord2f(sin(var),0.0);
		glVertex3f(vertices[index[i*4+2]*3+0],vertices[index[i*4+2]*3+1],vertices[index[i*4+2]*3+2]);

		glNormal3f(normals[i*3],normals[i*3+1],normals[i*3+2]);
		//glTexCoord3f(textCoords[9],textCoords[10],textCoords[11]);
		glTexCoord2f(0.0,0.0);
		glVertex3f(vertices[index[i*4+3]*3+0],vertices[index[i*4+3]*3+1],vertices[index[i*4+3]*3+2]);

		
	}
glEnd();
glPushMatrix();
GLfloat mat_trans[]={1.0,1.0,1.0,0.4};
GLfloat mat_em[]={1.0,1.0,1.0,0.5};
texture2.activate();
glEnable(GL_BLEND);

GLfloat light_pos[]={0.0,selection,-10.0,1.0};
GLfloat light1_diffuse[]={1.0,1.0,1.0,1.0};
GLfloat light1_spec[]={1.0,1.0,1.0,1.0};
GLfloat spt_direct[]={0.0,0.0,10.0};
glLightfv(GL_LIGHT1,GL_POSITION,light_pos);
glLightfv(GL_LIGHT1,GL_DIFFUSE,light1_diffuse);
glLightfv(GL_LIGHT1,GL_DIFFUSE,light1_spec);
glLightf(GL_LIGHT1,GL_CONSTANT_ATTENUATION,1.5);
glLightf(GL_LIGHT1,GL_LINEAR_ATTENUATION,0.5);
glLightf(GL_LIGHT1,GL_QUADRATIC_ATTENUATION,0.2);

glLightf(GL_LIGHT1,GL_SPOT_CUTOFF,45.0);
glLightfv(GL_LIGHT1,GL_SPOT_DIRECTION,spt_direct);
glLightf(GL_LIGHT1,GL_SPOT_EXPONENT,2.0);

glDisable(GL_CULL_FACE);
	glCullFace(GL_FRONT);
glDepthMask(GL_FALSE);
glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
glTranslatef(0.0,selection,5.0);
glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);
glMaterialfv(GL_FRONT,GL_DIFFUSE,mat_trans);
glMaterialfv(GL_FRONT,GL_EMISSION,mat_em);
glTexGeni(GL_S,GL_TEXTURE_GEN_MODE,GL_SPHERE_MAP);
	glTexGeni(GL_T,GL_TEXTURE_GEN_MODE,GL_SPHERE_MAP);
	glEnable(GL_TEXTURE_GEN_S);
	glEnable(GL_TEXTURE_GEN_T);
glEnable(GL_LIGHT1);	
glScalef(3.2,0.6,0.3);
glutSolidCube(1.0);

glPopMatrix();
glPushMatrix();

glTranslatef(-2.0,selection,5.0);
glRotatef(stuff,0.0,1.0,0.0);
glutSolidTorus(0.27,0.2,16,16);
glPopMatrix();
glTranslatef(2,selection,5.0);
glRotatef(stuff,0.0,-1.0,0.0);
glutSolidTorus(0.27,0.2,16,16);
glDisable(GL_BLEND);
glDepthMask(GL_TRUE);
glDisable(GL_TEXTURE_GEN_S);
glDisable(GL_TEXTURE_GEN_T);
stuff+=5;



}

void CMainMenuGraph::setTexture(char *texture,unsigned int format)
{
	this->texture.setFormat(format);
	this->texture.initTexture(texture);
	
	
}

void CMainMenuGraph::setTexture2(char *texture,unsigned int format)
{
	this->texture2.setFormat(format);
	this->texture2.initTexture(texture);
	
	
}

void CMainMenuGraph::specialEff()
{
}


CBaseMenu::CBaseMenu()
{
	//do mostly nothing.. ok? :)..
}

CMainMenu::CMainMenu():move("menu.wav",255),Select("select.wav",255)
{
currentEntry=0;
Select.playSample();
move.playSample();
}

 int CMainMenu::keyHandler()
{
	static unsigned int lastTime = 0;
	if(KEYDOWN(VK_UP))
	{
		if(GetTickCount() - lastTime >= 133)
    {
		move.playSample();
		--currentEntry;//move up
		if(currentEntry<0)
			currentEntry=3;
		lastTime=GetTickCount();
	}

	}

	if(KEYDOWN(VK_DOWN))
	{
		if(GetTickCount() - lastTime >= 133)
    {
		move.playSample();
		currentEntry++;
		if(currentEntry>3)
			currentEntry=0;
		lastTime=GetTickCount();
	}
	}

	switch(currentEntry)
	{
	case 0:
		graphRep.selection=0.9;
		break;
	case 1:
		graphRep.selection = 0.0;
		break;
	case 2:
		graphRep.selection =-0.87;
		break;
	case 3:
		graphRep.selection =-1.75;
		break;

	}

	if(KEYDOWN(VK_RETURN))
	{
		if(GetTickCount() - lastTime >= 133)
    {
		Select.playSample();
		return selectEntry(currentEntry);
	}
	}

	return currentState;
}

unsigned int CMainMenu::selectEntry(unsigned int entry)
{
	switch(entry)
	{
		case 0:
			return mainMenu_NewGame;
			break;
		case 1:
			return mainMenu_HighScore;
			break;
		case 2:
			return mainMenu_Credits;
			break;
		case 3:
			return mainMenu_Quit;
			break;
		default:
			return mainMenu_FatalError;
			break;
	}
}








