#include <iostream>
#include <stdlib.h>
#include <windows.h>
#include "PlayBrick.h"
#include "CPlayBrick_0.h"
#include "CPlayBrick_1.h"
#include "CPlayBrick_2.h"
#include "CPlayBrick_3.h"
#include "CPlayBrick_4.h"
#include "CPlayBrick_5.h"
#include "CPlayBrick_6.h"
#include "timer.h"
#include "PlayBoard.h"
#include "CmodBoard_normal_graph.h"
#include "CModBoard.h"
#include "CModBoard_normalTetris.h"
#include "samples.h"
#include "globals.h"
#include <gl/glut.h>
#define KEYDOWN(vk_code) ((GetAsyncKeyState(vk_code) &0x8000) ? 1:0)

CLockFps locker(500);
/*
  Name: BoardModifier.cpp
  Author: Hvard Christensen, maybe Mads Johansen will hax0r it too soon. :)
  Description:It contains code for some modifier classes :) 
  Date: 10.12.02 01:46
  Copyright:We are the borg, we own copyright! you will be assimiltated if you steal! 
*/



//NOW I WILL TRY TO IMPLEMENT A NORMAL TETRIS MODBOARD.... THIS WILL ACT AS A NORMAL TETRIS BOARD!

void CModBoard_normalTetris::allocateBoard(int number)
{
board=new unsigned int[number];
}

unsigned int* CModBoard_normalTetris::getBoardAddress()const
{
return board;
}

CModBoard_normalTetris::CModBoard_normalTetris()
{

//Here we need to set height..
setHeight(21);
setWidth(12);
board = new unsigned int[21*14];
//we need to reset table..
resetTable();
//we need to set spee
setSpeed(500);
setPoints(0);
gPoints=0;
//set truly random
srand(GetTickCount());

//we need to create our first player object..
setNextType(rand()%7);
createNewBlock(retNextType());
setNextType(rand()%7);
}



//First all the overload funcionts.. except live.. I take that at the end..

int CModBoard_normalTetris::retHeight()const
{return this->height;}
void CModBoard_normalTetris::setHeight(int height)
{this->height=height;}

int CModBoard_normalTetris::retWidth()const
{return this->width;}
void CModBoard_normalTetris::setWidth(int width)
{this->width=width;}

int CModBoard_normalTetris::retPoints()const
{return this->points;}
void CModBoard_normalTetris::setPoints(int points)
{this->points=points;}

unsigned int CModBoard_normalTetris::retBoard(int index)const
{return this->board[index];}
void CModBoard_normalTetris::setBoard(int index, unsigned int data)
{ this->board[index]=data;}

unsigned int CModBoard_normalTetris::retNextType(void)const
{return this->nextType;}
void CModBoard_normalTetris::setNextType(unsigned int data)
{this->nextType=data;}

unsigned int CModBoard_normalTetris::retSpeed(void)const
{return this->speed;}
void CModBoard_normalTetris::setSpeed(unsigned int speed)
{this->speed=speed;}

void CModBoard_normalTetris::createNewBlock(int type)
{
switch(type)
	{
	case 0:
		playBlock = new CPlayBlock_0(retHeight(),retWidth() );
		dead = playBlock->dieCheck(board);
		break;
	case 1:
		playBlock = new CPlayBlock_1(retHeight(),retWidth() );
		dead = playBlock->dieCheck(board);
		break;
	case 2:
		playBlock = new CPlayBlock_2(retHeight(),retWidth() );
		dead = playBlock->dieCheck(board);
		break;
	case 3:
		playBlock = new CPlayBlock_3(retHeight(),retWidth() );
		dead = playBlock->dieCheck(board);
		break;
	case 4:
		playBlock = new CPlayBlock_4(retHeight(),retWidth() );
		dead = playBlock->dieCheck(board);
		break;
	case 5:
		playBlock = new CPlayBlock_5(retHeight(),retWidth() );
		dead = playBlock->dieCheck(board);
		break;
	case 6:
		playBlock = new CPlayBlock_6(retHeight(),retWidth() );
		dead = playBlock->dieCheck(board);
		break;




	
	default:
		std::cout << "This should NEVER happen... but just in case, exit with error\n";
		exit(1);
		break;
	}
}

bool CModBoard_normalTetris::live()
{
//This will be the general function that rules this class... . . .
//Check if it's time to live..

  static int lastTime = 0;

  if(KEYDOWN(VK_ESCAPE))
   return false;
  

//First we must update our board to display where the player is..


  if(died())
  {
	  board_die.playSample();
	  gPoints=this->retPoints();
    
    
    return false;
  }
  



  if(GetTickCount()-lastTime >= retSpeed())
  {
    lastTime = GetTickCount();
    playBlock->fall(board);
	//brick_fall.playSample();
  
  }

  playBlock->keyHandler(board);
  playBlock->plotBrick(board);

  if(playBlock->dieCheck(board) == true)
  {
	   int time=GetTickCount();
	  for(;;)
	{
		
	
		playBlock->keyHandler(board);
		playBlock->plotBrick(board);
		
		if(playBlock->dieCheck(board)==false)
			playBlock->fall(board);
			
		
			normal_graph.drawBoard(board,retWidth(),retHeight(),retPoints(),this->retNextType());
			

		if(GetTickCount() -time>=350)
		{
			
			time=GetTickCount();
			if(playBlock->dieCheck(board)==false);
			else
			break;
		}
	}
	
  
	  board[playBlock->retLocation(0)] = playBlock->retBlockColor() - 3;
      board[playBlock->retLocation(1)] = playBlock->retBlockColor() - 3;
      board[playBlock->retLocation(2)] = playBlock->retBlockColor() - 3;
      board[playBlock->retLocation(3)] = playBlock->retBlockColor() - 3;
	  
	  brick_die.playSample();
  	delete playBlock;
  createNewBlock(nextType); //creating new block
  	setNextType(rand()%7);
//  	boardDied(); //checking if the new block makes bord die..
  }
    calcPoints();
  playBlock->plotBrick(board);
   normal_graph.drawBoard(board,retWidth(),retHeight(),retPoints(),this->retNextType());
 
  return true;
}

void CModBoard_normalTetris::calcPoints()
{
//Run through The table and Add points if line scored..
  int b=1; // color bonus, not calculated yet

  for(int t = retHeight() - 2; t >= 0; t--)
  {
    while(lineFilled(t))
    {
		if(b>=4)
			board_4LinesRemoved.playSample();
		else if(b==1)
			board_lineRemoved.playSample();
      removeLine(t);
      setPoints(retPoints() + 100*(b) );//+colorBonus();
      b++;
    }
  }
}

bool CModBoard_normalTetris::died()
{

//This will tell if the board has died or not...
  //board is dead if there is a solid in the first line..
  for(int i = 1; i < retWidth()-1; i++)
  {
    if(retBoard(i) == deadBlock1 || retBoard(i) == deadBlock2|| retBoard(i) == deadBlock3)
    return true;
  }

  if(dead)
  {
	  std::cout<<"You scored "<<retPoints()<<std::endl;
    return true;
  }
  else
    return false;
}
