#ifndef __TIME_LINE_HEADER__
#define __TIME_LINE_HEADER__

#include <iostream>
#include <fstream>
#include <vector>
#include <GL/gl.h>
#include "algebra.h"

using namespace std;

class timeLine
{
public:
	struct BezPoint { vec2 p, h1, h2; };
	struct HermitCoef { float a,b,c,d,e; };
	float eval (float t);
	~timeLine() { pts.clear(); hermitCoef.clear(); }
	void load (ifstream& F);
	void load (const char* fileName) { ifstream F(fileName); load(F); F.close(); }
	void printInfo() {
		cout << "min/maxTime = " << pts[0].p[0] << " " << pts[pts.size()-1].p[0] << endl;
		cout << "numCtrlPoints = " << pts.size() << endl;
	}
	void drawCtrls()
	{
		glColor4f(1,0.3,0.3,0.6);
		glBegin(GL_POINTS);
		for (int i = 0; i < pts.size()-1; i++) {
			glVertex2fv(pts[i].h1.n);
			glVertex2fv(pts[i].p.n);
			glVertex2fv(pts[i].h2.n);
		}
		glEnd();
		glColor4f(1,1,0.3,0.5);
		for (int i = 0; i < pts.size() - 1; i++) {
			glBegin(GL_LINE_STRIP);
			glVertex2fv(pts[i].h1.n);
			glVertex2fv(pts[i].p.n);
			glVertex2fv(pts[i].h2.n);
			glEnd();
		}
	}

private:
	vector<BezPoint> pts;
	vector<HermitCoef> hermitCoef;
	void improveHermitHandles();
	void hermitCreate (BezPoint& p1, BezPoint& p2, int hi);
	float evalHermit (int i, float time);
};

#endif
