#include "globals.h"
#include "creditPart.h"
#include "treeFragment.h"
#include "ambientFragment.h"
#include "noise0Fragment.h"
#include "circlesFragment.h"
#include "gradientFragment.h"
#include "blendFragment.h"

using namespace std;

creditPart endPart;
treeFragment treeFrag;
ambientFragment ambFrag;
noise0Fragment noise0Frag;
circlesFragment circlesFrag[2];
gradientFragment gradientFrag[3];
blendFragment blendFrag;

float* FFT;
glText* font;
float startDemoTime;
bool running = true;

void MusicDrawFFT()
{
	double modelMat[16], projMat[16];
	glPushMatrix();

	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
	glOrtho(0, 255, 0, 0.5, -1, 1);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glColor4f(1,1,1,0.4);
	glBegin(GL_LINE_STRIP);
	for (int i = 0; i < 255; i++) glVertex2f(i, FFT[i]);
	glEnd();
	glColor4f(1, 1, 0, 0.5);
	glBegin(GL_LINES);
	for (float y = 0.0; y <= 1.0; y += 0.1) {
		glVertex2f(0, y);
		glVertex2f(255, y);
	}
	glEnd();
	int mx, my;
	glfwGetMousePos(&mx, &my);
	double x,y,z;
	glGetDoublev(GL_PROJECTION_MATRIX, projMat);
	glGetDoublev(GL_MODELVIEW_MATRIX, modelMat);
	GLint viewport[4] = {0, 0, 800, 600};
	gluUnProject((GLdouble)mx, 600.0-(GLdouble)my, 0, modelMat, projMat, viewport, &x, &y, &z);
	glColor4f(0.3, 1, 0.3, 0.8);
	glBegin(GL_LINES);
	glVertex2f(0, FFT[(int)x]); glVertex2f(255, FFT[(int)x]);
	glVertex2f(x, 0); glVertex2f(x, 1);
	glEnd();
	glColor4f(1,1,1,1);
	font->print(10, 600-20, 18, "%f %f", x, y);
	glMatrixMode(GL_PROJECTION);
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);
	glPopMatrix();
}

float getDeltaTime()
{
    static float oldDelta = 0.0;
    float dt = glfwGetTime()-oldDelta;
    oldDelta+=dt;
    return dt;
}

void printFPS()
{
    float t = glfwGetTime();
    static int fps = 0;
    static float prevT = 0.0;
    char buf[256];
    fps++;
    if (t-prevT > 1.0) {
        prevT = t;
        sprintf(buf, "%d", fps);
        glfwSetWindowTitle(buf);
        fps=0;
    }
}

void processSignals()
{
	//for (int i = 0; i < 256; i++) FFT[i] = LOG_LOOKUP[int(FFT[i] * 255)] / 255.0;
	//circle part
	if (FFT[67] > 0.1) {
		if (!circlesFrag[0].alive) circlesFrag[0].init();
		gradientFrag[0].init();
		gradientFrag[1].init();
		gradientFrag[3].init();
		if (!ambFrag.moving) ambFrag.startMoving();
	}
	if (FFT[72] > 0.08) if (!circlesFrag[1].alive) circlesFrag[1].init();
	//if (FFT[200] > 0.02) treeFrag.init();
	noise0Frag.alpha = FFT[162]*8;
	if (FFT[162] > 0.22) if (irnd(2)==1) if (!blendFrag.alive) blendFrag.init();
	//if (FFT[162] > 0.1) noise0Frag.init();
}

void display()
{
	float demoTime = glfwGetTime() - startDemoTime;
	float dt = getDeltaTime();

	if (demoTime > 168) {//168
		static float endPartTime = 0.0;
		if (endPartTime == 0.0) {
			endPartTime = glfwGetTime();
			endPart.init();
		}
		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
		glClearColor(col[0][0], col[0][1], col[0][2], 1.0);
		endPart.draw(dt);
		if (demoTime > 178) running = false;
	} 
	else 
	{
		FFT = MusicGetSpectrum();
		processSignals();
    
		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

		if (!ambFrag.alive) ambFrag.init();
		ambFrag.draw(dt);

		//noise0Frag.draw(dt);
		if (demoTime > 4.6) {
			if (circlesFrag[0].alive) circlesFrag[0].draw(dt);
			if (circlesFrag[1].alive) circlesFrag[1].draw(dt);
		}
		//if (treeFrag.alive) 
		if (gradientFrag[0].alive) gradientFrag[0].draw(dt);
		if (gradientFrag[1].alive) gradientFrag[1].draw(dt);
		if (gradientFrag[2].alive) gradientFrag[2].draw(dt);
		treeFrag.draw(dt);
		if (noise0Frag.alive) noise0Frag.draw(dt);
		if (blendFrag.alive) blendFrag.draw(dt);

		if (demoTime > 168-5) {
			glPushAttrib(GL_ALL_ATTRIB_BITS);
			glEnable(GL_BLEND);
			glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
			glColor4f(1,1,1,1.0-(168-demoTime)/5.0);
			glBegin(GL_QUADS);
			glVertex2f(-4,-3); glVertex2f(4,-3); glVertex2f(4,3); glVertex2f(-4,3);
			glEnd();
			glPopAttrib();
		}

		//MusicDrawFFT();
	}

	//font->print(10, 10, 20, "%f", glfwGetTime()-startDemoTime);

    glfwSwapBuffers();
    printFPS();
}

void init()
{
    glfwInit();
    glfwOpenWindow(800, 600, 0,0,0,0,16,0,GLFW_FULLSCREEN);
    glViewport(0,0,800,600);
    glfwSwapInterval(0);

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glOrtho(-4, 4, -3, 3, -1, 1);
	glMatrixMode(GL_MODELVIEW);
	//glShadeModel(GL_SMOOTH);
	
	srand((unsigned int)(glfwGetTime()*10000.0));
    
	glClearColor(col[0][0], col[0][1], col[0][2], 1.0);
	glClearColor(0,0,0,0);

	treeFragment::prepareData();
	ambientFragment::prepareData();
	circlesFragment::prepareData();
	noise0Fragment::prepareData();
	gradientFragment::prepareData();
	creditPart::prepareData();

	ambFrag.init();
	//endPart.init();
	noise0Frag.init();

	font = new glText("data/font.png", "data/fontMetrics.data");

	MusicInit("bp_-_aave(fin).mp3");
	startDemoTime = glfwGetTime();
}

void done()
{
	MusicDone();
	//endPart.done();
    glfwTerminate();
}

int main(int argc, char**argv)
{
    init();
    while (running) {
        running = (!glfwGetKey(GLFW_KEY_ESC)) && glfwGetWindowParam(GLFW_OPENED);
        display();
    }
    done();
    return 0;
}
