#ifndef __GRADIENT_FRAGMENT_HEADER__
#define __GRADIENT_FRAGMENT_HEADER__

#include "globals.h"

class gradientFragment : public DemoFX
{
private:
	static Texture* gradient;
	float startTime;
	float x,y, grx;
public:
	virtual void init();
	virtual void draw(float dt);
	static void prepareData();
};

Texture* gradientFragment::gradient;

inline void gradientFragment::init()
{
	alive=true;
	startTime=glfwGetTime();
	y=-3;
	x=frnd()*8-4;
	grx=frnd()*8-4;
}

inline void gradientFragment::draw(float dt)
{
	#define FRLEN 2.0
	float t=glfwGetTime()-startTime;
	float tt=t/FRLEN;

	if (t>FRLEN) {
		alive=false;
		return;
	}

	glPushAttrib(GL_ALL_ATTRIB_BITS);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

	glLoadIdentity();

	float xx = 1.4+tt*1.4;
	glColor4f(0,0,0,0.5);
	gradient->enable();
	gradient->bind();
	glBegin(GL_QUADS);
	glTexCoord2f(0,1); glVertex2f(grx-xx,-3);
	glTexCoord2f(1,1); glVertex2f(grx+xx, -3);
	glTexCoord2f(1,0); glVertex2f(grx+xx, 3);
	glTexCoord2f(0,0); glVertex2f(grx-xx, 3);
	glEnd();
	

	//glPopMatrix();
	glPopAttrib();

	#undef FRLEN
}

inline void gradientFragment::prepareData()
{
	gradient = new Texture("data/image5.png");
}


#endif
