#include "circlesFragment.h"

Texture* circlesFragment::circleTex;
timeLine* circlesFragment::blendTimeLine;
timeLine* circlesFragment::moveTimeLine;

void circlesFragment::init()
{
	alive=true;
	startTime=glfwGetTime();
	pos = vec2(frnd() * 3 - 1.5, frnd() * 2.6 - 1.3);
	scale = frnd() * 1 + 1.2;
	dirx = (frnd()) * 0.7 + 1.0;
	if (irnd(2) == 1) dirx = -dirx;
	internalTime = 0.0;
	drawType = irnd(2);
}

void circlesFragment::drawQuad()
{
	glBegin(GL_QUADS);
	glTexCoord2f(0,1); glVertex2f(-1, -1);
	glTexCoord2f(1,1); glVertex2f(1, -1);
	glTexCoord2f(1,0); glVertex2f(1, 1);
	glTexCoord2f(0,0); glVertex2f(-1, 1);
	glEnd();
}

void circlesFragment::draw(float dt)
{
	#define FRLEN 1.4
	
	internalTime += dt;
	
	float t=glfwGetTime()-startTime;
	float tt=t/FRLEN;

	if (t>FRLEN) {
		alive=false;
		return;
	}

	float alpha = blendTimeLine->eval(tt);

	glPushAttrib(GL_ALL_ATTRIB_BITS);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

	glPushMatrix();
	glLoadIdentity();
	glTranslatef(pos[0] + moveTimeLine->eval(tt)*dirx, pos[1], 0);
	glScalef(scale, scale, 1);
	//pos[0] += dirx * dt;

	circleTex->enable();
	circleTex->bind();

	switch (drawType) {
		case 0:
			glPushMatrix();
			glColor4f(1, 1, 1, alpha);
			drawQuad();
			glPopMatrix();

			glPushMatrix();
			glColor4f(1, 0, 0, alpha);
			glRotatef(t * 15.0, 0, 0, 1);
			glTranslatef(1.5, 0, 0);
			glScalef(0.5, 0.5, 1.0);
			drawQuad();

			glPushMatrix();
			glColor4f(1, 1, 1, alpha);
			glRotatef(t *15.0, 0, 0, 1);
			glTranslatef(1.4, 0, 0);
			glScalef(0.4, 0.4, 0.4);
			drawQuad();
			glPopMatrix();
			glPopMatrix();

			glPushMatrix();
			glColor4f(1, 0, 0, alpha);
			glRotatef(t * 15.0, 0, 0, -1);
			glTranslatef(0, -1.5, 0);
			glScalef(0.5, 0.5, 1);
			drawQuad();
			glPopMatrix();
			break;
		case 1:
			glPushMatrix();
			glColor4f(1, 0, 0, alpha);
			glScalef(0.6, 0.6, 0.6);
			drawQuad();
			glPopMatrix();

			glPushMatrix();
			glColor4f(1, 1, 1,alpha);
			glRotatef(t*15.0, 0, 0, -1);
			glTranslatef(-1.6, 0, 0);
			glScalef(1, 1,1);
			drawQuad();

			glRotatef(t*30.0, 0,0,1);
			glTranslatef(0,1.7,0);
			glScalef(0.7, 0.7, 1);
			drawQuad();
			glPopMatrix();

			glPushMatrix();
			glRotatef(t*15, 0,0,1);
			glTranslatef(0, -1, 0);
			glScalef(0.4, 0.4,1);

			

			drawQuad();
			glPopMatrix();
			break;
		default:
			break;
	}

	glPopMatrix();
	glPopAttrib();

	#undef FRLEN
}

void circlesFragment::prepareData()
{
	circleTex = new Texture("data/image6.png");
	blendTimeLine = new timeLine();
	blendTimeLine->load("data/circleBlendTimeLine.data");
	moveTimeLine = new timeLine();
	moveTimeLine->load("data/circleMoveTimeLine.data");
}


