#include "roachtunnell.h"
#include "fyll.h"
#include "window.h"
#include "demo.h"

#include <GL/gl.h>
#include <GL/glut.h>
#include <math.h>

#include "dassrull.h"

roachtunnell::roachtunnell() {

	this->starttime = 1700;
	this->endtime = 3500;
	this->scenelen = endtime - starttime;
	
	this->mytex = new texture(DASSRULL_DATA, DASSRULL_LEN, true, GL_BYTE);

//	hamsterdata2 = gen_hamster();
	
//	this->hamster = new Objekt(hamsterdata2, 210);
//	hamster->move(0.0, 0.0, -5.0);
//	hamster->move(0.0, -0.6, 0.0);
//	hamster->rotate(90, 0.0, 0.0, 1.0);
}

roachtunnell::~roachtunnell() {
	dprint("hopp\n");
	delete mytex;
}

void roachtunnell::init() {
	w->setclearcolor(0.3, 0.1, 0.0);
	demo::blur = false;
}

void roachtunnell::cleanup() {
	w->setclearcolor(0.0, 0.0, 0.0);
}

void roachtunnell::draw() {
	
	if(sleeping()) return;

	scenetime = demo::time - starttime;
	
	glRotatef(((float)sin((float)demo::time/20)*50), 0.0, 0.0, 1.0);
	glTranslatef(0.0, 0.4, 0.0);
	glRotatef(((float)-sin((float)demo::time/20)*50), 0.0, 0.0, 1.0);
	glRotatef(((float)sin((float)demo::time/10)*9), 1.0, 0.0, 0.0);
	glRotatef(((float)sin((float)demo::time/13)*7), 0.0, 1.0, 0.0);

	glColor3f(1.0, 1.0, 1.0);
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, mytex->get_num());
	glColor3f(1.0, 1.0, 1.0);
	glTranslatef(0.0, 0.0, (scenetime/43));

	// tunnell:
	glPushMatrix();
	glEnable(GL_COLOR_MATERIAL);
	glRotatef(scenetime, 0.0, 0.0, 1.0);
	for(int z = 0; z > -20; z--) {
		glTranslatef(0.0, 0.0, -2.0);
		glBegin(GL_QUAD_STRIP); 
		for(float i = 0.0; i < 2*M_PI+0.1; i += 0.1) {
			glNormal3f(-sin(i), -cos(i), 0.2);
			glTexCoord2f((i)/ (2*M_PI), 0.0);
			glVertex3f(sin(i), cos(i), 0);
			glTexCoord2f((i)/ (2*M_PI), 1.0);
			glVertex3f(sin(i), cos(i), 2);
		}
		glEnd();
	}
	glPopMatrix();
	glDisable(GL_COLOR_MATERIAL);
	glDisable(GL_TEXTURE_2D);

	glPushMatrix();

//	hamster->move(0.0, 0.0, -0.02);
	
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, demo::hamstertex->get_num());
	glTexGenf(GL_S, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP);
	glTexGenf(GL_T, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP);
	glTexGenf(GL_R, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP);
	glTexGenf(GL_Q, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP);
	glEnable(GL_TEXTURE_GEN_S);
	glEnable(GL_TEXTURE_GEN_T);

	glColor4f(0.3, 0.1, 0.0, 0.9);
	glTranslatef(0, -fabs(sin(scenetime/9)), -scenetime/40-4);
	glScalef(0.5, 0.3, 1.0);
	glutSolidSphere(1.0, 10, 10);
	glDisable(GL_TEXTURE_GEN_T);
	glDisable(GL_TEXTURE_GEN_S);
	glDisable(GL_TEXTURE_2D);
	glPopMatrix();

}
