#include "demo.h"
#include "gl.h"

#include "GL/gl.h"

#include "window.h"
#include "light.h"

#include "font.h"
#include "fontdata.h"

#include "scene.h"
#include "roachtunnell.h"
#include "roachintro.h"
#include "endscene.h"
#include "eh.h"

#include "hamster.h"

// #include "testscene.h"

#include "minifmod.h"
#include "module.h"

#include <unistd.h>
#include <cstdlib>

#include <sys/ioctl.h>
#include <linux/soundcard.h> // SNDblablaIOCTL

int demo::time;

FMUSIC_MODULE *demo::module;

scene *s[SCENES];

light *demo::l;

Font *demo::fnt;

Blur *demo::blurscene;

bool demo::blur;

bool demo::blurring;

texture *demo::hamstertex;

void demo::init() {
	blur=true;
	fnt = new Font(fontdata_8x16, 8, 8);

	hamstertex = new texture(HAMSTER_DATA, HAMSTER_LEN, true, GL_RGB);
	
//	s[0] = new testscene;
	s[0] = new roachtunnell;
	s[1] = new roachintro;
	s[2] = new endscene;
	s[3] = new credits;

	blurscene = new Blur;
	l = new light(0.0, 0.0, 2.0);
//	float fv[4] = {0.0, 0.0, 0.0, 0.0};

	usleep(1000);
	demo::time = 0;
	FMUSIC_MODULE *hei = ::fmod_init();
}

void demo::doframe() {

	demo::time = demo::get_time();

	gl::predraw();

	l->show();

	if(blur) {
		blurring = true;
		blurscene->init_blur();

		for(int i = 0; i < SCENES; i++) {
			glPushMatrix();
			s[i]->draw();
			glPopMatrix();
		}
		
		blurscene->end_blur();
	}
	blurring = false;

	for(int i = 0; i < SCENES; i++) {
		glPushMatrix();
		s[i]->draw();
		glPopMatrix();
	}

	if(blur) blurscene->draw_blur();
	
//	s[0]->draw();
	
	gl::draw();
	gl::postdraw();
	
}

void demo::quit() {
	delete w;
	for(int i = 0; i < SCENES; i++) {
		delete s[i];
	}
//	delete s[0];
	exit(0);
}

void demo::keypressed(unsigned char key, int x, int y) {

	usleep(100);

	switch(key) {
	case 27:
		demo::quit();
		break;
	case 't':
	case 'T':
		dprint("tid: " << demo::time << '\n');
		break;
	}
}

int demo::get_time() {
	unsigned long delay = 0;
	ioctl(::FSOUND_FileDSP, SNDCTL_DSP_GETODELAY, &delay);
	return (int)( ( (float)(::written - delay) / (44100 * 4)) * 100 );
}
