#ifndef BLUR_H
#define BLUR_H

#include <GL/gl.h>

class Blur {
	GLuint blurtex;
	float zoom;
	int level;

  public:

	Blur();

	~Blur();

	void set_level(const int &lev) {
		level = lev;
	}

	void set_zoom(const float &nyzoom) {
		zoom = nyzoom;
	}

	// per scene init,
	void init_blur();

	// cleanup,
	void end_blur();

	// and draw
	void draw_blur();

};

#endif
