PN=`basename "$0"`                      # Program name
VER=`echo '$Revision: 1.2 $' | cut -d' ' -f2`

Usage () {
    echo "$PN - sleep for some seconds, $VER (stv '95)
usage: $PN seconds" >&2
    exit 1
}

Msg () {
    for i
    do echo "$PN: $i" >&2
    done
}

Fatal () { Msg "$@"; exit 1; }

while [ $# -gt 0 ]
do
    case "$1" in
        --)     shift; break;;
        -h)     Usage;;
        -*)     Usage;;
        *)      break;;                 # Seconds
    esac
    shift
done

[ $# -ne 1 ] && Usage

countdown="$1"
while :
do
    echo "${countdown:-0}       
\c"
    if [ "$countdown" -gt 0 ]
    then countdown=`expr $countdown - 1`
    else exit 0
    fi
    sleep 1
done
