//----------------------------------------------------------
// GNUdemo by GLASS
// (C) 2002 Jonas Forsslund, Erik Eriksson
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//----------------------------------------------------------
//
// Feel free to study the code, but remember that just cut
// and paste into your production is allowed but lame :)
// 
//----------------------------------------------------------



 
//----------------------------------------------------------
// Includer
//----------------------------------------------------------
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <SDL/SDL.h>
#include <SDL/SDL_mixer.h>
#include "SDL_rwops_zzip.h"
#include <zzip.h>
//----------------------------------------------------------





//----------------------------------------------------------
// Direktlnkade saker
//----------------------------------------------------------
#include "font.txt"
//----------------------------------------------------------





//----------------------------------------------------------
// Strukturer
//----------------------------------------------------------
struct Point
{
	float x;
	float y;
	float z;	
};
//----------------------------------------------------------






//----------------------------------------------------------
//Funktionsprototyper
//----------------------------------------------------------
void setpixel(SDL_Surface *screen, int x, int y, Uint8 r, Uint8 g, Uint8 b);
int InitializeSDL(int argc, char* argv[]);
void drawPicture();
void ritaEnGnu(int x, int y);


// 3D-funktioner
void drawDot(float x, float y, float z, unsigned char r, unsigned char g, unsigned char b);
void drawDotStor(float x, float y, float z, unsigned char r, unsigned char g, unsigned char b);
void drawOnlyDot(float x, float y, float z);
void drawMovedDot(Point fran, Point till, float p, unsigned char r, unsigned char g, unsigned char b);
Point rotateX(Point p, float v);
Point rotateY(Point p, float v);
Point rotateZ(Point p, float v);

// Skrollen
void addBokstav(bool *remsa, bool *bokstav);

// Delar
void partPlasma();
void partPix();
void part3D();
void partIntro();
void partEnd();
void partMorf();
//-----------------------------par-----------------------------





//----------------------------------------------------------
// Konstanter
//----------------------------------------------------------
static int WIDTH = 320;
static int HEIGHT = 240;
static int BPP = 16;
static int FULLSCREEN = 1;
static float PI = 3.1415f;
static float PI2 = 6.2830f;

// Skrollen
static int SKROLL_TECKEN = 40;
static int SKROLL_WIDTH = 25;
static int SKROLL_HEIGHT = 7;
Uint32 skrollNollstall;

// Savann
static int ANTAL_GNUER = 20;
static int X_PER_GNU = 32;

// 3D
static float OGA = -260;

// Bollen
static int antalRingar = 11;
static float radie = 50;
static int antalPrickarPerRing = antalRingar*2;
static int antalPrickar = antalRingar*antalPrickarPerRing;
//----------------------------------------------------------






//----------------------------------------------------------
// Globaler	
//----------------------------------------------------------
SDL_Surface* mainScreen;
Uint32 mainKlocka;
Uint32 effektKlocka;
SDL_PixelFormat *fmt;
bool sluta=false;
int nyEffekt=1;
int part=-1;

// Ljud
Mix_Music *music = NULL;
int audio_rate = 44100;
Uint16 audio_format = AUDIO_S16; 
int audio_channels = 2;
int audio_buffers = 4096;

// Plasma
unsigned char *karta;
unsigned char *karta2;
unsigned char *karta3;
unsigned char *kartaUt;
unsigned char *palettR;
unsigned char *palettG;
unsigned char *palettB;

// 3D-plan
Point *plan2d;

// 3D-boll
Point *plan;
int morfStep=0;
float objY=0.0f;

Point *sprangd;
Point *kuben;

// Skroll
Point *skrollPlan;
int iText=0;
bool *skrollText;

// Bilder
SDL_Surface *picEnd;
SDL_Surface *picSkarm;
SDL_Surface *picSavann;
SDL_Surface *picGlass;
SDL_Surface *picGnu;
SDL_Surface *picBild;

SDL_Rect rect;
SDL_RWops *rw;

// Savann
int *gnuX;
int *gnuY;
//----------------------------------------------------------





//----------------------------------------------------------
// drawPicture: Vljer del att visa
//----------------------------------------------------------
void drawPicture()
{
	Uint32 tiden = SDL_GetTicks()-mainKlocka;

	//partMorf();
	if(part==-1)
	{
		part++;
		effektKlocka=SDL_GetTicks();
	}
	if(part==0 && tiden>4300)
	{
		part++;
		effektKlocka=SDL_GetTicks();
	}
	if(part==1 && tiden>21970)//4300+17000)
	{
		part++;
		effektKlocka=SDL_GetTicks();
	}
	if(part==2 && tiden>21970+5000)//4300+17000+5000)
	{
		part++;
		effektKlocka=SDL_GetTicks();
	}
	if(part==3 && tiden>33000)//4300+17000+5000+5000)
	{
		part++;
		effektKlocka=SDL_GetTicks();
	}
	if(part==4 && tiden>46242)//4300+17000+5000+5000+15000)
	{
		part++;
		effektKlocka=SDL_GetTicks();
	}	
	if(part==5 && tiden>46242+5000)//4300+17000+5000+5000+15000+5000)
	{
		part++;
		effektKlocka=SDL_GetTicks();
	}
	if(part==6 && tiden>4300+17000+5000+5000+15000+5000+27000)
	{
		sluta=1;
	}	

	
	switch(part)
	{
		case 0:
			SDL_FillRect( mainScreen, NULL, SDL_MapRGB(mainScreen->format,0,0,0) );
			partIntro();
		break;
		
		case 1:
			partMorf();
		break;
		
		case 2:
			partPix();
		break;
		
		case 3:
			partPlasma();
		break;
		
		case 4:
			//partPlasma();
			rect.x = 0;
			rect.y = 0;
			rect.w = picSavann -> w;
			rect.h = picSavann -> h;
			SDL_BlitSurface(picBild, NULL, mainScreen, &rect);

			part3D();
		break;
		
		case 5:
			partPix();
		break;
		
		case 6:
			partEnd();
		break;

	}
	
	
}
//----------------------------------------------------------





//----------------------------------------------------------
// partPlasma: Ritar ett Plasma
//----------------------------------------------------------
void partPlasma() 
{
	Uint32 klocka=SDL_GetTicks()-effektKlocka;

    for(int i=0;i<256;i++)
	{
		palettR[i]=(unsigned char)(32 + 31.0f * cos( i * PI / 128 + klocka/740.0f ));
        palettG[i]=(unsigned char)(32 + 31.0f * sin( i * PI / 128 + klocka/630.0f ));
        palettB[i]=(unsigned char)(32 - 31.0f * cos( i * PI / 128 + klocka/810.0f ));
    }
	int yKarta=(int)(HEIGHT/2 + (float)(HEIGHT/2-1)*cos(klocka/2980.0f+0.2423f));
	int xKarta=(int)(WIDTH/2 + (float)(WIDTH/2-1)*sin(klocka/2865.0f));
	int yKarta2=(int)(HEIGHT/2 + (float)(HEIGHT/2-1)*cos(klocka/2200.0f+2.3f));
	int xKarta2=(int)(WIDTH/2 + (float)(WIDTH/2-1)*sin(-klocka/2958.0f-0.987f));
	int yKarta3=(int)(HEIGHT/2 + (float)(HEIGHT/2-1)*sin(-klocka/2230.0f+1.3f));
	int xKarta3=(int)(WIDTH/2 + (float)(WIDTH/2-1)*cos(klocka/1958.0f-1.987f));

	for(int y=0;y<HEIGHT;y++)
	{
		for(int x=0;x<WIDTH;x++)
		{
			kartaUt[y*WIDTH+x] = karta[(y+yKarta)*WIDTH*2+(x+xKarta)+0];
			kartaUt[y*WIDTH+x] += karta2[(y+yKarta2)*WIDTH*2+(x+xKarta2)+0];
			kartaUt[y*WIDTH+x] += karta3[(y+yKarta3)*WIDTH*2+(x+xKarta3)+0];
			setpixel(mainScreen,x,y, palettG[kartaUt[y*WIDTH+x]]*2,palettB[kartaUt[y*WIDTH+x]]*2,palettR[kartaUt[y*WIDTH+x]]*2);
		}
	}
	
	SDL_Flip( mainScreen );
}
//----------------------------------------------------------




//----------------------------------------------------------
// partMorf: 
//----------------------------------------------------------
void partMorf() 
{
	Uint32 klocka=SDL_GetTicks()-effektKlocka;
	
	float v= klocka/550.0f;
	
	rect.x = 0;
	rect.y = 0;
	rect.w = picBild -> w;
	rect.h = picBild -> h;
	SDL_BlitSurface(picSkarm, NULL, mainScreen, &rect);	
	
	for(int i=0;i<antalPrickar;i++)	
	{
		Point p;
		Point b;
		Point k;
		Point s;
		
		Point startP;
		startP.x=0;
		startP.y=400;
		startP.z=0;
/*
		Point slutP;
		slutP.x=0;
		slutP.y=200;
		slutP.z=0;
*/		
		p.x=plan2d[i].x;
		p.y=plan2d[i].y;
		p.z=plan2d[i].z;
		
		
		b.x=plan[i].x;
		b.y=plan[i].y;
		b.z=plan[i].z;

		k.x=kuben[i].x;
		k.y=kuben[i].y;
		k.z=kuben[i].z;
		
		s.x=sprangd[i].x;
		s.y=sprangd[i].y;
		s.z=sprangd[i].z;

		b=rotateY(b,klocka/600.0f);
		p=rotateY(p,klocka/600.0f);
		k=rotateY(k,klocka/600.0f);
		//s=rotateY(s,klocka/600.0f);

		b=rotateZ(b,klocka/500.0f);
		p=rotateZ(p,klocka/500.0f);
		k=rotateZ(k,klocka/500.0f);
		//s=rotateZ(s,klocka/500.0f);

		float procV=(klocka-6030.0f)/2000.0f;
		float procV2=(klocka-12000.0f)/2000.0f;
		float procV3=(klocka-16500.0f)/6000.0f;
		
//		objY= (int)(110.0f*cos(klocka/1000.0f))-100;
//		p.y+=objY;
		//objY=sin(klocka/1000.0f);
		unsigned char pr=255;
		unsigned char pg=10;
		unsigned char pb=10;

		
		switch(morfStep)
		{
			case 0:
				drawMovedDot(startP,p,sin(PI*0.5*klocka/5000.0f),pr,pg,pb);
			break;
			
			case 1:
				drawMovedDot(p,b,0,pr,pg,pb);
			break;
			
			case 2:
				drawMovedDot(p,k,sin(procV*PI*0.5f),pr,pg,pb);
			break;
			
			case 3:
				drawMovedDot(k,b,0,pr,pg,pb);
			break;				

			case 4:
				drawMovedDot(k,b,sin(procV2*PI*0.5f),pr,pg,pb);
			break;
			
			case 5:
				drawMovedDot(b,k,0,pr,pg,pb);
			break;				

			case 6:
				drawMovedDot(b,s,sin(procV3*PI*0.5f),pr,pg,pb);
			break;
			
		}
		
		if(morfStep==0 && klocka>5000.0f)
			morfStep++;
		if(morfStep==1 && klocka>6030.0f)
			morfStep++;
		if(morfStep==2 && procV>1)
			morfStep++;
		if(morfStep==3 && klocka>12000.0f)
			morfStep++;
		if(morfStep==4 && procV2>1)
			morfStep++;
		if(morfStep==5 && klocka>16500.0f)
			morfStep++;		
		if(morfStep==6 && procV3>1)
			morfStep++;		
/*
		else if(klocka<11000.0f)
			drawMovedDot(k,b,0.5f+0.5*sin(klocka/500.0f),105,105,255);
		else if(klocka<32500.0f)
			drawMovedDot(b,k,0,105,105,255);
			*/
//   	    drawMovedDot(k,b,0.5f+0.5*sin(klocka/500.0f),105,105,255);
   	    
		//drawMovedDot(k,b,0,105,105,255);

	}
		
	SDL_Flip( mainScreen );
}
//----------------------------------------------------------

			
//----------------------------------------------------------
// part3D: med skroll
//----------------------------------------------------------
void part3D() 
{
	Uint32 klocka=SDL_GetTicks();
	
	float v= klocka/550.0f;
	int skrollVarde = (int)( (klocka-skrollNollstall)/70.0f);
	if(skrollVarde>=SKROLL_TECKEN*6-SKROLL_WIDTH)
		skrollNollstall=klocka;
	for(int y=0;y<SKROLL_HEIGHT;y++)
	{
		for(int x=0;x<SKROLL_WIDTH;x++)	
		{
			Point p;
			Point b;
			
			p.x=skrollPlan[y*SKROLL_WIDTH+x].x;
			p.y=skrollPlan[y*SKROLL_WIDTH+x].y;
			p.z=skrollPlan[y*SKROLL_WIDTH+x].z;
			
			b.x=plan[y*SKROLL_WIDTH+x].x;
			b.y=plan[y*SKROLL_WIDTH+x].y;
			b.z=plan[y*SKROLL_WIDTH+x].z;
			
			p=rotateX(p,klocka/600.0f);
			p=rotateZ(p,klocka/1200.0f);
			//p=rotateY(p,klocka/740.0f);
			
			//b=rotateY(b,klocka/877.0f);
			
			if(skrollText[y*SKROLL_TECKEN*6+x + skrollVarde])
				drawDotStor(p.x,p.y,p.z,237,244,14);
		      //drawMovedDot(p,b,0,237,50,14);
			
//		      drawMovedDot(b,p,0.5f+0.5*cos(klocka/1000.0f),237,244,14);
			else
				drawDotStor(p.x,p.y,p.z,79,81,4);
//		      drawMovedDot(p,b,0,79,81,4);		   
//		      drawMovedDot(b,p,0.5f+0.5*cos(klocka/1000.0f),79,81,4);		   
		}
	}
	SDL_Flip( mainScreen );
}
//----------------------------------------------------------




//----------------------------------------------------------
// partIntro: dunk dunk dunk
//----------------------------------------------------------
void partIntro()
{
	Uint32 klocka=SDL_GetTicks()-effektKlocka;
	
	
	rect.x = 0;
	rect.y = 0;
	rect.w = picSkarm -> w;
	rect.h = picSkarm -> h;
	SDL_BlitSurface(picSkarm, NULL, mainScreen, &rect);
	
	rect.x = 0;
	rect.y = 0;
	rect.h = 240;
	rect.w = 320;

	if(klocka>2900)
		rect.x = 111;
	if(klocka>3250)
		rect.x = 142;
	if(klocka>3600)
		rect.x = 195;
	if(klocka>3950)
		rect.x = 233;
	if(klocka>4300)
		rect.x = 272;

	SDL_FillRect(mainScreen,&rect,SDL_MapRGB(fmt, 158,132,132));
	
	
	SDL_Flip( mainScreen );
}
//----------------------------------------------------------




//----------------------------------------------------------
// partEnd: skrollar slutet
//----------------------------------------------------------
void partEnd()
{
	Uint32 klocka=SDL_GetTicks()-effektKlocka;
	
	rect.x = 0;
	if(rect.y>-10000)
		rect.y = -(int)(3500+3500*sin(-klocka/8000.0f +0.8f));
		//rect.y = -(int)((klocka*klocka)/60000.0f+klocka/50.0f);
		
	rect.w = picEnd -> w;
	rect.h = picEnd -> h;
	SDL_BlitSurface(picEnd, NULL, mainScreen, &rect);
	
	SDL_Flip( mainScreen );
}
//----------------------------------------------------------







//----------------------------------------------------------
// partPix: Rita bilder
//----------------------------------------------------------
void partPix() 
{
	Uint32 klocka=SDL_GetTicks()-effektKlocka;
	
	setpixel(mainScreen,100,100,255,0,0);
	
	rect.x = 0;
	rect.y = 0;
	rect.w = picSavann -> w;
	rect.h = picSavann -> h;
	SDL_BlitSurface(picSavann, NULL, mainScreen, &rect);
	
	for(int i=0;i<ANTAL_GNUER;i++)
	{
		ritaEnGnu(gnuX[i]-ANTAL_GNUER*X_PER_GNU+(int)((klocka-mainKlocka)/4.0f),gnuY[i]+(int)(3.0*sin(klocka*(float)i*0.001f)));
	}
	
	

	SDL_Flip( mainScreen );
}
//----------------------------------------------------------





//----------------------------------------------------------
// Ritar en gnu p givna koordinater
//----------------------------------------------------------
void ritaEnGnu(int x, int y)
{
	rect.x = x;
	rect.y = y;
	rect.w = picGnu -> w;
	rect.h = picGnu -> h;

	SDL_BlitSurface(picGnu, NULL, mainScreen, &rect);
}
//----------------------------------------------------------
	
	






//----------------------------------------------------------
// Initiera SDL
//----------------------------------------------------------
int InitializeSDL(int argc, char* argv[]) 
{
	if( SDL_Init(SDL_INIT_VIDEO  | SDL_INIT_TIMER|SDL_INIT_AUDIO) < 0) 
	{
		fprintf(stderr, "Could not initialize SDL: %s\n",SDL_GetError());
		return -1;
	}
	atexit(SDL_Quit);
	
	if(Mix_OpenAudio(audio_rate, audio_format, audio_channels, audio_buffers)) {
		printf("Unable to open audio!\n");
		exit(1);
	}

	Mix_QuerySpec(&audio_rate, &audio_format, &audio_channels);

    if(FULLSCREEN)
	   mainScreen = SDL_SetVideoMode(WIDTH, HEIGHT, BPP, SDL_HWSURFACE|SDL_ANYFORMAT|SDL_FULLSCREEN);
	else
	   mainScreen = SDL_SetVideoMode(WIDTH, HEIGHT, BPP, SDL_HWSURFACE|SDL_ANYFORMAT);
			
	if( !mainScreen )
	{
		fprintf(stderr, "Couldn't create a surface: %s\n",
		SDL_GetError());
		return -1;
	}

	SDL_WM_SetCaption("GNU Demo!", "GNU Demo!");
	
    fmt=mainScreen->format;
	
	SDL_ShowCursor(SDL_DISABLE);
	return 0;
}
//----------------------------------------------------------


//----------------------------------------------------------
// Main
//----------------------------------------------------------
int main(int argc, char* argv[])
{
	SDL_Event event;
	int exitkey = 0;
	int active = 1;
	int xinc = 1;
	
	// Initiera SDL
	if(InitializeSDL(argc,argv)) {
		fprintf(stderr, "Could not initialize SDL...exiting\n");
		return -1;
	}
	
	//----------------------------------------------------------
    // PreCalc PLASMA
	//----------------------------------------------------------
	karta = new unsigned char[WIDTH*HEIGHT*4];
	for(int y=0;y<HEIGHT*2;y++)
	{
		for(int x=0;x<WIDTH*2;x++)
		{
			karta[y*WIDTH*2+x] = (int)(54 + 53 * ( sin( sqrt( (240-y)*(240-y)+(320-x)*(320-x) )/16 ) )) ;
            //(int)(79+78.0f*sin((float)(1.5f*(float)(WIDTH*2-x)/(float)WIDTH*3.0f*(float)y/(float)HEIGHT))); 
		}
	}
	karta2 = new unsigned char[WIDTH*HEIGHT*4];
	for(int y=0;y<HEIGHT*2;y++)
	{
		for(int x=0;x<WIDTH*2;x++)
		{
			karta2[y*WIDTH*2+x] = 54 + (int)(53.0 * cos( (float)x/(25.0f+10.0f*cos((float)y/97.0f)) ) * sin( (float)y/(36.0f+12.0f*sin((float)x/67.0f))));
 
		}
	}	
	karta3 = new unsigned char[WIDTH*HEIGHT*4];
	for(int y=0;y<HEIGHT*2;y++)
	{
		for(int x=0;x<WIDTH*2;x++)
		{
			karta3[y*WIDTH*2+x] = (int)(20+19.0f*sin((float)(sqrt(y*y+x*x))/200.0f)); 
		}
	}	

	kartaUt = new unsigned char[WIDTH*HEIGHT];
	
	palettR = new unsigned char[256];
	palettG = new unsigned char[256];
	palettB = new unsigned char[256];
	//----------------------------------------------------------
 	
	
	
	//----------------------------------------------------------
    // Boll, skapa en 3d-boll
	//----------------------------------------------------------
	plan = new Point[antalPrickar];
	int i=0;
	for(int ring=0;ring<antalRingar;ring++)
	{
		float vRing = ((PI*(float)ring)/(float)(antalRingar));
		for(float v=0.0f;v<PI2;v+=PI2/(float)antalPrickarPerRing)
		{						
			if(i<antalPrickar)
			{
				plan[i].x = (float)radie*cos(vRing)*cos(v);
				plan[i].y = (float)radie*cos(vRing)*sin(v);
				plan[i].z = radie*sin(vRing);
			}
			if(i+1<antalPrickar)
			{
				plan[i+1].x = (float)radie*cos(vRing)*cos(v);
				plan[i+1].y = (float)radie*cos(vRing)*sin(v);
				plan[i+1].z = radie*sin(-vRing);
			}
			i+=2;
		}
	}
	//----------------------------------------------------------
	

	
	//----------------------------------------------------------
    // Boll, skapa sprngd
	//----------------------------------------------------------
	sprangd = new Point[antalPrickar];
	i=0;
	for(int ring=0;ring<antalRingar;ring++)
	{
		float vRing = ((PI*(float)ring)/(float)(antalRingar));
		for(float v=0.0f;v<PI2;v+=PI2/(float)antalPrickarPerRing)
		{						
			if(i<antalPrickar)
			{
				sprangd[i].x = (float)radie*100*cos(vRing)*cos(v);
				sprangd[i].y = (float)radie*100*cos(vRing)*sin(v);
				sprangd[i].z = radie*100*sin(vRing);
			}
			if(i+1<antalPrickar)
			{
				sprangd[i+1].x = (float)radie*100*cos(vRing)*cos(v);
				sprangd[i+1].y = (float)radie*100*cos(vRing)*sin(v);
				sprangd[i+1].z = radie*100*sin(-vRing);
			}
			i+=2;
		}
	}
	//----------------------------------------------------------
	
	
	
	
	
	//----------------------------------------------------------
	// Skapar ett 2D-plan	
	//----------------------------------------------------------
	plan2d = new Point[antalPrickar];
	
	int sidlangd = (int)sqrt(antalPrickar);	
	for(int y=0; y<sidlangd; y++)
	{
		for(int x=0; x<sidlangd; x++)
		{
			plan2d[y*sidlangd+x].x = (x - sidlangd/2)*10;
			plan2d[y*sidlangd+x].y = (y - sidlangd/2)*10;
			plan2d[y*sidlangd+x].z = 0;
		}
	}
	//----------------------------------------------------------

	//----------------------------------------------------------
	// Skapar ett 2D-plan	
	//----------------------------------------------------------
	kuben = new Point[antalPrickar];
	int pPerLinje = antalPrickar/12;
	float mellan = 2*radie/pPerLinje;
		
	for(int i=0; i<pPerLinje; i++)
	{
		// X-linjer
		kuben[i+0*pPerLinje].x = -radie + mellan*i;
		kuben[i+0*pPerLinje].y = -radie;
		kuben[i+0*pPerLinje].z = -radie;
		
		kuben[i+1*pPerLinje].x = -radie + mellan*i;
		kuben[i+1*pPerLinje].y = +radie;
		kuben[i+1*pPerLinje].z = -radie;
		
		kuben[i+2*pPerLinje].x = -radie + mellan*i;
		kuben[i+2*pPerLinje].y = -radie;
		kuben[i+2*pPerLinje].z = +radie;
		
		kuben[i+3*pPerLinje].x = -radie + mellan*i;
		kuben[i+3*pPerLinje].y = +radie;
		kuben[i+3*pPerLinje].z = +radie;
		
		// Y-linjer
		kuben[i+4*pPerLinje].x = -radie;
		kuben[i+4*pPerLinje].y = -radie + mellan*i;
		kuben[i+4*pPerLinje].z = -radie;
		
		kuben[i+5*pPerLinje].x = +radie;
		kuben[i+5*pPerLinje].y = -radie + mellan*i;
		kuben[i+5*pPerLinje].z = -radie;
		
		kuben[i+6*pPerLinje].x = -radie;
		kuben[i+6*pPerLinje].y = -radie+ mellan*i;
		kuben[i+6*pPerLinje].z = +radie;
		
		kuben[i+7*pPerLinje].x = +radie;
		kuben[i+7*pPerLinje].y = -radie + mellan*i;
		kuben[i+7*pPerLinje].z = +radie;

		// Z-linjer
		kuben[i+8*pPerLinje].x = -radie;
		kuben[i+8*pPerLinje].y = -radie;
		kuben[i+8*pPerLinje].z = -radie + mellan*i;
		
		kuben[i+9*pPerLinje].x = +radie;
		kuben[i+9*pPerLinje].y = -radie;
		kuben[i+9*pPerLinje].z = -radie + mellan*i;
		
		kuben[i+10*pPerLinje].x = -radie;
		kuben[i+10*pPerLinje].y = +radie;
		kuben[i+10*pPerLinje].z = -radie + mellan*i;
		
		kuben[i+11*pPerLinje].x = +radie;
		kuben[i+11*pPerLinje].y = +radie;
		kuben[i+11*pPerLinje].z = -radie + mellan*i;
				
	}
	for(int i=pPerLinje*12;i<antalPrickar;i++)
	{
		kuben[i].x = -radie + mellan*(i-pPerLinje*12);
		kuben[i].y = -radie;
		kuben[i].z = -radie;		
	}
	//----------------------------------------------------------


	//----------------------------------------------------------
    // PreCalc Skrollen
	//----------------------------------------------------------
	skrollPlan = new Point[SKROLL_WIDTH*SKROLL_HEIGHT];
	for(int y=0; y<SKROLL_HEIGHT; y++)
	{
		for(int x=0; x<SKROLL_WIDTH; x++)
		{
			skrollPlan[y*SKROLL_WIDTH+x].x = (x - SKROLL_WIDTH/2)*10;
			skrollPlan[y*SKROLL_WIDTH+x].y = (y - SKROLL_HEIGHT/2)*10;
			skrollPlan[y*SKROLL_WIDTH+x].z = 0;
		}
	}
	//Skrolltecken
	skrollText = new bool[SKROLL_TECKEN*6*7];
	for(int i=0;i<SKROLL_TECKEN*6*7;i++)
		skrollText[i]=0;

	addBokstav(skrollText,FONT_ );
	addBokstav(skrollText,FONT_ );
	addBokstav(skrollText,FONT_ );
	addBokstav(skrollText,FONT_ );
	addBokstav(skrollText,FONT_ );
	addBokstav(skrollText,FONT_ );
	addBokstav(skrollText,FONT_ );
	addBokstav(skrollText,FONT_ );
	addBokstav(skrollText,FONT_ );
	addBokstav(skrollText,FONT_T);
	addBokstav(skrollText,FONT_H);
	addBokstav(skrollText,FONT_I);
	addBokstav(skrollText,FONT_S);	
	addBokstav(skrollText,FONT_ );
	addBokstav(skrollText,FONT_I);
	addBokstav(skrollText,FONT_S);
	addBokstav(skrollText,FONT_ );
	addBokstav(skrollText,FONT_F);
	addBokstav(skrollText,FONT_R);
	addBokstav(skrollText,FONT_E);
	addBokstav(skrollText,FONT_E);
	addBokstav(skrollText,FONT_ );
	addBokstav(skrollText,FONT_S);
	addBokstav(skrollText,FONT_O);
	addBokstav(skrollText,FONT_F);
	addBokstav(skrollText,FONT_T);
	addBokstav(skrollText,FONT_W);
	addBokstav(skrollText,FONT_A);
	addBokstav(skrollText,FONT_R);
	addBokstav(skrollText,FONT_E);
	addBokstav(skrollText,FONT_ );
	addBokstav(skrollText,FONT_ );
	addBokstav(skrollText,FONT_ );
	addBokstav(skrollText,FONT_ );

	skrollNollstall=SDL_GetTicks();	
	//----------------------------------------------------------



	//----------------------------------------------------------
    // Musik och bilder
    //----------------------------------------------------------
	music = Mix_LoadMUS("music.ogg");
	
//    rw = SDL_RWFromZZIP("p/gnu.bmp", "r");
    rw = SDL_RWFromZZIP("pp/gnu.bmp", "r");
    picGnu = SDL_LoadBMP_RW(rw, 0);
    SDL_FreeRW(rw);

//    rw = SDL_RWFromZZIP("pix/glass.bmp", "r");
//    rw = SDL_RWFromZZIP("pp/glass.bmp", "r");
//    picGlass = SDL_LoadBMP_RW(rw, 0);
//    SDL_FreeRW(rw);

//    rw = SDL_RWFromZZIP("pix/savann.bmp", "r");
    rw = SDL_RWFromZZIP("pp/savann.bmp", "r");
    picSavann = SDL_LoadBMP_RW(rw, 0);
    SDL_FreeRW(rw);

//    rw = SDL_RWFromZZIP("pix/skarm.bmp", "r");
    rw = SDL_RWFromZZIP("pp/skarm.bmp", "r");
    picSkarm = SDL_LoadBMP_RW(rw, 0);
    SDL_FreeRW(rw);

 //   rw = SDL_RWFromZZIP("pix/scrollen.bmp", "r");
    rw = SDL_RWFromZZIP("pp/scrollen.bmp", "r");
    picEnd = SDL_LoadBMP_RW(rw, 0);
    SDL_FreeRW(rw);

//    rw = SDL_RWFromZZIP("pix/bild.bmp", "r");
    rw = SDL_RWFromZZIP("pp/bild.bmp", "r");
    picBild = SDL_LoadBMP_RW(rw, 0);
    SDL_FreeRW(rw);

    SDL_SetColorKey(picGnu, SDL_SRCCOLORKEY,  SDL_MapRGB(fmt, 255, 0, 255));
	//----------------------------------------------------------



	//----------------------------------------------------------
	// Generera gnu-positioner
	//----------------------------------------------------------
	gnuX = new int[ANTAL_GNUER];
	gnuY = new int[ANTAL_GNUER];
    for(int i=0;i<ANTAL_GNUER;i++)
	{
		gnuX[i] = i*X_PER_GNU;
		gnuY[i] = (2*HEIGHT)/3 + (int)( (HEIGHT/10)* sin(((float)i/(float)10.0f)*25.0f));
	}
    //----------------------------------------------------------




	//----------------------------------------------------------
    // Huvudslingan, som kontinuerligt anropar DrawPicture();
    //----------------------------------------------------------
	Mix_PlayMusic(music, 0);
	mainKlocka=SDL_GetTicks();
	while(!exitkey && !sluta)
	{
		if(active)
			drawPicture();
			
		
		while(SDL_PollEvent(&event)) {
			switch( event.type ) {
				case SDL_QUIT:
					exitkey = 1;
					printf("Got quit event!\n");
					break;
				case SDL_KEYDOWN:
					printf("Key hit - exiting!\n");
					exitkey = 1;
					break;
				case SDL_ACTIVEEVENT:
					if ( event.active.state & 
							SDL_APPACTIVE ) {
						if( event.active.gain )
							active = 1;
						else 
							active = 0;
							
					}
					break;
			}
		}
	}
	//----------------------------------------------------------
	
	return 0;
}
//----------------------------------------------------------






//----------------------------------------------------------
// Lgger till en bokstav i skrollen p ett fult stt
//----------------------------------------------------------
void addBokstav(bool *remsa, bool *bokstav)
{
	for(int y=0;y<7;y++)
	{
		for(int x=0;x<5;x++)
		   remsa[(6-y)*SKROLL_TECKEN*6+iText+x]=bokstav[y*5+x];
	}
	iText+=6;
}
//----------------------------------------------------------





//----------------------------------------------------------
// SetPixel
//----------------------------------------------------------
void setpixel(SDL_Surface *screen, int x, int y, Uint8 r, Uint8 g, Uint8 b)
{
	Uint8 *ubuff8;
	Uint16 *ubuff16; 
	Uint32 *ubuff32;
	Uint32 color;
	
	if(x<0 || y<0 || x>=WIDTH || y>=HEIGHT)
		return;
	
	/* Lock the screen, if needed */
	if(SDL_MUSTLOCK(screen)) {
		if(SDL_LockSurface(screen) < 0) 
			return;
	}
 
	/* Get the color */
	color = SDL_MapRGB( screen->format, r, g, b );
	
	/* How we draw the pixel depends on the bitdepth */

	switch(screen->format->BytesPerPixel) {
		case 1: 
			ubuff8 = (Uint8*) screen->pixels;
			ubuff8 += (y * screen->pitch) + x; 
			*ubuff8 = (Uint8) color;
			break;
		case 2:
			ubuff8 = (Uint8*)screen->pixels;
			ubuff8 += (y * screen->pitch) + (x * screen->format->BytesPerPixel);
			ubuff16 = (Uint16*) ubuff8;
			*ubuff16 = (Uint16) color; 
			break;  
		case 3:
			ubuff8 = (Uint8*) screen->pixels;
			ubuff8 += (y * screen->pitch) + (x * screen->format->BytesPerPixel);
			r = (color>>screen->format->Rshift)&0xFF;
			g = (color>>screen->format->Gshift)&0xFF;
			b = (color>>screen->format->Bshift)&0xFF;
			ubuff8[0] = r;
			ubuff8[1] = g;
			ubuff8[2] = b;
			break;
		case 4:
			ubuff32 = (Uint32*) screen->pixels;
			ubuff32 += ((y*screen->pitch)>>2) + x;
			*ubuff32 = color;
			break;
		default:
			fprintf(stderr, "Error: Unknown bitdepth!\n");
	}

	/* Unlock the screen if needed */
	if(SDL_MUSTLOCK(screen)) {
		SDL_UnlockSurface(screen);
	}
}
//----------------------------------------------------------






//----------------------------------------------------------
// drawDot: ritar en stor prick i 3D
//----------------------------------------------------------
void drawDot(float x, float y, float z, unsigned char r, unsigned char g, unsigned char b)
{
	if(z+OGA==0)return;
	if(z>200||x>400||y>400||z<-200||x<-400||y<-400)return;

	int xNy=(int)(WIDTH/2+(x*OGA)/(z+OGA) );
	int yNy=HEIGHT-(int)(HEIGHT/2+(y*OGA)/(z+OGA) );
		
	setpixel(mainScreen,xNy,yNy-1,r,g,b);
	setpixel(mainScreen,xNy-1,yNy,r,g,b);
	setpixel(mainScreen,xNy,yNy,r,g,b);
	setpixel(mainScreen,xNy+1,yNy,r,g,b);
	setpixel(mainScreen,xNy,yNy+1,r,g,b);
	
	setpixel(mainScreen,xNy+1,yNy-1,r,g,b);
	setpixel(mainScreen,xNy+2,yNy,r,g,b);
	setpixel(mainScreen,xNy-1,yNy+1,r,g,b);
	setpixel(mainScreen,xNy+1,yNy+1,r,g,b);
	setpixel(mainScreen,xNy+2,yNy+1,r,g,b);	
	setpixel(mainScreen,xNy,yNy+2,r,g,b);
	setpixel(mainScreen,xNy+1,yNy+2,r,g,b);	
}
//----------------------------------------------------------




//----------------------------------------------------------
// drawDotStor: ritar en stor prick i 3D
//----------------------------------------------------------
void drawDotStor(float x, float y, float z, unsigned char r, unsigned char g, unsigned char b)
{
	if(z+OGA==0)return;
	if(z>200||x>400||y>400||z<-200||x<-400||y<-400)return;

	int xNy=(int)(WIDTH/2+(x*OGA)/(z+OGA) );
	int yNy=HEIGHT-(int)(HEIGHT/2+(y*OGA)/(z+OGA) );
		
	setpixel(mainScreen,xNy,yNy-1,r,g,b);
	setpixel(mainScreen,xNy-1,yNy,r,g,b);
	setpixel(mainScreen,xNy,yNy,r,g,b);
	setpixel(mainScreen,xNy+1,yNy,r,g,b);
	setpixel(mainScreen,xNy,yNy+1,r,g,b);
	
	setpixel(mainScreen,xNy+1,yNy-1,r,g,b);
	setpixel(mainScreen,xNy+2,yNy,r,g,b);
	setpixel(mainScreen,xNy-1,yNy+1,r,g,b);
	setpixel(mainScreen,xNy+1,yNy+1,r,g,b);
	setpixel(mainScreen,xNy+2,yNy+1,r,g,b);	
	setpixel(mainScreen,xNy,yNy+2,r,g,b);
	setpixel(mainScreen,xNy+1,yNy+2,r,g,b);	
	
	setpixel(mainScreen,xNy,yNy-2,0,0,0);
	setpixel(mainScreen,xNy+1,yNy-2,0,0,0);
	setpixel(mainScreen,xNy-1,yNy-1,0,0,0);
	setpixel(mainScreen,xNy+2,yNy-1,0,0,0);
	setpixel(mainScreen,xNy-2,yNy,0,0,0);
	setpixel(mainScreen,xNy+3,yNy,0,0,0);
	setpixel(mainScreen,xNy-2,yNy+1,0,0,0);
	setpixel(mainScreen,xNy+3,yNy+1,0,0,0);
	setpixel(mainScreen,xNy-1,yNy+2,0,0,0);
	setpixel(mainScreen,xNy+2,yNy+2,0,0,0);
	setpixel(mainScreen,xNy,yNy+3,0,0,0);
	setpixel(mainScreen,xNy+1,yNy+3,0,0,0);
}
//----------------------------------------------------------



//----------------------------------------------------------
// drawMovedDot: rittar en prick p resa mellan tv 
// positioner i 3D. Placerar efter given % (0=frn 1=till)
//----------------------------------------------------------
void drawMovedDot(Point fran, Point till, float p, unsigned char r, unsigned char g, unsigned char b)
{
	Point ut;
	
	ut.x = (till.x - fran.x)*p + fran.x;
	ut.y = (till.y - fran.y)*p + fran.y;
	ut.z = (till.z - fran.z)*p + fran.z;
	
	drawDot(ut.x,ut.y,ut.z,r,g,b);
}
//----------------------------------------------------------







//----------------------------------------------------------
// Roterar en 3D-punkt i Y-planet
//----------------------------------------------------------
Point rotateY(Point p, float v)
{
	Point ut;
	ut.x= (p.x*cos(v)-p.z*sin(v));
	ut.y= p.y;
	ut.z= (p.z*cos(v)+p.x*sin(v));
	
	return ut;
}
//----------------------------------------------------------

//----------------------------------------------------------
// Roterar en 3D-punkt i Y-planet
//----------------------------------------------------------
Point rotateX(Point p, float v)
{
	Point ut;
	ut.x= p.x;
	ut.y= (p.z*cos(v)-p.y*sin(v));
	ut.z= (p.y*cos(v)+p.z*sin(v));
	
	return ut;
}
//----------------------------------------------------------

//----------------------------------------------------------
// Roterar en 3D-punkt i Y-planet
//----------------------------------------------------------
Point rotateZ(Point p, float v)
{
	Point ut;
	ut.x= (p.x*cos(v)-p.y*sin(v));
	ut.y= (p.y*cos(v)+p.x*sin(v));
	ut.z= p.z;
	
	return ut;
}
//----------------------------------------------------------
