///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef SHARED_THSTORAGE_H
#define SHARED_THSTORAGE_H
///////////////////////////////////////////////////////////////////////////////////////////////////

#define THERESA_STORAGESTRING		"ThStorage1"
#define THERESA_STORAGEVERSION	1

///////////////////////////////////////////////////////////////////////////////////////////////////

/*! \interface IThStorage
 *	The storage interface. Represents a generic hierarchial file system.
 */
/*! \fn IThStorage* IThStorage::createStorage(const char* name)
 *	Creates a new storage file in this storage.
 *	\param name [in] The name of the storage file to create.
 *	\return A IThStorage interface to the created storage file, or \c NULL if an error ocurrs.
 */
/*! \fn IThStorage* IThStorage::openStorage(const char* name)
 *	Opens an existing storage file in this storage.
 *	\param name [in] The name of the storage file to open.
 *	\return A IThStorage interface to the opened storage file, or \c NULL if an error ocurrs.
 */
/*! \fn bool IThStorage::createFolder(const char* name)
 *	Creates a new folder in this storage.
 *	\param name [in] The name of the folder to create.
 *	\return \c true if successful, or \c false if an error ocurrs.
 */
/*! \fn bool IThStorage::destroyFolder(const char* name)
 *	Destroys an existing folder in this storage.
 *	\param name [in] The name of the folder to destroy.
 *	\return \c true if successful, or \c false if an error ocurrs.
 */
/*! \fn bool IThStorage::listFolders(const char* folderName, ThStringList& folders)
 *	Lists all the subfolders contained in the specified folder.
 *	\param folderName [in] The folder whose contents to list.
 *	\param folders [out] The list of all subfolders within the specified folder.
 *	\return \c true if successful, or \c false if an error ocurrs.
 */
/*! \fn bool IThStorage::listFiles(const char* folderName, ThStringList& files)
 *	Lists all the files contained in the specified folder.
 *	\param folderName [in] The folder whose contents to list.
 *	\param files [out] The list of all files within the specified folder.
 *	\return \c true if successful, or \c false if an error ocurrs.
 */
/*! \fn IThStream* IThStorage::createFile(const char* name)
 *	Creates a new file in this storage.
 *	\param name [in] The name of the file to create.
 *	\return A IThStream interface to the created file, or \c NULL if an error ocurrs.
 */
/*! \fn IThStream* IThStorage::openFile(const char* name)
 *	Opens an existing file in this storage.
 *	\param name [in] The name of the file to open.
 *	\return A IThStream interface to the opened file, or \c NULL if an error ocurrs.
 */
/*!	\fn bool IThStorage::destroyFile(const char* name)
 *	Destroys an existing file in this storage.
 *	\param name [in] The name of the file to destroy.
 *	\return \c true if successful, or \c false if an error ocurrs.
 */
/*! \fn bool IThStorage::create(void)
 *	Creates the global storage singleton object.
 *	\return \c true if successful, or \c false if an error ocurrs.
 */
interface IThStorage
{
// constructors
	virtual														~IThStorage(void);
// storage methods
	virtual IThStorage*								createStorage(const char* name) = 0;
	virtual IThStorage*								openStorage(const char* name) = 0;
// folder methods
	virtual bool											createFolder(const char* name) = 0;
	virtual bool											destroyFolder(const char* name) = 0;
	virtual bool											listFolders(const char* folderName, ThStringList& folders) = 0;
	virtual bool											listFiles(const char* folderName, ThStringList& files) = 0;
// file methods
	virtual IThStream*								createFile(const char* name) = 0;
	virtual IThStream*								openFile(const char* name) = 0;
	virtual bool											requestFile(ThString& name, bool exist) = 0;
	virtual bool											destroyFile(const char* name) = 0;
// static methods
	static bool												create(const char* fileName = NULL);
};

///////////////////////////////////////////////////////////////////////////////////////////////////

//! The global storage singleton object.
extern ThSingleton<IThStorage> Storage;

///////////////////////////////////////////////////////////////////////////////////////////////////
#endif /* SHARED_THSTORAGE_H */
///////////////////////////////////////////////////////////////////////////////////////////////////
