///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef SHARED_THSERVER_H
#define SHARED_THSERVER_H
///////////////////////////////////////////////////////////////////////////////////////////////////

enum
{
	THID_INVALID,

	THID_ANNOUNCE,

	THID_SERVER,
	THID_DISPLAY,
	THID_MUSIC,
	THID_SYSTEM,
	THID_EFFECT,

	THID_CUSTOM_BASE = 1000,
};

enum
{
	THMSG_INVALID,

	THMSG_UPDATE,
	THMSG_RENDER,

	THMSG_REQUEST_EXIT,

	THMSG_DISPLAY_OPEN,
	THMSG_DISPLAY_CLOSE,
	THMSG_DISPLAY_RESIZE,

	THMSG_MUSIC_OPEN,
	THMSG_MUSIC_CLOSE,
	THMSG_MUSIC_SYNC,
	
	THMSG_SYSTEM_START,
	THMSG_SYSTEM_STOP,
	THMSG_SYSTEM_PAUSE,
	THMSG_SYSTEM_RESUME,

	THMSG_CUSTOM_BASE = 1000,
};

///////////////////////////////////////////////////////////////////////////////////////////////////

class ThMessage
{
public:
// constructors
																		ThMessage(unsigned int message, unsigned int toID, unsigned int fromID);
// attributes
	unsigned int											getMessage(void) const;
	void															setMessage(unsigned int message);
	unsigned int											getToID(void) const;
	void															setToID(unsigned int toID);
	unsigned int											getFromID(void) const;
	void															setFromID(unsigned int fromID);
	const void*												getData(void) const;
	void															setData(const void* data);
private:
// data
	unsigned int											m_message;
	unsigned int											m_toID;
	unsigned int											m_fromID;
	const void*												m_data;
};

//-------------------------------------------------------------------------------------------------

class ThMessageItem : public ThMessage, public ThListItem<ThMessageItem>
{
public:
// constructors
																		ThMessageItem(unsigned int message, unsigned int toID, unsigned int fromID);
// data
	ThByteBlock												m_data;
};

//-------------------------------------------------------------------------------------------------

class ThServerObject : public ThListItem<ThServerObject>
{
public:
// constructors
																		ThServerObject(unsigned int id = THID_INVALID);
	virtual														~ThServerObject(void);
// callbacks
	virtual bool											recieve(ThMessage* message);
// attributes
	unsigned int											getID(void) const;
protected:
// methods
	void															sendMessage(unsigned int message, unsigned int toID, const void* data = NULL);
	void															postMessage(unsigned int message, unsigned int toID, const void* data = NULL, unsigned int size = 0);
private:
// data
	unsigned int											m_id;
};

///////////////////////////////////////////////////////////////////////////////////////////////////

interface IThServer
{
// constructors
	virtual														~IThServer(void);
// methods
	virtual void											sendMessage(unsigned int message, unsigned int toID, unsigned int fromID, const void* data = NULL) = 0;
	virtual void											postMessage(unsigned int message, unsigned int toID, unsigned int fromID, const void* data = NULL, unsigned int size = 0) = 0;
// object methods
	virtual unsigned int							createObjectID(void) = 0;
	virtual bool											registerObject(ThServerObject* object) = 0;
	virtual ThServerObject*						findObject(unsigned int id) = 0;
// static methods
	static bool												create(void);
};

///////////////////////////////////////////////////////////////////////////////////////////////////

extern ThSingleton<IThServer> Server;

///////////////////////////////////////////////////////////////////////////////////////////////////
#endif /* SHARED_THSERVER_H */
///////////////////////////////////////////////////////////////////////////////////////////////////
