///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////

#define THERESA_LOGFILE "Theresa.log"

#if defined(THERESA_DEBUG_BUILD) || defined(THERESA_RELEASE_BUILD)

	#define THERROR(x) Error->write##x

#else

	#define THERROR(x)

#endif

///////////////////////////////////////////////////////////////////////////////////////////////////

interface IThError
{
// constructors
	virtual														~IThError(void);
// methods
	virtual void											write(const char* name, const char* format, ...) = 0;
	virtual void											display(const char* name, const char* format, ...) = 0;
	virtual bool											request(const char* name, const char* format, ...) = 0;
// static methods
	static bool												create(void);
};

///////////////////////////////////////////////////////////////////////////////////////////////////

extern ThSingleton<IThError> Error;

///////////////////////////////////////////////////////////////////////////////////////////////////
