///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef SHARED_THEFFECT_H
#define SHARED_THEFFECT_H
///////////////////////////////////////////////////////////////////////////////////////////////////

enum
{
	THLAYER_BACKGROUND,
	THLAYER_NORMAL,
	THLAYER_FOREGROUND,
	THLAYER_TOPMOST,
};

///////////////////////////////////////////////////////////////////////////////////////////////////

class ThEffectObject : public ThListItem<ThEffectObject>
{
public:
// constructors
																		ThEffectObject(void);
	virtual														~ThEffectObject(void);
// callbacks
	virtual bool											update(float deltaTime);
	virtual bool											render(void);
// attributes
	float															getLifeTime(void) const;
	void															setLifeTime(float lifeTime);
	float															getTimeLeft(void) const;
private:
// data
	float															m_lifeTime;
	float															m_timeLeft;
};

///////////////////////////////////////////////////////////////////////////////////////////////////

interface IThEffect
{
// constructors
	virtual														~IThEffect(void);
// methods
	virtual bool											registerObject(ThEffectObject* object, unsigned int layerID) = 0;
// static methods
	static bool												create(void);
};

///////////////////////////////////////////////////////////////////////////////////////////////////

extern ThSingleton<IThEffect> Effect;

///////////////////////////////////////////////////////////////////////////////////////////////////
#endif /* SHARED_THEFFECT_H */
///////////////////////////////////////////////////////////////////////////////////////////////////
