///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef SHARED_THCHUNK_H
#define SHARED_THCHUNK_H
///////////////////////////////////////////////////////////////////////////////////////////////////

enum
{
	//! Unknown data format.
	THCHUNK_UNKNOWN,

	//! Data consists of 8-bit bytes.
	THCHUNK_BYTE,
	//! Data consists of 16-bit words.
	THCHUNK_WORD,
	//! Data consists of 32-bit dwords.
	THCHUNK_DWORD,
	//! Data consists of 64-bit qwords.
	THCHUNK_QWORD,
	//! Data consists of 32-bit IEEE floats.
	THCHUNK_FLOAT,
	//! Data consists of 64-bit IEEE doubles.
	THCHUNK_DOUBLE,
	//! Data consists of zero-terminated ASCII character strings.
	THCHUNK_STRING,

	//! Root for storage filesystem.
	THCHUNK_STORAGE,
	//! Folder in storage fileystem.
	THCHUNK_STGFOLDER,
	//! File in storage filesystem.
	THCHUNK_STGFILE,

	//! Start value for user-defined chunk type IDs.
	THCHUNK_CUSTOM_BASE = 1000,
};

///////////////////////////////////////////////////////////////////////////////////////////////////

class ThChunk : public ThListItem<ThChunk>
{
public:
// constructors
																		ThChunk(ThChunk* parent = NULL);
																		~ThChunk(void);
// method
	bool															load(IThInputStream* stream);
	bool															save(IThOutputStream* stream);
	void															release(void);
// attributes
	unsigned int											getType(void) const;
	void															setType(unsigned int type);
	const char*												getName(void) const;
	void															setName(const char* name);
	unsigned int											getHash(void) const;
	ThChunk*													getFirstChild(void);
	IThDynamicBlock*									getBlock(void);
	IThStream*												getStream(void);
private:
// classes
	struct Header;
// data
	unsigned int											m_type;
	ThString													m_name;
	unsigned int											m_hash;
	IThDynamicBlock*									m_block;
	ThPtr<IThStream>									m_stream;
	ThItemList<ThChunk>								m_children;
};

///////////////////////////////////////////////////////////////////////////////////////////////////
#endif /* SHARED_THCHUNK_H */
///////////////////////////////////////////////////////////////////////////////////////////////////
