///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef THERESA_THSTORAGE_H
#define THERESA_THSTORAGE_H
///////////////////////////////////////////////////////////////////////////////////////////////////

class ThFileStream : public IThStream, public ThListItem<ThFileStream>
{
public:
// constructors
																		ThFileStream(HANDLE file, const char* name);
																		~ThFileStream(void);
// interface methods
	unsigned int											read(void* data, unsigned int size);
	unsigned int											write(const void* data, unsigned int size);
	unsigned int											skip(unsigned int size);
	bool															seek(unsigned int position);
	bool															truncate(void);
// interface attributes
	bool															isEOF(void) const;
	unsigned int											getSize(void) const;
	unsigned int											getPosition(void) const;
private:
// data
	HANDLE														m_file;
	ThString													m_name;
};

//-------------------------------------------------------------------------------------------------

class ThRootStorage : public IThStorage
{
public:
// constructors
																		ThRootStorage(void);
																		~ThRootStorage(void);
// methods
	bool															open(void);
	void															close(void);
// interface storage methods
	IThStorage*												createStorage(const char* name);
	IThStorage*												openStorage(const char* name);
// interface folder methods
	bool															createFolder(const char* name);
	bool															destroyFolder(const char* name);
	bool															listFolders(const char* folderName, ThStringList& folders);
	bool															listFiles(const char* folderName, ThStringList& files);
// interface file methods
	IThStream*												createFile(const char* name);
	IThStream*												openFile(const char* name);
	bool															requestFile(ThString& name, bool exist);
	bool															destroyFile(const char* name);
private:
// data
	ThItemList<ThFileStream>					m_files;
};

//-------------------------------------------------------------------------------------------------

class ThChunkStorage : public IThStorage
{
public:
// constructors
																		ThChunkStorage(void);
																		~ThChunkStorage(void);
// methods
	bool															open(const char* name);
	bool															open(IThStream* stream);
	void															close(void);
// interface storage methods
	IThStorage*												createStorage(const char* name);
	IThStorage*												openStorage(const char* name);
// interface folder methods
	bool															createFolder(const char* name);
	bool															destroyFolder(const char* name);
	bool															listFolders(const char* folderName, ThStringList& folders);
	bool															listFiles(const char* folderName, ThStringList& files);
// interface file methods
	IThStream*												createFile(const char* name);
	IThStream*												openFile(const char* name);
	bool															requestFile(ThString& name, bool exist);
	bool															destroyFile(const char* name);
private:
// classes
	struct Header;
// methods
	ThChunk*													findChild(ThChunk* parent, const char* name);
	ThChunk*													findChild(const char*& name, bool complete);
	bool															validatePath(const char* path);
// data
	ThPtr<IThStream>									m_stream;
	ThChunk														m_root;
};

///////////////////////////////////////////////////////////////////////////////////////////////////
#endif /* THERESA_THSTORAGE_H */
///////////////////////////////////////////////////////////////////////////////////////////////////
