///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef THERESA_THSERVER_H
#define THERESA_THSERVER_H
///////////////////////////////////////////////////////////////////////////////////////////////////

class ThServer : public IThServer
{
public:
// constructors
																		ThServer(void);
																		~ThServer(void);
// methods
	bool															open(void);
	void															close(void);
// interface methods
	void															sendMessage(unsigned int message, unsigned int toID, unsigned int fromID, const void* data = NULL);
	void															postMessage(unsigned int message, unsigned int toID, unsigned int fromID, const void* data = NULL, unsigned int size = 0);
// interface object methods
	unsigned int											createObjectID(void);
	bool															registerObject(ThServerObject* object);
	ThServerObject*										findObject(unsigned int id);
private:
// methods
	void															sendMessage(ThMessage* message);
	void															recieve(ThMessage* message);
// data
	unsigned int											m_nextID;
	ThItemList<ThMessageItem>					m_messages;
	ThItemList<ThServerObject>				m_objects;
};

///////////////////////////////////////////////////////////////////////////////////////////////////
#endif /* THERESA_THSERVER_H */
///////////////////////////////////////////////////////////////////////////////////////////////////
