///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef THERESA_THEFFECT_H
#define THERESA_THEFFECT_H
///////////////////////////////////////////////////////////////////////////////////////////////////

class ThEffect : public IThEffect, public ThServerObject
{
public:
// constructors
																		ThEffect(void);
	virtual														~ThEffect(void);
// methods
	bool															open(void);
	void															close(void);
// interface methods
	bool															registerObject(ThEffectObject* object, unsigned int layerID);
private:
// classes
	class Layer;
// methods
	Layer*														findLayer(unsigned int id);
// callbacks
	bool															recieve(ThMessage* message);
// data
	ThItemList<Layer>									m_layers;
};

//-------------------------------------------------------------------------------------------------

class ThEffect::Layer : public ThListItem<Layer>
{
public:
// constructors
																		Layer(unsigned int id);
// data
	unsigned int											m_id;
	ThItemList<ThEffectObject>				m_objects;
};

///////////////////////////////////////////////////////////////////////////////////////////////////
#endif /* THERESA_THEFFECT_H */
///////////////////////////////////////////////////////////////////////////////////////////////////
