///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef THERESA_THDISPLAY_H
#define THERESA_THDISPLAY_H
///////////////////////////////////////////////////////////////////////////////////////////////////

class ThDisplayWindow : public ThWindow
{
public:
// constructors
																		ThDisplayWindow(void);
// methods
	bool															create(unsigned int width, unsigned int height, bool fullscreen);
// attributes
	unsigned int											getWidth(void);
	unsigned int											getHeight(void);
private:
// callbacks
	LRESULT														message(UINT message, WPARAM wParam, LPARAM lParam);
// data
	unsigned int											m_width;
	unsigned int											m_height;
};

//-------------------------------------------------------------------------------------------------

class ThDisplay : public IThDisplay, public ThServerObject
{
public:
// constructors
																		ThDisplay(void);
																		~ThDisplay(void);
// methods
	bool															open(unsigned int width, unsigned int height);
	void															close(void);
// interface methods
	void															update(void);
// interface texture methods
	bool															loadTexture(const char* fileName, bool mipmap = false);
	bool															loadTexture(IThInputStream* stream, bool mipmap = false);
// interface attributes
	unsigned int											getWidth(void);
	unsigned int											getHeight(void);
	const char*												getTitle(void);
	void															setTitle(const char* title);
private:
// callbacks
	bool															recieve(ThMessage* message);
// data
	bool															m_fullscreen;
	ThString													m_title;
	ThPtr<ThDisplayWindow>						m_window;
	HDC																m_dc;
	HGLRC															m_rc;
};

///////////////////////////////////////////////////////////////////////////////////////////////////
#endif /*THERESA_THDISPLAY_H*/
///////////////////////////////////////////////////////////////////////////////////////////////////
