///////////////////////////////////////////////////////////////////////////////////////////////////
//
// kilometer years from france - a demo
//
// Copyright (C) 2002 Camilla Drefvenborg <elmindreda@home.se>
// Copyright (C) 2002 Ronny Gripenborn <rymdknark@yahoo.com>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////

#include <Theresa.h>

#include "Demo.h"

#include "HyperCube.h"

#include <ctime>

///////////////////////////////////////////////////////////////////////////////////////////////////

Demo::Demo(void)
{
}

Demo::~Demo(void)
{
	if (m_textures)
	{
		glDeleteTextures(m_textures.getCount(), m_textures);
		m_textures.release();
	}

	postMessage(THMSG_REQUEST_EXIT, THID_ANNOUNCE);
}

bool Demo::open(void)
{
	if (!Server->registerObject(this))
		return false;

	if (!Effect->registerObject(this, THLAYER_BACKGROUND))
		return false;

	m_textures.allocate(58);

	glGenTextures(m_textures.getCount(), m_textures);

	if (!loadSolid(m_textures[0], "data\\wrong.png"))
		return false;

	if (!loadSolid(m_textures[1], "data\\iwin.png"))
		return false;

	if (!loadAlpha(m_textures[2], "data\\hypercube.png"))
		return false;

	if (!loadAlpha(m_textures[3], "data\\presents.png"))
		return false;

	if (!loadAlpha(m_textures[4], "data\\demoname1.png"))
		return false;

	if (!loadAlpha(m_textures[5], "data\\demoname2.png"))
		return false;

	if (!loadAlpha(m_textures[6], "data\\dot.png", true))
		return false;

	if (!loadAlpha(m_textures[7], "data\\a.png"))
		return false;

	if (!loadAlpha(m_textures[8], "data\\really.png"))
		return false;

	if (!loadAlpha(m_textures[9], "data\\nearly.png"))
		return false;

	if (!loadAlpha(m_textures[10], "data\\year.png"))
		return false;

	if (!loadAlpha(m_textures[11], "data\\four.png"))
		return false;

	if (!loadAlpha(m_textures[12], "data\\your.png"))
		return false;

	if (!loadAlpha(m_textures[13], "data\\kilometer.png"))
		return false;

	if (!loadAlpha(m_textures[14], "data\\not.png"))
		return false;

	if (!loadAlpha(m_textures[15], "data\\is.png"))
		return false;

	if (!loadAlpha(m_textures[16], "data\\years.png"))
		return false;

	if (!loadAlpha(m_textures[17], "data\\these.png"))
		return false;

	if (!loadAlpha(m_textures[18], "data\\they.png"))
		return false;

	if (!loadAlpha(m_textures[19], "data\\with.png"))
		return false;

	if (!loadAlpha(m_textures[20], "data\\boy.png"))
		return false;

	if (!loadAlpha(m_textures[21], "data\\children.png"))
		return false;

	if (!loadAlpha(m_textures[22], "data\\french.png"))
		return false;

	if (!loadAlpha(m_textures[23], "data\\lock1.png"))
		return false;

	if (!loadAlpha(m_textures[24], "data\\lock2.png"))
		return false;

	if (!loadAlpha(m_textures[25], "data\\lock3.png"))
		return false;

	if (!loadAlpha(m_textures[26], "data\\lock4.png"))
		return false;

	if (!loadAlpha(m_textures[27], "data\\gazman.png"))
		return false;

	if (!loadAlpha(m_textures[28], "data\\elmindreda.png"))
		return false;

	if (!loadAlpha(m_textures[29], "data\\cybear.png"))
		return false;

	if (!loadAlpha(m_textures[30], "data\\salome.png"))
		return false;

	if (!loadAlpha(m_textures[31], "data\\kuntakinte.png"))
		return false;

	if (!loadSolid(m_textures[32], "data\\arrows.png"))
		return false;

	if (!loadSolid(m_textures[33], "data\\beer.png"))
		return false;

	if (!loadSolid(m_textures[34], "data\\cccp.png"))
		return false;

	if (!loadSolid(m_textures[35], "data\\dollar.png"))
		return false;

	if (!loadSolid(m_textures[36], "data\\flower.png"))
		return false;

	if (!loadSolid(m_textures[37], "data\\france.png"))
		return false;

	if (!loadSolid(m_textures[38], "data\\gear.png"))
		return false;

	if (!loadSolid(m_textures[39], "data\\hash.png"))
		return false;

	if (!loadSolid(m_textures[40], "data\\japan.png"))
		return false;

	if (!loadSolid(m_textures[41], "data\\moon.png"))
		return false;

	if (!loadSolid(m_textures[42], "data\\mouse.png"))
		return false;

	if (!loadSolid(m_textures[43], "data\\slashdot.png"))
		return false;

	if (!loadSolid(m_textures[44], "data\\smiley1.png"))
		return false;

	if (!loadSolid(m_textures[45], "data\\smiley2.png"))
		return false;

	if (!loadSolid(m_textures[46], "data\\smiley3.png"))
		return false;

	if (!loadSolid(m_textures[47], "data\\splat.png"))
		return false;

	if (!loadSolid(m_textures[48], "data\\star.png"))
		return false;

	if (!loadSolid(m_textures[49], "data\\sun.png"))
		return false;

	if (!loadSolid(m_textures[50], "data\\wheel.png"))
		return false;

	if (!loadSolid(m_textures[51], "data\\rymdknark.png"))
		return false;

	if (!loadSolid(m_textures[52], "data\\gazmantext.png"))
		return false;

	if (!loadSolid(m_textures[53], "data\\elmindredatext.png"))
		return false;

	if (!loadSolid(m_textures[54], "data\\cybeartext.png"))
		return false;

	if (!loadSolid(m_textures[55], "data\\salometext.png"))
		return false;

	if (!loadSolid(m_textures[56], "data\\kuntakintetext.png"))
		return false;

	if (!loadSolid(m_textures[57], "data\\rymdknarktext.png"))
		return false;

	glEnable(GL_COLOR_MATERIAL);
	glEnable(GL_DEPTH_TEST);

	glColorMaterial(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE);

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(90.f, (float) System->getDisplay()->getWidth() / (float) System->getDisplay()->getHeight(), 1.f, 1000.f);

	glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();

	glShadeModel(GL_FLAT);

	glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);

	return true;
}

bool Demo::recieve(ThMessage* message)
{
	switch (message->getMessage())
	{
		case THMSG_MUSIC_SYNC:
		{
			const unsigned char data = *reinterpret_cast<const unsigned char*>(message->getData());

			switch (data)
			{
				case 0x00:
				{
					System->stop();
					break;
				}

				case 0x01:
				{
					if (m_prism)
						m_prism.release();
					else
					{
						glClearColor(0.f, 0.f, 0.f, 0.f);

						m_prism = new DemoPrism();

						if (!m_prism->open())
							return false;

						if (!Effect->registerObject(m_prism, THLAYER_NORMAL))
							return false;
					}

					break;
				}

				case 0x02:
				{
					if (m_prism)
						m_prism->signal();

					break;
				}

				case 0x03:
				{
					if (m_wrong)
						m_wrong.release();
					else
					{
						m_wrong = new DemoImage(m_textures[0], ThArea(0.f, 0.f, 1.f, 1.f));

						if (!m_wrong->open())
							return false;

						if (!Effect->registerObject(m_wrong, THLAYER_TOPMOST))
							return false;
					}

					break;
				}

				case 0x04:
				{
					if (m_iwin)
						m_iwin.release();
					else
					{
						m_iwin = new DemoImage(m_textures[1], ThArea(0.f, 0.f, 1.f, 1.f));

						if (!m_iwin->open())
							return false;

						if (!Effect->registerObject(m_iwin, THLAYER_TOPMOST))
							return false;
					}

					break;
				}

				case 0x05:
				{
					if (m_hypercube)
						m_hypercube.release();
					else
					{
						m_hypercube = new DemoImage(m_textures[2], ThArea(0.2f, 0.4f, 0.6f, 0.2f), true);

						if (!m_hypercube->open())
							return false;

						if (!Effect->registerObject(m_hypercube, THLAYER_FOREGROUND))
							return false;
					}

					break;
				}

				case 0x06:
				{
					if (m_presents)
						m_presents.release();
					else
					{
						m_presents = new DemoImage(m_textures[3], ThArea(0.2f, 0.4f, 0.6f, 0.2f), true);

						if (!m_presents->open())
							return false;

						if (!Effect->registerObject(m_presents, THLAYER_FOREGROUND))
							return false;
					}

					break;
				}

				case 0x07:
				{
					if (m_blobs)
						m_blobs.release();
					else
					{
						glClearColor(0.22f, 0.8f, 0.22f, 1.f);

						m_blobs = new DemoBlobs();

						if (!m_blobs->open())
							return false;

						if (!Effect->registerObject(m_blobs, THLAYER_NORMAL))
							return false;
					}

					break;
				}

				case 0x08:
				{
					if (m_blobs)
						m_blobs->signal(0);

					break;
				}

				case 0x09:
				{
					if (m_blobs)
						m_blobs->signal(1);

					break;
				}

				case 0x0A:
				{
					if (m_words)
						m_words.release();
					else
					{
						glClearColor(0.f, 0.407f, 0.22f, 1.f);

						m_words = new DemoWords(m_textures + 7);

						if (!m_words->open())
							return false;

						if (!Effect->registerObject(m_words, THLAYER_NORMAL))
							return false;
					}

					break;
				}

				case 0x0B:
				{
					if (m_words)
						m_words->signal();

					break;
				}

				case 0x0C:
				{
					if (m_kilometer[0])
					{
						m_kilometer[0].release();
						m_kilometer[1].release();
					}
					else
					{
						m_kilometer[0] = new DemoImage(m_textures[4], ThArea(0.2f, 0.3f, 0.6f, 0.2f), true);
						m_kilometer[1] = new DemoImage(m_textures[5], ThArea(0.2f, 0.5f, 0.6f, 0.2f), true);

						if (!m_kilometer[0]->open())
							return false;

						if (!m_kilometer[1]->open())
							return false;

						if (!Effect->registerObject(m_kilometer[0], THLAYER_FOREGROUND))
							return false;

						if (!Effect->registerObject(m_kilometer[1], THLAYER_FOREGROUND))
							return false;
					}

					break;
				}

				case 0x0D:
				{
					if (m_blobs)
						m_blobs->signal(2);

					break;
				}

				case 0x0E:
				{
					if (m_blobs)
						m_blobs->signal(3);

					break;
				}

				case 0x0F:
				{
					if (m_stars)
						m_stars.release();
					else
					{
						glClearColor(0.f, 0.407f, 0.22f, 1.f);

						m_stars = new DemoStars(m_textures[6]);

						if (!m_stars->open())
							return false;

						if (!Effect->registerObject(m_stars, THLAYER_FOREGROUND))
							return false;
					}

					break;
				}

				case 0x10:
				{
					if (m_hyper)
						m_hyper.release();
					else
					{
						glClearColor(1.f, 0.526f, 0.02f, 1.f);

						m_hyper = new DemoHyper();

						if (!m_hyper->open())
							return false;

						if (!Effect->registerObject(m_hyper, THLAYER_NORMAL))
							return false;
					}

					break;
				}

				case 0x11:
				{
					if (m_locks)
						m_locks.release();
					else
					{
						glClearColor(0.f, 0.407f, 0.22f, 1.f);

						m_locks = new DemoLocks(m_textures + 23);

						if (!m_locks->open())
							return false;

						if (!Effect->registerObject(m_locks, THLAYER_NORMAL))
							return false;
					}

					break;
				}

				case 0x12:
				{
					if (m_stars)
						m_stars->signal();

					break;
				}

				case 0x13:
				{
					if (m_gazman[0])
					{
						m_gazman[0].release();
						m_gazman[1].release();
					}
					else
					{
						m_gazman[0] = new DemoImage(m_textures[27], ThArea(0.f, 0.2f, 0.4f, 0.8f), true);
						m_gazman[1] = new DemoImage(m_textures[52], ThArea(0.4f, 0.6f, 0.6f, 0.4f), true);

						if (!m_gazman[0]->open())
							return false;

						if (!m_gazman[1]->open())
							return false;

						if (!Effect->registerObject(m_gazman[0], THLAYER_FOREGROUND))
							return false;

						if (!Effect->registerObject(m_gazman[1], THLAYER_FOREGROUND))
							return false;
					}

					break;
				}

				case 0x14:
				{
					if (m_elmindreda[0])
					{
						m_elmindreda[0].release();
						m_elmindreda[1].release();
					}
					else
					{
						m_elmindreda[0] = new DemoImage(m_textures[28], ThArea(0.f, 0.2f, 0.4f, 0.8f), true);
						m_elmindreda[1] = new DemoImage(m_textures[53], ThArea(0.4f, 0.6f, 0.6f, 0.4f), true);

						if (!m_elmindreda[0]->open())
							return false;

						if (!m_elmindreda[1]->open())
							return false;

						if (!Effect->registerObject(m_elmindreda[0], THLAYER_FOREGROUND))
							return false;

						if (!Effect->registerObject(m_elmindreda[1], THLAYER_FOREGROUND))
							return false;
					}

					break;
				}

				case 0x15:
				{
					if (m_cybear[0])
					{
						m_cybear[0].release();
						m_cybear[1].release();
					}
					else
					{
						m_cybear[0] = new DemoImage(m_textures[29], ThArea(0.f, 0.2f, 0.4f, 0.8f), true);
						m_cybear[1] = new DemoImage(m_textures[54], ThArea(0.4f, 0.6f, 0.6f, 0.4f), true);

						if (!m_cybear[0]->open())
							return false;

						if (!m_cybear[1]->open())
							return false;

						if (!Effect->registerObject(m_cybear[0], THLAYER_FOREGROUND))
							return false;

						if (!Effect->registerObject(m_cybear[1], THLAYER_FOREGROUND))
							return false;
					}

					break;
				}

				case 0x16:
				{
					if (m_salome[0])
					{
						m_salome[0].release();
						m_salome[1].release();
					}
					else
					{
						m_salome[0] = new DemoImage(m_textures[30], ThArea(0.f, 0.2f, 0.4f, 0.8f), true);
						m_salome[1] = new DemoImage(m_textures[55], ThArea(0.4f, 0.6f, 0.6f, 0.4f), true);

						if (!m_salome[0]->open())
							return false;

						if (!m_salome[1]->open())
							return false;

						if (!Effect->registerObject(m_salome[0], THLAYER_FOREGROUND))
							return false;

						if (!Effect->registerObject(m_salome[1], THLAYER_FOREGROUND))
							return false;
					}

					break;
				}

				case 0x17:
				{
					if (m_locks)
						m_locks->signal();

					break;
				}

				case 0x18:
				{
					if (m_ronny)
						m_ronny.release();
					else
					{
						glClearColor(0.f, 0.407f, 0.22f, 1.f);

						m_ronny = new DemoRonny();

						if (!m_ronny->open())
							return false;

						if (!Effect->registerObject(m_ronny, THLAYER_NORMAL))
							return false;
					}

					break;
				}

				case 0x19:
				{
					if (m_kuntakinte[0])
					{
						m_kuntakinte[0].release();
						m_kuntakinte[1].release();
					}
					else
					{
						m_kuntakinte[0] = new DemoImage(m_textures[31], ThArea(0.f, 0.2f, 0.4f, 0.8f), true);
						m_kuntakinte[1] = new DemoImage(m_textures[56], ThArea(0.4f, 0.6f, 0.6f, 0.4f), true);

						if (!m_kuntakinte[0]->open())
							return false;

						if (!m_kuntakinte[1]->open())
							return false;

						if (!Effect->registerObject(m_kuntakinte[0], THLAYER_FOREGROUND))
							return false;

						if (!Effect->registerObject(m_kuntakinte[1], THLAYER_FOREGROUND))
							return false;
					}

					break;
				}

				case 0x1A:
				{
					glClearColor(0.f, 0.407f, 0.22f, 1.f);

					break;
				}

				case 0x1B:
				{
					glClearColor(1.f, 0.526f, 0.02f, 1.f);

					break;
				}

				case 0x1D:
				{
					if (m_rymdknark[0])
					{
						m_rymdknark[0].release();
						m_rymdknark[1].release();
					}
					else
					{
						m_rymdknark[0] = new DemoImage(m_textures[51], ThArea(0.f, 0.2f, 0.4f, 0.8f), true);
						m_rymdknark[1] = new DemoImage(m_textures[57], ThArea(0.4f, 0.6f, 0.6f, 0.4f), true);

						if (!m_rymdknark[0]->open())
							return false;

						if (!m_rymdknark[1]->open())
							return false;

						if (!Effect->registerObject(m_rymdknark[0], THLAYER_FOREGROUND))
							return false;

						if (!Effect->registerObject(m_rymdknark[1], THLAYER_FOREGROUND))
							return false;
					}

					break;
				}

				case 0x1E:
				{
					if (m_flash)
						m_flash.release();
					else
					{
						m_flash = new DemoFlash(m_textures + 32, 19);

						if (!m_flash->open())
							return false;

						if (!Effect->registerObject(m_flash, THLAYER_TOPMOST))
							return false;
					}

					break;
				}

				case 0x1F:
				{
					if (m_flash)
						m_flash->signal();

					break;
				}
			}

			break;
		}
	}

	return ThServerObject::recieve(message);
}

bool Demo::update(float deltaTime)
{
	if (!ThEffectObject::update(deltaTime))
		return false;

	return true;
}

bool Demo::render(void)
{
	if (!ThEffectObject::render())
		return false;

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	return true;
}

bool Demo::loadSolid(unsigned int texture, const char* fileName, bool mipmap)
{
	glBindTexture(GL_TEXTURE_2D, texture);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);

	if (!System->getDisplay()->loadTexture(fileName, mipmap))
		return false;

	return true;
}

bool Demo::loadAlpha(unsigned int texture, const char* fileName, bool mipmap)
{
	glBindTexture(GL_TEXTURE_2D, texture);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);

	if (!System->getDisplay()->loadTexture(fileName, mipmap))
		return false;

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////

DemoPrism::DemoPrism(void)
{
	m_mode  = 0;
	m_depth = 0.f;
	m_alpha = 0.f;
	m_angle = 0.f;
	m_list  = 0;
}

DemoPrism::~DemoPrism(void)
{
	glDeleteLists(m_list, 1);
}

bool DemoPrism::open(void)
{
	m_list = glGenLists(3);

	glNewList(m_list + 0, GL_COMPILE);

	glPushAttrib(GL_ENABLE_BIT | GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	glDisable(GL_CULL_FACE);
	glDepthMask(GL_FALSE);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE);

	glBegin(GL_QUADS);

	for (unsigned int i = 0;  i < 21;  i++)
	{
		const float x = (float) i * 10.f - 100.f;

		glVertex3f(x, -100.f, -100.f);
		glVertex3f(x, 100.f, -100.f);
		glVertex3f(x, 100.f, 100.f);
		glVertex3f(x, -100.f, 100.f);
	}

	glEnd();

	glPopAttrib();

	glEndList();

	glNewList(m_list + 1, GL_COMPILE);

	glPushAttrib(GL_ENABLE_BIT | GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glDisable(GL_CULL_FACE);
	glDepthMask(GL_FALSE);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE);

	glBegin(GL_QUADS);

	for (unsigned int i = 0;  i < 21;  i++)
	{
		const float y = (float) i * 10.f - 100.f;

		glVertex3f(-100.f, y, -100.f);
		glVertex3f(100.f, y, -100.f);
		glVertex3f(100.f, y, 100.f);
		glVertex3f(-100.f, y, 100.f);
	}

	glEnd();
	glPopAttrib();

	glEndList();

	glNewList(m_list + 2, GL_COMPILE);

	glPushAttrib(GL_ENABLE_BIT | GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glDisable(GL_CULL_FACE);
	glDepthMask(GL_FALSE);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE);

	glBegin(GL_QUADS);

	for (unsigned int i = 0;  i < 21;  i++)
	{
		const float z = (float) i * 10.f - 100.f;

		glVertex3f(-100.f, -100.f, z);
		glVertex3f(100.f, -100.f, z);
		glVertex3f(100.f, 100.f, z);
		glVertex3f(-100.f, 100.f, z);
	}

	glEnd();
	glPopAttrib();

	glEndList();

	return true;
}

void DemoPrism::signal(void)
{
	m_mode++;
}

bool DemoPrism::update(float deltaTime)
{
	if (!ThEffectObject::update(deltaTime))
		return false;

	if (m_mode)
	{
		if (m_mode & 1)
			m_angle -= deltaTime * 2.0f;
		else
			m_angle += deltaTime * 0.5f;
	}
	else
	{
		m_alpha += deltaTime * (0.25f / 7.f);
		if (m_alpha > 0.25f)
			m_alpha = 0.25f;

		m_depth += deltaTime * (300.f / 7.f);
		if (m_depth > 300.f)
			m_depth = 300.f;
	}

	return true;
}

bool DemoPrism::render(void)
{
	if (!ThEffectObject::render())
		return false;

	glPushMatrix();
  gluLookAt(0.f, 0.f, 0.f, 0.f, 0.f, -1.f, 0.f, 1.f, 0.f);

	if (m_depth)
		glTranslatef(0.f, 0.f, -m_depth);

	if (m_angle)
	{
		ThVector3 vector(1.f, 0.f, 1.f);
		vector.normalize();

		glRotatef(m_angle * 360.f, vector.x, vector.y, vector.z);
	}

	glColor4f(1.f, 0.f, 0.f, m_alpha);
	glCallList(m_list + 0);

	glColor4f(0.f, 1.f, 0.f, m_alpha);
	glCallList(m_list + 1);

	glColor4f(0.f, 0.f, 1.f, m_alpha);
	glCallList(m_list + 2);

	glPopMatrix();

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////

DemoImage::DemoImage(unsigned int texture, const ThArea& area, bool blend):
	m_texture(texture),
	m_area(area),
	m_blend(blend)
{
}

DemoImage::~DemoImage(void)
{
}

bool DemoImage::open(void)
{
	return true;
}

bool DemoImage::update(float deltaTime)
{
	if (!ThEffectObject::update(deltaTime))
		return false;

	return true;
}

bool DemoImage::render(void)
{
	if (!ThEffectObject::render())
		return false;

	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
	gluOrtho2D(0.f, 1.f, 1.f, 0.f);

	if (m_blend)
		glPushAttrib(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT | GL_ENABLE_BIT);
	else
		glPushAttrib(GL_DEPTH_BUFFER_BIT | GL_ENABLE_BIT);

	glEnable(GL_TEXTURE_2D);

	glDepthMask(GL_FALSE);

	if (m_blend)
	{
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	}

	glBindTexture(GL_TEXTURE_2D, m_texture);

	glColor3f(1.f, 1.f, 1.f);

	glBegin(GL_QUADS);

	glTexCoord2f(0.f, 0.f);
	glVertex2f(m_area.m_pos.x, m_area.m_pos.y);

	glTexCoord2f(0.f, 1.f);
	glVertex2f(m_area.m_pos.x, m_area.m_pos.y + m_area.m_size.y);

	glTexCoord2f(1.f, 1.f);
	glVertex2f(m_area.m_pos.x + m_area.m_size.x, m_area.m_pos.y + m_area.m_size.y);

	glTexCoord2f(1.f, 0.f);
	glVertex2f(m_area.m_pos.x + m_area.m_size.x, m_area.m_pos.y);

	glEnd();

	glPopAttrib();

	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////

DemoBlobs::DemoBlobs(void)
{
	m_light = false;
	m_wire  = false;
	m_twist = false;
	m_stop  = false;
	m_time  = 0.f;
}

DemoBlobs::~DemoBlobs(void)
{
}

bool DemoBlobs::open(void)
{
	m_blobs.allocate(4);

	for (unsigned int i = 0;  i < m_blobs.getCount();  i++)
	{
		m_blobs[i].m_vector.x = random() + 0.1f;
		m_blobs[i].m_vector.y = random();
		m_blobs[i].m_vector.z = random();
		m_blobs[i].m_vector.normalize();

		m_blobs[i].m_scale.x = (float) i * 1.0f + 2.f;
		m_blobs[i].m_scale.y = (float) i * 1.5f + 2.f;
		m_blobs[i].m_scale.z = (float) i * 1.5f + 2.f;

		m_blobs[i].m_speed = 400.f - (float) i * 100.f;
	}

	// Gazman-created random values follow

	m_blobs[0].m_position.x = 6.f;
	m_blobs[0].m_position.y = -5;
	m_blobs[0].m_position.z = 0.f;

	m_blobs[1].m_position.x = 3.f;
	m_blobs[1].m_position.y = 3.f;
	m_blobs[1].m_position.z = 0.f;

	m_blobs[2].m_position.x = 6.f;
	m_blobs[2].m_position.y = 0.f;
	m_blobs[2].m_position.z = 0.f;

	m_blobs[3].m_position.x = -3;
	m_blobs[3].m_position.y = 0.f;
	m_blobs[3].m_position.z = 0.f;

	return true;
}

void DemoBlobs::signal(unsigned int type)
{
	switch (type)
	{
		case 0:
			m_twist = !m_twist;
			break;
		case 1:
			m_wire = !m_wire;
			break;
		case 2:
			m_light = !m_light;
			break;
		case 3:
			m_stop = !m_stop;
			break;
	}
}

bool DemoBlobs::update(float deltaTime)
{
	if (!ThEffectObject::update(deltaTime))
		return false;

	if (!m_stop)
	{
		if (m_twist)
			m_time -= deltaTime * 3.f;
		else
			m_time += deltaTime;
	}

	return true;
}

bool DemoBlobs::render(void)
{
	if (!ThEffectObject::render())
		return false;

	glPushMatrix();
	gluLookAt(0.f, 0.f, 9.f, 0.f, 0.f, 0.f, 0.f, 1.f, 0.f);

	if (m_light)
		glPushAttrib(GL_CURRENT_BIT | GL_ENABLE_BIT);
	else
		glPushAttrib(GL_CURRENT_BIT);

	glColor3f(0.f, 0.407f, 0.22f);

	if (m_light)
	{
		glEnable(GL_LIGHTING);
		glEnable(GL_LIGHT0);
		glEnable(GL_NORMALIZE);

		ThVector4 vector(0.f, -1.f, 0.f, 0.f);
		glLightfv(GL_LIGHT0, GL_POSITION, vector);
	}

	for (unsigned int i = 0;  i < m_blobs.getCount();  i++)
	{
		glPushMatrix();

		glTranslatef(m_blobs[i].m_position.x, m_blobs[i].m_position.y, m_blobs[i].m_position.z);

		ThVector3 vector = m_blobs[i].m_vector;
		glRotatef(m_time * m_blobs[i].m_speed, vector.x, vector.y, vector.z);

		glScalef(m_blobs[i].m_scale.x, m_blobs[i].m_scale.y, m_blobs[i].m_scale.z);

		if (m_wire)
			auxWireSphere(1.f);
		else
			auxSolidSphere(1.f);

		glPopMatrix();
	}

	glPopAttrib();

	glPopMatrix();

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////

DemoStars::DemoStars(unsigned int texture):
	m_texture(texture)
{
	m_mode  = 0;
	m_time  = 0.f;
	m_size  = 0.01f;
	m_count = 0;
}

DemoStars::~DemoStars(void)
{
}

bool DemoStars::open(void)
{
	m_positions.allocate(m_count = 50);

	for (unsigned int i = 0;  i < m_positions.getCount();  i++)
	{
		m_positions[i].x = random();
		m_positions[i].y = random();
	}

	return true;
}

void DemoStars::signal(void)
{
	m_mode++;
	m_size += (float) m_mode * 0.01f;

	if (m_count > 10)
		m_count -= 5;
}

bool DemoStars::update(float deltaTime)
{
	if (!ThEffectObject::update(deltaTime))
		return false;

	m_time += deltaTime;

	return true;
}

bool DemoStars::render(void)
{
	if (!ThEffectObject::render())
		return false;

	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
	gluOrtho2D(0.f, 1.f, 1.f, 0.f);

	glMatrixMode(GL_MODELVIEW);
	glPushMatrix();

	glPushAttrib(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT | GL_ENABLE_BIT | GL_POINT_BIT);

	glDisable(GL_DEPTH_TEST);
	glDepthMask(GL_FALSE);
	glEnable(GL_TEXTURE_2D);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

	glColor3f(1.f, 0.526f, 0.02f);

	glBindTexture(GL_TEXTURE_2D, m_texture);

	for (unsigned int layer = 0;  layer < 2;  layer++)
	{
		glBegin(GL_QUADS);

		for (unsigned int i = 0;  i < m_count;  i++)
		{
			ThVector2 position = m_positions[i];

			glTexCoord2f(0.f, 0.f);
			glVertex2f(position.x - m_size, position.y - m_size);

			glTexCoord2f(1.f, 0.f);
			glVertex2f(position.x + m_size, position.y - m_size);

			glTexCoord2f(1.f, 1.f);
			glVertex2f(position.x + m_size, position.y + m_size);

			glTexCoord2f(0.f, 1.f);
			glVertex2f(position.x - m_size, position.y + m_size);
		}

		glEnd();

		{
			ThVector3 offset(0.01f, 0.01f, 0.f);

			ThMatrix3 rotation;
			rotation.setAngles(ThVector3(0.f, 0.f, m_time * 3.f));
			rotation.rotateVector(offset);

			glTranslatef(offset.x - m_size * 0.5f, offset.y - m_size * 0.5f, offset.z);
		}

		glScalef(1.1f, 1.1f, 1.f);
	}

	glPopAttrib();

	glMatrixMode(GL_PROJECTION);
	glPopMatrix();

	glMatrixMode(GL_MODELVIEW);
	glPopMatrix();

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////

DemoWords::DemoWords(unsigned int* textures):
	m_textures(textures)
{
	m_mode = 0;
	m_time = 0.f;
}

DemoWords::~DemoWords(void)
{
}

bool DemoWords::open(void)
{
	m_words.allocate(16);
	m_positions.allocate(16);

	for (unsigned int i = 0;  i < 16;  i++)
	{
		m_words[i].m_texture = m_textures[i];
		m_words[i].m_vector.x = random() + 0.1f;
		m_words[i].m_vector.y = random();
		m_words[i].m_vector.z = random();
		m_words[i].m_vector.normalize();

		m_positions[i].x = (float) (i & 0x7) * 3.f - 10.5f;
		m_positions[i].y = 6.f - ((i & 0x8) ? 12.f : 0.f);
		m_positions[i].z = 0.f;
	}

	// Gazman-created random values follow

	m_words[0x0].m_index = 0x0;
	m_words[0x1].m_index = 0xD;
	m_words[0x2].m_index = 0x7;
	m_words[0x3].m_index = 0xB;
	m_words[0x4].m_index = 0x3;
	m_words[0x5].m_index = 0x8;
	m_words[0x6].m_index = 0x6;
	m_words[0x7].m_index = 0xC;
	m_words[0x8].m_index = 0x2;
	m_words[0x9].m_index = 0x5;
	m_words[0xA].m_index = 0x9;
	m_words[0xB].m_index = 0x1;
	m_words[0xC].m_index = 0xE;
	m_words[0xD].m_index = 0xF;
	m_words[0xE].m_index = 0x4;
	m_words[0xF].m_index = 0xA;

	return true;
}

void DemoWords::signal(void)
{
	m_mode++;
}

bool DemoWords::update(float deltaTime)
{
	if (!ThEffectObject::update(deltaTime))
		return false;

	m_time += deltaTime;

	return true;
}

bool DemoWords::render(void)
{
	if (!ThEffectObject::render())
		return false;

	glPushAttrib(GL_COLOR_BUFFER_BIT | GL_CURRENT_BIT | GL_DEPTH_BUFFER_BIT | GL_ENABLE_BIT);

	glPushMatrix();
	gluLookAt(0.f, 0.f, 10.f, 0.f, 0.f, 0.f, 0.f, 1.f, 0.f);

	glDepthFunc(GL_LEQUAL);

	for (unsigned int i = 0;  i < 16;  i++)
	{
		glPushMatrix();

		ThVector3 position = m_positions[m_words[i].m_index];
		glTranslatef(position.x, position.y, position.z);

		glRotatef(m_time * 360.f, m_words[i].m_vector.x, m_words[i].m_vector.y, m_words[i].m_vector.z);

		if (i == m_mode)
			glColor3f(1.f, 0.526f, 0.02f);
		else
			glColor3f(1.f, 1.f, 1.f);

		auxSolidCube(1.5f);

		glColor3f(0.f, 0.f, 0.f);

		auxWireCube(1.5f);

		glPopMatrix();
	}

	glPopMatrix();

	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
	gluOrtho2D(0.f, 1.f, 1.f, 0.f);

	glEnable(GL_TEXTURE_2D);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

	glBindTexture(GL_TEXTURE_2D, m_words[m_mode].m_texture);

	glColor3f(1.f, 0.526f, 0.02f);

	glBegin(GL_QUADS);

	glTexCoord2f(0.f, 0.f);
	glVertex2f(0.2f, 0.4f);

	glTexCoord2f(0.f, 1.f);
	glVertex2f(0.2f, 0.6f);

	glTexCoord2f(1.f, 1.f);
	glVertex2f(0.8f, 0.6f);

	glTexCoord2f(1.f, 0.f);
	glVertex2f(0.8f, 0.4f);

	glEnd();

	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);

	glPopAttrib();

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////

DemoHyper::DemoHyper(void)
{
	m_mode = 0;
	m_time = 0.f;
}

DemoHyper::~DemoHyper(void)
{
}

bool DemoHyper::open(void)
{
	return true;
}

void DemoHyper::signal(void)
{
	m_mode++;
}

bool DemoHyper::update(float deltaTime)
{
	if (!ThEffectObject::update(deltaTime))
		return false;

	m_time += deltaTime;

	return true;
}

bool DemoHyper::render(void)
{
	if (!ThEffectObject::render())
		return false;

	glPushAttrib(GL_ENABLE_BIT | GL_POLYGON_BIT);

	glEnable(GL_CULL_FACE);

	glPushClientAttrib(GL_CLIENT_VERTEX_ARRAY_BIT);
	glEnableClientState(GL_VERTEX_ARRAY);

	glPushMatrix();
	gluLookAt(0.f, 0.f, 25.f, 0.f, 0.f, 0.f, 0.f, 1.f, 0.f);

	glRotatef(m_time * 100.f, 0.f, 1.f, 1.f);

	glColor3f(0.f, 0.407f, 0.22f);

	glVertexPointer(3, GL_FLOAT, 0, innerPoints);
	glDrawElements(GL_QUADS, INNER_INDEX_COUNT, GL_UNSIGNED_INT, innerIndices);

	glVertexPointer(3, GL_FLOAT, 0, outerPoints);
	glDrawElements(GL_QUADS, OUTER_INDEX_COUNT, GL_UNSIGNED_INT, outerIndices);

	glPopMatrix();

	glPopClientAttrib();

	glPopAttrib();

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////

DemoLocks::DemoLocks(unsigned int* textures):
	m_textures(textures)
{
	m_speed = 0.f;
	m_index = 0;
}

DemoLocks::~DemoLocks(void)
{
}

bool DemoLocks::open(void)
{
	m_angles[0] = 360.f;
	m_angles[1] = 240.f;
	m_angles[2] = 120.f;
	m_angles[3] = 0.f;

	m_static[0] = false;
	m_static[1] = false;
	m_static[2] = false;
	m_static[3] = false;

	m_index = 3;
	m_speed = 50.f;

	return true;
}

void DemoLocks::signal(void)
{
	m_speed = 360.f - m_speed;
}

bool DemoLocks::update(float deltaTime)
{
	if (!ThEffectObject::update(deltaTime))
		return false;

	if (m_index)
	{
		m_angles[m_index] += m_speed * deltaTime;

		if (m_angles[m_index] > m_angles[m_index - 1])
			m_index--;

		for (unsigned int i = m_index + 1;  i < 4;  i++)
			m_angles[i] = m_angles[i - 1];
	}

	return true;
}

bool DemoLocks::render(void)
{
	if (!ThEffectObject::render())
		return false;

	glPushAttrib(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT | GL_ENABLE_BIT);

	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
	gluOrtho2D(0.f, 1.f, 1.f, 0.f);

	glMatrixMode(GL_MODELVIEW);

	glEnable(GL_TEXTURE_2D);

	glDepthMask(GL_FALSE);

	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

	for (unsigned int i = 0;  i < 4;  i++)
	{
		glPushMatrix();
		glTranslatef(0.5f, 0.5f, 0.f);
		glRotatef(m_angles[i], 0.f, 0.f, 1.f);

		glBindTexture(GL_TEXTURE_2D, m_textures[i]);

		if (i & 1)
			glColor3f(0.f, 0.407f, 0.22f);
		else
			glColor3f(1.f, 0.526f, 0.02f);

		glBegin(GL_QUADS);

		glTexCoord2f(0.f, 0.f);
		glVertex2f(-0.2f, -0.2f);

		glTexCoord2f(0.f, 1.f);
		glVertex2f(-0.2f, 0.2f);

		glTexCoord2f(1.f, 1.f);
		glVertex2f(0.2f, 0.2f);

		glTexCoord2f(1.f, 0.f);
		glVertex2f(0.2f, -0.2f);

		glEnd();

		glPopMatrix();
	}

	glMatrixMode(GL_PROJECTION);
	glPopMatrix();

	glMatrixMode(GL_MODELVIEW);

	glPopAttrib();

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////

DemoRonny::DemoRonny(void)
{
	m_scale = 0.f;
	m_delay = 0.f;
	m_count = 0;
	m_index = 0;
}

DemoRonny::~DemoRonny(void)
{
}

bool DemoRonny::open(void)
{
	m_objects.allocate(6);

	// rymdknark-generated geometric values

	m_objects[0].m_points.allocate(8);
	m_objects[0].m_points[0].x	= -50.f;
	m_objects[0].m_points[0].y	= -50.f;
	m_objects[0].m_points[1].x	= 0.f;
	m_objects[0].m_points[1].y	= -25.f;
	m_objects[0].m_points[2].x	= 50.f;
	m_objects[0].m_points[2].y	= -50.f;
	m_objects[0].m_points[3].x	= 25.f;
	m_objects[0].m_points[3].y	= 0.f;
	m_objects[0].m_points[4].x	= 50.f;
	m_objects[0].m_points[4].y	= 50.f;
	m_objects[0].m_points[5].x	= 0.f;
	m_objects[0].m_points[5].y	= 25.f;
	m_objects[0].m_points[6].x	= -50.f;
	m_objects[0].m_points[6].y	= 50.f;
	m_objects[0].m_points[7].x	= -25.f;
	m_objects[0].m_points[7].y	= 0.f;

	m_objects[1].m_points.allocate(12);
	m_objects[1].m_points[0].x	= -25.f;
	m_objects[1].m_points[0].y	= -50.f;
	m_objects[1].m_points[1].x	= 25.f;
	m_objects[1].m_points[1].y	= -50.f;
	m_objects[1].m_points[2].x	= 25.f;
	m_objects[1].m_points[2].y	= -25.f;
	m_objects[1].m_points[3].x	= 50.f;
	m_objects[1].m_points[3].y	= -25.f;
	m_objects[1].m_points[4].x	= 50.f;
	m_objects[1].m_points[4].y	= 25.f;
	m_objects[1].m_points[5].x	= 25.f;
	m_objects[1].m_points[5].y	= 25.f;
	m_objects[1].m_points[6].x	= 25.f;
	m_objects[1].m_points[6].y	= 50.f;
	m_objects[1].m_points[7].x	= -25.f;
	m_objects[1].m_points[7].y	= 50.f;
	m_objects[1].m_points[8].x	= -25.f;
	m_objects[1].m_points[8].y	= 25.f;
	m_objects[1].m_points[9].x	= -50.f;
	m_objects[1].m_points[9].y	= 25.f;
	m_objects[1].m_points[10].x	= -50.f;
	m_objects[1].m_points[10].y	= -25.f;
	m_objects[1].m_points[11].x	= -25.f;
	m_objects[1].m_points[11].y	= -25.f;

	m_objects[2].m_points.allocate(6);
	m_objects[2].m_points[0].x	= -50.f;
	m_objects[2].m_points[0].y	= -25.f;
	m_objects[2].m_points[1].x	= 0.f;
	m_objects[2].m_points[1].y	= -50.f;
	m_objects[2].m_points[2].x	= 50.f;
	m_objects[2].m_points[2].y	= -25.f;
	m_objects[2].m_points[3].x	= 50.f;
	m_objects[2].m_points[3].y	= 25.f;
	m_objects[2].m_points[4].x	= 0.f;
	m_objects[2].m_points[4].y	= 50.f;
	m_objects[2].m_points[5].x	= -50.f;
	m_objects[2].m_points[5].y	= 25.f;

	m_objects[3].m_points.allocate(16);
	m_objects[3].m_points[0].x	= -50.f;
	m_objects[3].m_points[0].y	= -50.f;
	m_objects[3].m_points[1].x	= -25.f;
	m_objects[3].m_points[1].y	= -50.f;
	m_objects[3].m_points[2].x	= 0.f;
	m_objects[3].m_points[2].y	= -25.f;
	m_objects[3].m_points[3].x	= 25.f;
	m_objects[3].m_points[3].y	= -50.f;
	m_objects[3].m_points[4].x	= 50.f;
	m_objects[3].m_points[4].y	= -50.f;
	m_objects[3].m_points[5].x	= 50.f;
	m_objects[3].m_points[5].y	= -25.f;
	m_objects[3].m_points[6].x	= 25.f;
	m_objects[3].m_points[6].y	= 0.f;
	m_objects[3].m_points[7].x	= 50.f;
	m_objects[3].m_points[7].y	= 25.f;
	m_objects[3].m_points[8].x	= 50.f;
	m_objects[3].m_points[8].y	= 50.f;
	m_objects[3].m_points[9].x	= 25.f;
	m_objects[3].m_points[9].y	= 50.f;
	m_objects[3].m_points[10].x	= 0.f;
	m_objects[3].m_points[10].y	= 25.f;
	m_objects[3].m_points[11].x	= -25.f;
	m_objects[3].m_points[11].y	= 50.f;
	m_objects[3].m_points[12].x	= -50.f;
	m_objects[3].m_points[12].y	= 50.f;
	m_objects[3].m_points[13].x	= -50.f;
	m_objects[3].m_points[13].y	= 25.f;
	m_objects[3].m_points[14].x	= -25.f;
	m_objects[3].m_points[14].y	= 0.f;
	m_objects[3].m_points[15].x	= -50.f;
	m_objects[3].m_points[15].y	= -25.f;

	m_objects[4].m_points.allocate(4);
	m_objects[4].m_points[0].x	= -50.f;
	m_objects[4].m_points[0].y	= -50.f;
	m_objects[4].m_points[1].x	= 50.f;
	m_objects[4].m_points[1].y	= -50.f;
	m_objects[4].m_points[2].x	= 50.f;
	m_objects[4].m_points[2].y	= 50.f;
	m_objects[4].m_points[3].x	= -50.f;
	m_objects[4].m_points[3].y	= 50.f;

	m_objects[5].m_points.allocate(3);
	m_objects[5].m_points[0].x	= -50.f;
	m_objects[5].m_points[0].y	= -50.f;
	m_objects[5].m_points[1].x	= 50.f;
	m_objects[5].m_points[1].y	= -50.f;
	m_objects[5].m_points[2].x	= 0.f;
	m_objects[5].m_points[2].y	= 50.f;

	m_count = m_objects[0].m_points.getCount();

	m_object.m_points.allocate(16);
	for (unsigned int i = 0;  i < m_object.m_points.getCount();  i++)
		m_object.m_points[i].reset();

	return true;
}

void DemoRonny::signal(void)
{
}

bool DemoRonny::update(float deltaTime)
{
	if (!ThEffectObject::update(deltaTime))
		return false;

	if (m_delay)
	{
		m_delay -= deltaTime;
		if (m_delay > 0.f)
			return true;
	}

	m_scale += deltaTime;

	if (m_scale > 1.f)
	{
		m_scale = 0.f;

		m_count = m_objects[m_index].m_points.getCount();

		for (unsigned int i = 0;  i < m_object.m_points.getCount();  i++)
			m_object.m_points[i] = m_objects[m_index].m_points[(i < m_count) ? i : (m_count - 1)];

		m_index++;
		if (m_index == m_objects.getCount())
			m_index = 0;

		if (m_count < m_objects[m_index].m_points.getCount())
			m_count = m_objects[m_index].m_points.getCount();

		m_delay = 0.5f;
	}

	return true;
}

bool DemoRonny::render(void)
{
	if (!ThEffectObject::render())
		return false;

	glPushAttrib(GL_DEPTH_BUFFER_BIT | GL_LINE_BIT);

	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
	gluOrtho2D(-60.f, 60.f, 60.f, -60.f);

	glColor3f(1.f, 1.f, 1.f);
	glDisable(GL_DEPTH_TEST);

	glLineWidth(3.f);

	glBegin(GL_LINE_LOOP);

	for (unsigned int i = 0;  i < m_count;  i++)
	{
		const unsigned int count = m_objects[m_index].m_points.getCount();

		ThVector2 point = m_objects[m_index].m_points[(i < count) ? i : (count - 1)] * m_scale + m_object.m_points[i] * (1.f - m_scale);

		glVertex2f(point.x, point.y);
	}

	glEnd();

	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);

	glPopAttrib();

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////

DemoFlash::DemoFlash(unsigned int* textures, unsigned int count):
	m_textures(textures),
	m_count(count)
{
	m_time   = 0.f;
	m_single = false;
	m_index  = 0;
}

DemoFlash::~DemoFlash(void)
{
}

bool DemoFlash::open(void)
{
	return true;
}

void DemoFlash::signal(void)
{
	m_single = true;

	m_index = (m_index + 1) % m_count;
}

bool DemoFlash::update(float deltaTime)
{
	if (!ThEffectObject::update(deltaTime))
		return false;

	m_time += deltaTime;

	if (!m_single)
		m_index = (unsigned int) (m_time * 8.f) % m_count;

	return true;
}

bool DemoFlash::render(void)
{
	if (!ThEffectObject::render())
		return false;

	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
	gluOrtho2D(0.f, 1.f, 1.f, 0.f);

	glPushAttrib(GL_DEPTH_BUFFER_BIT | GL_ENABLE_BIT);

	glEnable(GL_TEXTURE_2D);

	glDepthMask(GL_FALSE);

	glBindTexture(GL_TEXTURE_2D, m_textures[m_index]);

	glColor3f(1.f, 1.f, 1.f);

	glBegin(GL_QUADS);

	glTexCoord2f(0.f, 0.f);
	glVertex2f(0.f, 0.f);

	glTexCoord2f(0.f, 1.f);
	glVertex2f(0.f, 1.f);

	glTexCoord2f(1.f, 1.f);
	glVertex2f(1.f, 1.f);

	glTexCoord2f(1.f, 0.f);
	glVertex2f(1.f, 0.f);

	glEnd();

	glPopAttrib();

	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////

bool TheresaMain(const char* commandLine)
{
	srand(time(NULL));

	if (!System->openMusic("data\\music.xm"))
		return false;

	if (!System->openDisplay(640, 480))
		return false;

	System->getDisplay()->setTitle("kilometer years from France");

	ThPtr<Demo> demo = new Demo();

	if (!demo->open())
		return false;

	System->getMusic()->start();

	System->start();

	System->getMusic()->stop();

	System->closeDisplay();
	System->closeMusic();

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////
