#include <stdio.h>
#include <signal.h>
#include <unistd.h>
#include <time.h>
#include <stdlib.h>
#include "Messagetypes.h"


typedef enum message_to_robot_type Mensaje_A_Robot;


void Chequea_Mensaje(int sig);
void Gira_Angulo(int que, double velocidad, double angulo);


Mensaje_A_Robot Devuelve_Mensaje(char* mensaje);

void main(void)
{ int salir=0, que=7; double velocidad=0.75, angulo=6.32;
   signal(SIGUSR1, Chequea_Mensaje);
   printf("RobotOption 2 %d\n",SIGUSR1);
   printf("Name Death Angel\n");
   printf("Colou f1f1f1 f5f5f5\n");
   fflush(stdout); 
   while(!salir)
   {
      printf("RotateAmount %d %lf %lf\n",que,velocidad,angulo); 
      fflush(stdout);
      printf("Shoot 30");
      fflush(stdout);
      sleep(1);
   }
}
      
void Chequea_Mensaje(int sig)
{
   char mensaje[81]; 
   while (scanf("%s",mensaje) != EOF)
   {
      Mensaje_A_Robot Recibido;
      Recibido=Devuelve_Mensaje(mensaje);
      switch (Recibido)
      {
         float aceleracion;
         unsigned char numero:
         case INITIALIZE:
              {  int numero; 
                 scanf("%d",&numero); 
                 if (numero==1)  
                { printf("Name Death Angel\n"); 
                  printf("Colour f3f3f3 f5f5f5\n"); 
                  fflush(stdout); 
                 } 
              }
              break;
         case GAME_STARTS:
            printf("Print Hoy es un buen dia para cazar...\n");fflush(stdout);
            printf("Accelerate 0.5"); fflush(stdout);
            break;
         
         case DEAD:
            printf("Print Me muero...\n");
            fflush(stdout);
            break;
      }
   }
   signal(sig,Chequea_Mensaje); 
}

Mensaje_A_Robot Devuelve_Mensaje(char* mensaje)
{
   int i,valor;
   valor=UNKNOWN_MESSAGE_TO_ROBOT; 
   for(i=0; message_to_robot[i].msg[0] != '\0'; i++)
   {
      if(strcmp(message_to_robot[i].msg, mensaje) == 0)
         valor=(Mensaje_A_Robot)i; 
   }
   return valor;
}
