/* RTBApi                 
 * Copyright (C) 1998 Ruben <ryu@mundivia.es>                           
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef __RTBAPI_H__
#define __RTBAPI_H__

typedef enum{
  ROTATE_ROBOT=1,
  ROTATE_CANNON=2,
  ROTATE_RADAR=4 
}rotate_type;

typedef enum 
{
  UNKNOWN_MESSAGE=0,
  PROCESS_TIME_LOW=1,
  MESSAGE_SENT_IN_ILLEGAL_STATE=2,
  UNKNOWN_OPTION=3,
  OBSOLETE_KEYWORD=4
}warning_type;

typedef enum 
{
  ROBOT_MAX_ROTATE=0,
  ROBOT_CANNON_MAX_ROTATE=1,
  ROBOT_RADAR_MAX_ROTATE=2,

  ROBOT_MAX_ACCELERATION=3,
  ROBOT_MIN_ACCELERATION=4,

  ROBOT_START_ENERGY=5,
  ROBOT_MAX_ENERGY=6,
  ROBOT_ENERGY_LEVELS=7,

  SHOT_SPEED=8,
  SHOT_MIN_ENERGY=9,
  SHOT_MAX_ENERGY=10,
  SHOT_ENERGY_INCREASE_SPEED=11,

  TIMEOUT=12,

  DEBUG_LEVEL=13            // 0 - no debug, 5 - highest debug level
}game_option_type;

typedef enum 
{
  SIGNAL=2,                   // 0 - no signal, > 1 signal to send (e.g. SIGUSR1 or SIGUSR2) 
  SEND_SIGNAL=0,              // 0 - false, 1 - true
  SEND_ROTATION_REACHED=1     // 0 - no messages, 1 - messages when RotateTo and RotateAmount finished, 
                              // 2 - messages also when sweep direction is changed 
}robot_option_type;

typedef enum  
{ 
  IS_NOOBJECT = -1, 
  IS_ROBOT = 0, 
  IS_SHOT = 1, 
  IS_WALL = 2, 
  IS_COOKIE = 3, 
  IS_MINE = 4,
  IS_LAST_OBJECT_TYPE = 5
}object_type;



  /************************************************************************/
 /** User Callbacks ******************************************************/
/************************************************************************/
extern void (*Initialize)(int);
extern void (*YourName)(char *);
extern void (*YourColour)(int);
extern void (*GameOption)(game_option_type, double);
extern void (*GameStarts)();
extern void (*Radar)(double, object_type, double);
extern void (*Info)(double, double, double);
extern void (*RobotInfo)(double, int);
extern void (*RotationReached)(rotate_type);
extern void (*Energy)(double);  
extern void (*RobotsLeft)(int);
extern void (*Collision)(object_type, double);
extern void (*Warning)(warning_type, char *);
extern void (*Dead)();
extern void (*GameFinishes)();
extern void (*ExitRobot)();   




  /************************************************************************/
 /** Messages from robots to server **************************************/
/************************************************************************/

void RobotOption(robot_option_type option, int value);
void Name(char *name);
void Colour (int colour, int away_colour);
void Rotate (rotate_type what, double angle);
void RotateTo (rotate_type what, double angular, double end);
void RotateAmount (rotate_type what, double angular, double angle);
void Sweep (rotate_type what, double algular, double left, double right);
void Accelerate(double value);
void Brake(double portion);
void Shoot(double energy);
void Print(char *message);
void Debug(char *message);
void DebugLine(double angle1, double radius1, double angle2, double radius2);
void DebugCircle(double center_angle, double center_radius, double circle_radius);

/* SCANNER: This is the parser, you should give the control to this function */
void Scanner();

#endif
