/* RTBApi                 
 * Copyright (C) 1998 Ruben <ryu@mundivia.es>                           
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#include <stdlib.h>
#include <stdio.h>
#include <sys/time.h>
#include <signal.h>
#include <unistd.h>
#include "rtbapi.h"
#include "parser.h"

void sigsegv(int i)
{
    Print("Segmentation Fault... EXITING");
    fprintf(stderr,"*** SEGMENTATION FAULT CATCH ***\n");
    exit(1);
}

void sigusr1(int i)
{
#ifdef DEBUG
    fprintf(stderr,"SIGUSR1 received\n");
#endif
//    while (!feof(stdin))
//    {
	while(optimized_parser());
//    }
    signal(SIGUSR1,sigusr1);
}

#include <unistd.h>
#include <fcntl.h>
#include "rtbapi.h"

void (*Initialize)(int)=NULL;
void (*YourName)(char *)=NULL;
void (*YourColour)(int)=NULL;
void (*GameOption)(game_option_type, double)=NULL;
void (*GameStarts)()=NULL;
void (*Radar)(double, object_type, double)=NULL;
void (*Info)(double, double, double)=NULL; 
void (*RobotInfo)(double, int)=NULL;
void (*RotationReached)(rotate_type)=NULL;
void (*Energy)(double)=NULL;
void (*RobotsLeft)(int)=NULL;
void (*Collision)(object_type, double)=NULL;
void (*Warning)(warning_type, char *)=NULL;
void (*Dead)()=NULL;
void (*GameFinishes)()=NULL;
void (*ExitRobot)()=NULL; 

/***************************************************************************/
/***************************************************************************/
/***************************************************************************/

void RobotOption(robot_option_type option, int value)
{
  printf("RobotOption %i %i\n",option,value);fflush(stdout);
}

void Name(char *name)
{
  printf("Name %s\n",name);fflush(stdout);
}

void Colour (int colour, int away_colour)
{
  printf("Colour %x %x\n",colour,away_colour);fflush(stdout);
}

void Rotate (rotate_type what, double angle)
{
  printf("Rotate %i %f\n",what,angle);fflush(stdout);
}

void RotateTo (rotate_type what, double angular, double end)
{
  printf("RotateTo %i %f %f\n",what,angular,end);fflush(stdout);
}

void RotateAmount (rotate_type what, double angular, double angle)
{
    printf("RotateAmount %i %f %f\n",what,angular,angle);fflush(stdout);
}

void Sweep (rotate_type what, double angular, double left, double right)
{
  printf("Sweep %i %f %f %f\n",what,angular,left,right);fflush(stdout);
}

void Accelerate(double value)
{
  printf("Accelerate %f\n",value);fflush(stdout);
}

void Brake(double portion)
{
  printf("Brake %f\n",portion);fflush(stdout);
}

void Shoot(double energy)
{
  printf("Shoot %f\n",energy);fflush(stdout);
}

void Print(char *message)
{
  printf("Print %s\n",message);fflush(stdout);
}

void Debug(char *message)
{
  printf("Debug %s\n",message);fflush(stdout);
}

void DebugLine(double angle1, double radius1, double angle2, double radius2)
{
  printf("DebugLine %f %f %f %f\n",angle1,radius1,angle2,radius2);fflush(stdout);
}

void DebugCircle(double center_angle, double center_radius, double circle_radius)
{
  printf("DebugLine %f %f %f\n",center_angle,center_radius,circle_radius);fflush(stdout);
}


void Scanner()
{
    sigset_t usr1set;
    signal(SIGUSR1,sigusr1);
    signal(SIGSEGV,sigsegv);

    // libpthread seems to block USR1 sometimes for some reason
    sigemptyset(&usr1set);
    sigaddset(&usr1set, SIGUSR1);
    sigprocmask(SIG_UNBLOCK, &usr1set, NULL);
    
    RobotOption(SIGNAL,SIGUSR1);

    
    for(;;sleep(1));
}

char *___RyU__RtB__ApI__="I'm Ryu's RealTimeBattle C API library";
