#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "rtbapi.h"
#include <unistd.h>

#define MAX_STRINGS 40
char *read_line(FILE *file)
{
    char *str=(char *)malloc(MAX_STRINGS);
    int fin=0;
    int size=MAX_STRINGS;
    if (fgets(str,MAX_STRINGS,file)==NULL)
    {
	free(str);
	return NULL;
    }
    while (!fin)
    {
	fin=1;
	if (strchr(str,'\n')==NULL)
	{
	    char *tmp=(char *)malloc(size+MAX_STRINGS-1);
	    strcpy(tmp,str);
	    fgets(tmp+size-1,MAX_STRINGS,file);
	    free(str);
	    str=tmp;
	    size+=MAX_STRINGS-1;
	    fin=0;
	}
    }
    return str;
}

#define DO(a) if (a) a
int 
optimized_parser ()
{
    char *line=NULL;
    char *command=NULL;
    char *rest=NULL;

    line=read_line(stdin);
    if (line==NULL) return 0;
    command=(char *)malloc(strlen(line)+1);
    sscanf(line,"%s",command);

#ifdef DEBUG
    fprintf(stderr,"command: [%s]\n",command);fflush(stderr);
#endif

    rest=line+strlen(command);

    if (!strcasecmp(command,"INITIALIZE"))
    {
	int i;
	sscanf(rest,"%i",&i);
	DO(Initialize)(i);
    }
    else if (!strcasecmp(command,"YOURNAME"))
    {
	DO(YourName)(rest);
    }
    else if (!strcasecmp(command,"YOURCOLOUR"))
    {
        int i;
	sscanf(rest,"%x",&i);
	DO(YourColour)(i);
    }
    else if (!strcasecmp(command,"GAMEOPTION"))
    {
	int i;
	double f;
	sscanf(rest,"%i %lf",&i,&f);
	DO(GameOption)(i,f);
    }
    else if (!strcasecmp(command,"GAMESTARTS"))
    {
	DO(GameStarts)();
    }
    else if (!strcasecmp(command,"RADAR"))
    {
	int i;double a,b;
	sscanf(rest,"%lf %i %lf",&a,&i,&b);
	DO(Radar)(a,i,b);
    }
    else if (!strcasecmp(command,"INFO"))
    {
	double a,b,c;
	sscanf(rest,"%lf %lf %lf",&a,&b,&c);
	DO(Info)(a,b,c);
    }
    else if (!strcasecmp(command,"ROBOTINFO"))
    {
        int i; double f;
	sscanf(rest,"%lf %i",&f,&i);
	DO(RobotInfo)(f,i);
    }
    else if (!strcasecmp(command,"ROTATIONREACHED"))
    {
        int i;
	sscanf(rest,"%i",&i);
	DO(RotationReached)(i);
    }
    else if (!strcasecmp(command,"ENERGY"))
    {
        double f;
	sscanf(rest,"%lf",&f);
	DO(Energy)(f);
    }
    else if (!strcasecmp(command,"ROBOTSLEFT"))
    {
	int i;
	sscanf(rest,"%i",&i);
	DO(RobotsLeft)(i);
    }
    else if (!strcasecmp(command,"COLLISION"))
    {
	int i;double f;
	sscanf(rest,"%i %lf",&i,&f);
	DO(Collision)(i,f);
    }
    else if (!strcasecmp(command,"WARNING"))
    {
	char *s=(char *)malloc(strlen(rest)+1);
	int i;
	sscanf(rest,"%i %s",&i,s);
	DO(Warning)(i,s);
	free(s);
    }
    else if (!strcasecmp(command,"DEAD"))
    {
	DO(Dead)();
    }
    else if (!strcasecmp(command,"GAMEFINISHES"))
    {
	DO(GameFinishes)();
    }
    else if (!strcasecmp(command,"EXITROBOT"))
    {
	DO(ExitRobot)();
    }
    else fprintf(stderr,"WARNING: unknown command [%s]\n",command);
    free(command);
    free(line);
    return 1;
}
