/* swivel | CSR 
   swivel@csrmusic.org
*/

#include	"fastmath.h"



int	sheight;
int	swidth;

void	spiralpixel(double , double , unsigned char, unsigned char *, int, int);


spiral(unsigned char *dest, int density, double phase, double prate, double zoom, double zrate, int w, int h, int x, int y)
{	
	int 	i;
	double	l = zrate;
	double	k = zoom;

	swidth = w;
	sheight = h;

	for( i = 0 ; i < density ; i++  ) {
		spiralpixel(k * cos(phase), k * sin(phase), 255, dest, x, y);

		k += l; 

		phase += prate; 
	}
}



void	spiralpixel(double X, double Y, unsigned char C, unsigned char *pdest, int x, int y)
{
	int	bX;
	int	bY;

	bY = Y;
	bX = X;

	bX += x; 
	bY += y;

	if( bX > 0 )
		if( bX < swidth )
			if( bY > 0 )
				if( bY < sheight ) 
					pdest[ ((bY * swidth) + bX) ]	= C; 
			
}

