/* swivel | CSR */
/* swivel@csrmusic.org */

#include	"fastmath.h"

#define twidth   64
#define	theight   64


void rotate(unsigned char *txtr, int phase, float zoom,
             unsigned char *dst, unsigned int dwidth, unsigned int dheight)
{

	/* texture coords */
	unsigned char    tx = 0;
	unsigned char    ty = 0;

	/* destination coords */
	unsigned int    dx;
	unsigned int    dy;
	unsigned int    i = 0;
	float cosine, sine;
	float ysin, ycos;

	/* could use LUT but whats the point, this is on a per-frame basis
	   not like its in an inner loop.
	*/

/*
	cosine = (float)(cos(phase) * zoom);
	sine = (float)(sin(phase) * zoom);
*/
	cosine = (fastcos(phase) * zoom);
	sine = (fastsin(phase) * zoom);


	for(dy = 0; dy < dheight; dy++) {
		ycos = dy * cosine * sine;
		ysin = dy * sine * cosine;

		for(dx = 0; dx < dwidth; dx++, i++) {

			ty = (unsigned char)((dx * sine) + ycos); 
			tx = (unsigned char)((dx * cosine) - ysin);

		/* shrink coords to 64, then multiply y by 64 */
			dst[i] = txtr[((ty >> 2) << 6) + (tx >> 2)];
		}
	}
}
