/* Functions for loading and saving TARGA files */
/* swivel | CSR */
/* swivel@csrmusic.org */

/*
stripped down for demo and stuph, doesnt support compressed targas and
no saving
*/

#include	<stdio.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<fcntl.h>
#include	"targa.h"



struct TARGA * load_targa(char *targapath)
{
	unsigned int	size = 0;
	int	targafile;	
	struct TARGA *newfile = NULL;

	newfile = (struct TARGA *)calloc(1, sizeof(struct TARGA));
	if(newfile == NULL) {
		printf("Error allocating %i bytes for newfile.\n",
			sizeof(struct TARGA) );
		return NULL;
	}



	targafile = open(targapath, O_RDONLY);
	if(targafile == -1) {
		printf("Error loading targa: %s \n", targapath);
		return	NULL;
	}

	read(targafile, &newfile->ident_length, 1);
	read(targafile, &newfile->color_map_type, 1);
	read(targafile, &newfile->image_type, 1);

	read(targafile, &newfile->color_map_start, 2);
	read(targafile, &newfile->color_map_entries, 2);

	read(targafile, &newfile->color_map_entry_depth, 1);

	read(targafile, &newfile->X_lower_left, 2);
	read(targafile, &newfile->Y_lower_left, 2);
	read(targafile, &newfile->image_width, 2);
	read(targafile, &newfile->image_height, 2);

	read(targafile, &newfile->bits_per_pixel, 1);
	read(targafile, &newfile->flags, 1);



		/* allocate and read the identification string */
	size = newfile->ident_length;
	newfile->ident = (unsigned char *)malloc(size);
	if(newfile->ident == NULL) {
		printf("Error allocating %i bytes for newfile->ident.\n",
			size);
		return NULL;
	}
	read(targafile, newfile->ident, size);

		/* allocate and read our color map */
	size = (newfile->color_map_entries 								* 								       (newfile->color_map_entry_depth / 8));
	newfile->color_map = (unsigned char *)malloc(size); 
	if(newfile->color_map == NULL) {
		printf("Error allocating %i bytes for newfile->ident.\n",
			size);
		return NULL;
	}
	read(targafile, newfile->color_map, size); 


		/* allocate and read our image data */
	size = ( (newfile->image_width * newfile->image_height)							*								(newfile->bits_per_pixel / 8)  );

	newfile->image = (unsigned char *)calloc(1, size);
	if(newfile->image == NULL) {
		printf("Error allocating %i bytes for newfile->ident.\n",
			size);
		return NULL;
	}
	read(targafile, newfile->image, size); 


	close(targafile);

	return newfile;
}



int	save_targa(struct TARGA *what, char *where)
{
	int	targafile;


	if(what == NULL) {
		printf("Invalid data for saving.\n");
		return 0;
	}

	targafile = open(where, O_WRONLY | O_CREAT);
	if(targafile == -1) {
		printf("Error creating file: %s \n", where);
		return	0;
	}

        write(targafile, &what->ident_length, 1);
        write(targafile, &what->color_map_type, 1);
        write(targafile, &what->image_type, 1);

        write(targafile, &what->color_map_start, 2);
        write(targafile, &what->color_map_entries, 2);

        write(targafile, &what->color_map_entry_depth, 1);

        write(targafile, &what->X_lower_left, 2);
        write(targafile, &what->Y_lower_left, 2);
        write(targafile, &what->image_width, 2);
        write(targafile, &what->image_height, 2);

        write(targafile, &what->bits_per_pixel, 1);
        write(targafile, &what->flags, 1);

	write(targafile, what->ident, what->ident_length);

        write(targafile, what->color_map, 
		what->color_map_entries * (what->color_map_entry_depth / 8));

	write(targafile, what->image, 
		((what->image_width * what->image_height) 
				* 
		(what->bits_per_pixel / 8)));

        close(targafile);

	return 1;
}
