/* some low level sprite functions */
/* simple drawing functions, pallete functions */
/* at the moment support for 8bit is only implemented */
/* Swivel | CSR */
/* swivel@csrmusic.org */

#include	<stdio.h>
#include	<asm/io.h>
#include	"sprite.h"

#ifdef	SDLHACK
	#include	<SDL/SDL.h>
	extern SDL_Surface	*SDLscreen;
#endif

void	draw_sprite(struct SPRITE *source, unsigned char *dest,
		    int X, int Y, int dwidth, int dheight)
{
	unsigned int	i = 0, j = 0;
	unsigned int	sdiff = 0;
	unsigned int	ddiff = 0;
	int		cx;
	int		cy;

	/* get sprite specs and ptr */
	unsigned char *	ssprite = source->data;
	unsigned int	swidth  = source->width;
	unsigned int	sheight = source->height;
	unsigned int	rswidth = swidth;


	/* must clip beginning of image if X or Y are negative values */
	if(X < 0) {
		unsigned int	bla = abs(X);

		swidth -= bla;
		i += bla;
		X = 0;
	}


	if(Y < 0) {
		unsigned int	bla = abs(Y);

		sheight -= bla;
		i += bla * rswidth;
		Y = 0;
	}



	/* adjust dest offset to our dest (X, Y)  offset */
	j += ((Y * dwidth) + X);

	/* clip image if full width goes beyond destination width at X */
	if(dwidth < X + swidth) 
		swidth = dwidth - X;

	/* clip image if full height goes beyond destination height at Y */
	if(dheight < Y + sheight)
		sheight = dheight - Y;

	/* calculate the difference between clipped and regular width */
	sdiff = rswidth - swidth;
	if(swidth < dwidth) {
		ddiff = dwidth - swidth;
	}

	for(cy = 0; cy < sheight; cy++) {
		for(cx = 0; cx < swidth; cx++, i++, j++) {
			dest[j] = ssprite[i];
		}		
		i += sdiff;
		j += ddiff;
	} 

	return;
}



void	draw_sprite_trans(struct SPRITE *source, unsigned char *dest, 
			  int X, int Y, int dwidth, int dheight)
{
	int		cx;
	int		cy;

	/* get sprite specs and ptr */
	unsigned char *	ssprite = source->data;
	unsigned char	trans	= source->transparent;
	int		swidth  = source->width;
	int		rswidth = source->width;
	int		sheight = source->height;

	/* adjust dest ptr to include our dest X, Y */
	dest += ( (Y * dwidth) + X);

	if(dwidth < X + swidth)
		swidth = dwidth - X;
	
	if(dheight < Y + sheight)
		sheight = dheight - Y;

	for(cy = 0; cy < sheight; cy++) {
		for(cx = 0; cx < swidth; cx++) {
			if(ssprite[(cy * rswidth) + cx] != trans)		
				dest[cx] = ssprite[(cy * rswidth) + cx];
		}		
		dest += dwidth;
	} 

	return;
}






void	set_palette(struct PALETTE *pal)
{
		/*
		palette types supported:
		0: PCVGA(R,G,B) 8bpe
		1: TARGA(B,G,R) 8bpe
		2: PCVGA(R,G,B) 6bpe
		3: TARGA(B,G,R) 6bpe
		*/

	unsigned int 		s = 0;
	unsigned char *		data = pal->data;
	unsigned short		start = pal->start;
	unsigned short		quantity = pal->quantity;
#ifdef SDLHACK
	SDL_Color		colors[256 * 2];
#endif


#ifndef	NOVGA
#ifndef	SDLHACK
	outb(start, 0x3c8);
#endif
#endif

	switch(pal->type) {

	case PCVGA8BIT:
#ifdef	SDLHACK
		for(s = 0; s < quantity; s++) {
			colors[s].r = data[s * 3];
			colors[s].g = data[s * 3 + 1];
			colors[s].b = data[s * 3 + 2];
		}

#ifndef	NOVGA
		SDL_SetColors(SDLscreen, colors, 0, quantity);
#endif
#else
		for(s = 0; s < quantity; s++) {
#ifndef	NOVGA
			outb(data[s * 3] >> 2, 0x3c9);
			outb(data[(s * 3) + 1] >> 2, 0x3c9);
			outb(data[(s * 3) + 2] >> 2, 0x3c9);
#endif
		}
#endif

		break;
		

	case TARGA8BIT:
#ifdef	SDLHACK
#else
		for(s = 0; s < quantity; s++) {
			outb(data[(s * 3) + 2] >> 2, 0x3c9);
			outb(data[(s * 3) + 1] >> 2, 0x3c9);
			outb(data[s * 3] >> 2, 0x3c9);
		}
#endif

		break;


	case PCVGA6BIT:
#ifdef	SDLHACK
#else
		for(s = 0; s < quantity; s++) {
			outb(data[s * 3], 0x3c9);
			outb(data[(s * 3) + 1], 0x3c9);
			outb(data[(s * 3) + 2], 0x3c9);
		}
#endif

		break;


	case TARGA6BIT:
#ifdef	SDLHACK
#else
		for(s = 0; s < quantity; s++) {
			outb(data[(s * 3) + 2], 0x3c9);
			outb(data[(s * 3) + 1], 0x3c9);
			outb(data[s * 3], 0x3c9);
		}
#endif

		break;



	default:
		break;
	}

	return;
}


struct SPRITE * load_sprite(char *path)
{
	struct im 	*image;
	struct SPRITE	*newsprite;

	image = imload_image(path);
	if( image == NULL ) return NULL;

	newsprite = new_sprite_struct();
	if( newsprite == NULL ) return NULL;

	newsprite->data = image->data;
	newsprite->width = image->width;	
	newsprite->height = image->height;	
	newsprite->transparent = 0; /* images dont contain alpha nfo */
				    /* in the demo we will be using 0 */

	free(image);

	return newsprite;
}


struct PALETTE * load_palette(char *path)
{
	struct pal 	*pal;
	struct PALETTE 	*newpalette;

	pal = imload_palette(path);
	if( pal == NULL ) return NULL;

	newpalette = new_palette_struct();
	if(newpalette == NULL) return NULL;

	newpalette->data = pal->data;
	newpalette->start = pal->start;	
	newpalette->quantity = pal->quantity;	
	newpalette->type = PCVGA8BIT;

	free(pal);

	return newpalette;
}


void draw_sprite_center(struct SPRITE *source, unsigned char *dest, int width, int height)
{
	int x, y;

	x = width - source->width;
	y = height - source->height;

	/* this isnt exact, but good enough for our purposes */
	x >>= 1;
	y >>= 1;

	draw_sprite(source, dest, x, y, width, height);

	return;
}

void draw_sprite_trans_center(struct SPRITE *source, unsigned char *dest, int width, int height)
{
	int x, y;

	x = width - source->width;
	y = height - source->height;

	x >>= 1;
	y >>= 1;

	draw_sprite_trans(source, dest, x, y, width, height);

	return;
}


void unload_sprite(struct SPRITE *which)
{

	if(which == NULL) {
		printf("Cannot free NULL sprite\n");
		return;
	}

	free(which->data);
	free(which);

	return;
}

void unload_palette(struct PALETTE *which)
{

	if(which == NULL) {
		printf("Cannot free NULL palette\n");
		return;
	}

	free(which->data);
	free(which);

	return;
}

struct SPRITE * sprite_from_targa(struct TARGA *src)
{
	struct SPRITE *newsprite;

	if(src == NULL) {
		printf("Invalid data supplied to function sprite_from_targa()\n");
		return NULL;
	}

	newsprite = new_sprite_struct();
	if(newsprite == NULL) return NULL;

	newsprite->data = src->image;
	newsprite->width = src->image_width;
	newsprite->height = src->image_height;
	newsprite->transparent = 0;

	return newsprite;	
}

struct SPRITE * sprite_from_image(struct im *src)
{
	struct SPRITE *newsprite;

	if(src == NULL) {
		printf("Invalid data supplied to function sprite_from_image()\n");
		return NULL;
	}

	newsprite = new_sprite_struct();
	if(newsprite == NULL) return NULL;

	newsprite->data = src->data;
	newsprite->width = src->width;
	newsprite->height = src->height;
	newsprite->transparent = 0;

	return newsprite;	
}


struct SPRITE * sprite_from_data(unsigned char *data, int width, int height, int transparent)
{
	struct SPRITE *newsprite;

	newsprite = (struct SPRITE *)calloc(1, sizeof(struct SPRITE));
	if(newsprite == NULL) return NULL;
	
	newsprite->data = data;
	newsprite->width = width;
	newsprite->height = height;
	newsprite->transparent = transparent;

	return newsprite;
}

struct PALETTE * new_palette_struct(void)
{
	struct PALETTE 	*newpalette;

	newpalette = (struct PALETTE *)calloc(1, sizeof(struct PALETTE));
	if( newpalette == NULL ) {
		printf("Error allocating %i bytes for palette structure.\n",
			sizeof(struct PALETTE));
		return NULL;
	}

	return newpalette;
}

struct SPRITE * new_sprite_struct(void)
{
	struct SPRITE	*newsprite;

	newsprite = (struct SPRITE *)calloc(1, sizeof(struct SPRITE));
	if( newsprite == NULL ) {
		printf("Error allocating %i bytes for sprite structure.\n",
			sizeof(struct SPRITE));
		return NULL;
	}

	return newsprite;
}
