/*
swivel | CSR
swivel@csrmusic.org
*/


#include	<stdio.h>

#ifdef SDLHACK
#	include		<SDL/SDL.h>
	SDL_Surface 	*SDLscreen;	
#else
#	include		<vga.h>
#endif

#include	"../prefs.h"
#include	"sprite.h"
#include	"gfx.h"


void draw_screen(void *source)
{
#ifndef NOVGA

#ifdef MODEX
	bitblit(source);
#endif

#ifdef SVGA
	vga_waitretrace();
	svga_bitblit(source, graph_mem);
#endif

#ifdef THIRTEENH
	vga_lockvc();
	vga_waitretrace();
	memcpy(graph_mem, source, VWIDTH * VHEIGHT);
	vga_unlockvc();
#endif

	/* SDL slapped together .. may not even be correct :P */
#ifdef SDLHACK
	SDL_LockSurface(SDLscreen);
	memcpy(SDLscreen->pixels, source, VWIDTH * VHEIGHT);
	SDL_UnlockSurface(SDLscreen);
        SDL_UpdateRect(SDLscreen, 0, 0, 0, 0);
#endif

#endif
}


struct PALETTE * get_palette(void)
{
	unsigned int	i;
	struct PALETTE 	*pal;
	unsigned char 	*paldata;
#ifdef	SDLHACK
	SDL_Color	*SDLpal;
#else
	unsigned int	tpal[256 * 3];
#endif

	pal = new_palette_struct();
	if(pal == NULL) return NULL;

	pal->data = (unsigned char *)calloc(1, 256 * 3);
	if(pal->data == NULL) {
		printf("Error allocating %i bytes for palette data\n");
		return NULL;
	}

	pal->start = 0;
	pal->quantity = 256;
	pal->type = PCVGA8BIT;
	paldata = pal->data;

#ifdef	SDLHACK
	/* get palette from SDL_Surface */
	SDLpal = SDLscreen->format->palette->colors;

	for(i = 0; i < 256; i++) {
		paldata[i * 3] = SDLpal[i].r;
		paldata[i * 3 + 1] = SDLpal[i].g;
		paldata[i * 3 + 2] = SDLpal[i].b;
	}
#else
/* everything else is svgalib */
	vga_getpalvec(0, 256, tpal);
	for(i = 0; i < 256; i++) {
		paldata[i * 3] = tpal[i * 3] << 2;
		paldata[i * 3 + 1] = tpal[i * 3 + 1] << 2;
		paldata[i * 3 + 2] = tpal[i * 3 + 2] << 2;
	}
#endif


	return pal;
}



int	init_gfx(void)
{
	int	video_flags;

#ifndef NOVGA

#ifdef  SDLHACK
        if(SDL_Init(SDL_INIT_VIDEO) < 0) {
                printf("Couldn't initialize SDL: %s\n", SDL_GetError());
                return 0;
        }
        video_flags = (SDL_SWSURFACE|SDL_HWPALETTE);
        SDLscreen = SDL_SetVideoMode(VWIDTH, VHEIGHT, 8, video_flags);
        if(SDLscreen == NULL) {
                printf("Couldnt initialize video mode: %s\n", SDL_GetError());
                return 0;
        }
#else
        vga_init();
        printf("Using video mode #: %i.  See (/usr/include/)vga.h\n", VMODE);
        vga_setmode(VMODE);
#endif
#endif
}



int	close_gfx(void)
{

#ifndef	NOVGA
#ifdef	SDLHACK
	SDL_Quit();
#else
	vga_setmode(TEXT);
#endif
#endif

}
