/*
water bla bla bla

swivel | CSR
swivel@csrmusic.org
*/

#include	<stdio.h>
#include	"water.h"



struct WATER * new_water(int width, int height)
{
	struct WATER *	water;
	int		size = ((height + 2) * width);

	water = (struct WATER *)calloc(1, sizeof(struct WATER));
	if(water == NULL) {
		printf("Error allocating memory for water struct.\n");
		return NULL;
	}

	water->page_0 = (short *)calloc(2, size);
	if(water->page_0 == NULL) {
		printf("Error allocating memory for water page 0.\n");
		return NULL;
	}

	water->page_1 = (short *)calloc(2, size);
	if(water->page_1 == NULL) {
		printf("Error allocating memory for water page 1.\n");
		return NULL;
	}

	water->page_0 += width;
	water->page_1 += width;



	water->width = width;
	water->height = height;

	return water;
}


int	del_water(struct WATER * water)
{
	if(water == NULL) {
		printf("Water must be created before it can be deleted.\n");
		return 0;
	}

	free(water->page_0 - (water->width));
	free(water->page_1 - (water->width));
	free(water);
	return	1;
}


int	move_water(struct WATER * water, int density)
{
	int	temp;
	int	width, height, x, y;
	short	*last, *next;
	int	yoff = 0, off;
	

	if(water == NULL) {
		printf("Water must be created before it can be moved.\n");
		return 0;
	}

	width = water->width;
	height = water->height;


	switch(water->page) {
	
	case 0:
		next = water->page_0;
		last = water->page_1;
		water->page = 1;
		break;

	case 1:
		next = water->page_1;
		last = water->page_0;
		water->page = 0;
		break;

	default:
		printf("Sumfin went goofy with da water.\n");
		return 0;
	}


	for(y = 0; y < height; y++) {

		for(x = 0; x < width; x++) {	
			off = yoff + x;

			temp = 
			(last[off - width] +
			last[off - 1] +
			last[off + 1] +
			last[off + width]) -
			(next[off] << 1);

			temp >>= 1;

			next[off] = (temp - (temp >> density));
		}

		yoff += width;
	}


	return 1;
}




short *	water_page(struct WATER * water)
{
	switch(water->page) {
	
	case 0:
		return water->page_0;
		break;

	case 1:
		return water->page_1;
		break;

	default:
		printf("Sumfin went goofy with da water.\n");
		return NULL;
		break;
	}
}
