
// inline routines to handle 32-bit RGB packed and unpacked pixels
// rgb32 format bitmask is (0xff0000,0xff00,0xff)

#ifndef _RGB32_H_INCLUDED
#define _RGB32_H_INCLUDED

#include <ptc.h>

inline int32 red32( int32 c )
{
        return (c>>16)&0xff;
}

inline int32 green32( int32 c )
{
        return (c>>8)&0xff;
}

inline int32 blue32( int32 c )
{
        return c&0xff;
}

inline int32 rgb32( int32 r, int32 g, int32 b )
{
        return r<<16|g<<8|b;
}

inline int32 float_to_rgb32( float r, float g, float b )
{
        return int32(r*255.0)<<16|int32(g*255.0)<<8|int32(b*255.0);
}

inline void rgb32_to_float( int32 rgb, float &r, float g, float b )
{
        r = float(red32(rgb))*(1.0f/256.0f);
        g = float(green32(rgb))*(1.0f/256.0f);
        b = float(blue32(rgb))*(1.0f/256.0f);
}

inline int32 shift_rgb32( int32 a )
{
        return (a>>1)&0x7f7f7f;
}

inline int32 avg_rgb32( int32 a, int32 b )
{
        return shift_rgb32(a)+shift_rgb32(b);
}

inline int32 dec_rgb32( int32 c )
{
	int32 r = red32( c );
	int32 g = red32( c );
	int32 b = red32( c );
	if ( r )
		r--;
	if ( g )
		g--;
	if ( b )
		b--;
	return rgb32( r, g, b );
}

inline int32 inc_rgb32( int32 c )
{
	int32 r = red32( c );
	int32 g = red32( c );
	int32 b = red32( c );
	if ( r < 0xff )
		r++;
	if ( g < 0xff )
		g++;
	if ( b < 0xff )
		b++;
	return rgb32( r, g, b );
}
#endif // _RGB32_H_INCLUDED
