
/*
 *
 *	M A I N   M O D U L E
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <ctype.h>

#include "ray.h"

static const char *copyright_note = 
"\n\ndedicated to all visual basic coders"
"\ncopyleft 1998-99 by xdefrang@csi.com\n\n";

int main( int argc, char **argv )
{       
	VIEWPORT vp;
	SCENE scn;
	CAMERA cam;
	float t, k;
	int x, y;

	setbuf( stdout, NULL );
	printf( "please wait...\n" );

	if ( !load_scene( ( argc > 1 ) ? argv[1] : "demo.scn", &vp, &scn ) )
		exit( 1 );
	
	if ( !keyf_load( ( argc > 2 ) ? argv[2] : "kf", &scn ) )
		exit( 1 );

	keyf_init( &scn );
	fprintf( stderr, "keyf_init() succeeded\n" );

	scn.flags = RND_STD | RND_REFLECT | RND_SHADOWS;
	vp.width = 320;
	vp.height = 200;

	try {
		Format fmt( 32, 0x00ff0000, 0x0000ff00, 0x000000ff );
		Console *con = new Console;
		con->open( "raytracing", vp.width, vp.height, fmt );
		Surface *surf = new Surface( vp.width, vp.height, fmt );

		vp.width = 81;
		vp.height = 36;
		t = 0.0;

		while ( !con->key() ) {

			uint *buffer = (uint *)surf->lock();

			scn.light.x = 400*cos(t*M_PI);
			scn.light.y = 400-150*cos(cos(t*M_PI)*M_PI);			
			scn.light.z = 400*sin(t*M_PI);

			scn.cam.rvp.x = 600*sin(t*M_PI);
			scn.cam.rvp.y = 300-100*cos(cos(t*M_PI)*M_PI);
			scn.cam.rvp.z = 600*cos(t*M_PI); 

			render( scn, vp );
			interp_grid( buffer+50*320 );

			surf->unlock();
			surf->copy( *con );
			con->update();
			
			t += 0.01;
		}
	} catch ( Error &err ) {
		err.report;
	}

	printf( copyright_note );

	return 0;
}
