
/*
 *
 *      I N T E R P O L A T I O N
 *
 */

#include "ray.h"

#ifdef __cplusplus
inline void interp_block( int x, int y, unsigned int *buff )
#else
static void interp_block( int x, int y, unsigned int *buff )
#endif
{
	int ryl = grid[x][y].r<<8;	
	int gyl = grid[x][y].g<<8;	
	int byl = grid[x][y].b<<8;
	int dryl = (grid[x][y+1].r-grid[x][y].r)<<6;
	int dgyl = (grid[x][y+1].g-grid[x][y].g)<<6;
	int dbyl = (grid[x][y+1].b-grid[x][y].b)<<6;
	int ryr = grid[x+1][y].r<<8;	
	int gyr = grid[x+1][y].g<<8;	
	int byr = grid[x+1][y].b<<8;
	int dryr = (grid[x+1][y+1].r-grid[x+1][y].r)<<6;
	int dgyr = (grid[x+1][y+1].g-grid[x+1][y].g)<<6;
	int dbyr = (grid[x+1][y+1].b-grid[x+1][y].b)<<6;

	for ( int j = 0; j < 4; j++ ) {
		int rx = ryl;
		int gx = gyl;
		int bx = byl;
		int drx = (ryr-ryl)>>2;
		int dgx = (gyr-gyl)>>2;
		int dbx = (byr-byl)>>2;
		for ( int i = 0; i < 4; i++ ) {
#ifdef __MOTION_BLUR__
			int pix = ((rx<<8)&0xff0000)|(gx&0x00ff00)|((bx>>8)&0x0000ff);
			*buff++ = ((*buff>>1)&0x7f7f7f7f)+((pix>>1)&0x7f7f7f7f);
#else		
			*buff++ = ((rx<<8)&0xff0000)|(gx&0x00ff00)|((bx>>8)&0x0000ff);
#endif			
			rx += drx;
			gx += dgx;
			bx += dbx;
		}
		ryl += dryl;
		gyl += dgyl;
		byl += dbyl;
		ryr += dryr;
		gyr += dgyr;
		byr += dbyr;
		buff += 320-4;
	}

}

void interp_grid( unsigned int *buff )
{
        int i, j;
        for ( j = 0; j < 35; j++ )
                for ( i = 0; i < 80; i++ ) 
                        interp_block( i, j, buff+(j*4*320)+(i<<2) );
}
