
/*
 *
 *      G E N E R I C   M O D E L
 *
 */

#include "ray.h"

/* this horrible interface should disappear in some C++ port... wait and see! ;) */

float model_distance( RAY ray, MODEL obj )
{
        switch( obj.id ) {
        case MDL_PLANE:
        case MDL_PLANE_TEXT:
                return plane_distance( ray, *((MODEL_PLANE *)obj.model_info) );
        case MDL_SPHERE:
        case MDL_SPHERE_TEXT:
                return sphere_distance( ray, *((MODEL_SPHERE *)obj.model_info) );
        case MDL_ELLIPSOID:
        case MDL_ELLIPSOID_TEXT:
                return ellipsoid_distance( ray, *((MODEL_ELLIPSOID *)obj.model_info) );

        }
        return INFINITE;
}

void model_hitnormal( MODEL obj, VECTOR hit, VECTOR *norm )
{
        switch( obj.id ) {
        case MDL_PLANE:
        case MDL_PLANE_TEXT:
                plane_hitnormal( *((MODEL_PLANE *)obj.model_info), hit, norm );
                break;
        case MDL_SPHERE:
        case MDL_SPHERE_TEXT:
                sphere_hitnormal( *((MODEL_SPHERE *)obj.model_info), hit, norm );
                break;
        case MDL_ELLIPSOID:
        case MDL_ELLIPSOID_TEXT:
                ellipsoid_hitnormal( *((MODEL_ELLIPSOID *)obj.model_info), hit, norm );
                break;
        default:
                norm->x = norm->y = norm->z = 0.0f;
        }
}

RGB model_hitcolor( MODEL obj, VECTOR hit, VECTOR norm )
{
	RGB rgb;
        switch( obj.id ) {
        case MDL_PLANE:
                return ((MODEL_PLANE *)(obj.model_info))->color;
        case MDL_SPHERE:
                return ((MODEL_SPHERE *)(obj.model_info))->color;
        case MDL_ELLIPSOID:
                return ((MODEL_ELLIPSOID *)(obj.model_info))->color;
        case MDL_PLANE_TEXT:
                return plane_text_hitcolor( *((MODEL_PLANE_TEXT *)obj.model_info), hit );
        case MDL_SPHERE_TEXT:
                return sphere_text_hitcolor( *((MODEL_SPHERE_TEXT *)obj.model_info), norm );
        case MDL_ELLIPSOID_TEXT:
                return ellipsoid_text_hitcolor( *((MODEL_ELLIPSOID_TEXT *)obj.model_info), norm );
	default:
		rgb.r = rgb.g = rgb.b = 0.0f;
		return rgb;
	}
}

float model_reflect( MODEL obj )
{
	switch ( obj.id ) {
	case MDL_PLANE:
		return ((MODEL_PLANE *)(obj.model_info))->reflect;
	case MDL_SPHERE:
		return ((MODEL_SPHERE *)(obj.model_info))->reflect;
	case MDL_ELLIPSOID:
		return ((MODEL_ELLIPSOID *)(obj.model_info))->reflect;
	case MDL_PLANE_TEXT:
		return ((MODEL_PLANE_TEXT *)(obj.model_info))->reflect;
	case MDL_SPHERE_TEXT:
		return ((MODEL_SPHERE_TEXT *)(obj.model_info))->reflect;
	case MDL_ELLIPSOID_TEXT:
		return ((MODEL_ELLIPSOID_TEXT *)(obj.model_info))->reflect;
	default:
		return 0.0f;
	}
}
