

#include "RayTrace.h"


static RAYTR::VIEWPORT vp;
static RAYTR::SCENE scn1;

void ray1_init()
{
	if ( !RAYTR::load_scene( "data/final.scn", &vp, &scn1 ) ) {
		cerr << "RAYTR: error loading scene" << endl;
		exit( 1 );
	}
/*	
	if ( !RAYTR::keyf_load( ( argc > 2 ) ? argv[2] : "kf", &scn ) )
		cerr << "RAYTR: error loading keyframer data" << endl;
		exit( 1 );
	}

	RAYTR::keyf_init( &scn1 );
*/
	scn1.flags = RAYTR::RND_STD | RAYTR::RND_REFLECT | RAYTR::RND_SHADOWS;
}


void ray1_action( float t )
{
	scn1.light.x = 400*cos(t*M_PI);
	scn1.light.y = 400-150*cos(cos(t*M_PI)*M_PI);			
	scn1.light.z = 400*sin(t*M_PI);

	scn1.cam.rvp.x = 600*sin(t*M_PI);
	scn1.cam.rvp.y = 300-100*cos(cos(t*M_PI)*M_PI);			
	scn1.cam.rvp.z = 600*cos(t*M_PI);
			
	RAYTR::render( scn1, vp );
	RAYTR::interp_grid( psurf );
}

