#include "wuline.h"
#include "screen.h"

// clipe une ligne

void clip_line(float ax,float ay,float bx,float by,DWORD *ecran,DWORD *degrade)
{
 // les deltas
 float dx=bx-ax;
 float dy=by-ay;
 float px=dx/dy; // attention a la divby0
 float py=dy/dx;

//{clipping}

if (ax < LeftClip) { ay += (LeftClip+1-ax)*py; ax = LeftClip; }
else if (ax >= RightClip) { ay += (RightClip-1-ax)*py; ax=RightClip-1; }

if (bx < LeftClip) { by += (LeftClip+1-bx)*py; bx = LeftClip; }
else if (bx >= RightClip) { by += (RightClip-1-bx)*py; bx=RightClip-1; }

if (ay < TopClip) { ax += (TopClip+1-ay)*px; ay = TopClip; }
else if (ay >= BotClip) { ax += (BotClip-1-ay)*px; ay=BotClip-1; }

if (by < TopClip) { bx += (TopClip+1-by)*px; by = TopClip; }
else if (by >= BotClip) { bx += (BotClip-1-by)*px; by=BotClip-1; }


//tester si la ligne est en dehors de l'ecran
// if (clipBits1&clipbits2)

if ((ax==LeftClip && bx==LeftClip) ||
    (ax==(RightClip-1) && bx==(RightClip-1)) ||
    (ay==TopClip && by==TopClip) ||
    (ay==(BotClip-1) && by==(BotClip-1))) return;

 wu_line(ecran,degrade,WritePageWidth, ax*65536, ay*65536, bx*65536, by*65536);

}


#define ceil(x) ((x+0xffff)>>16)

// degrade[32]=32 nivos

void wu_line(DWORD *ecran,DWORD *degrade, int largeur, const int x1, const int y1, const int x2, const int y2)
	{
	int  DeltaX, DeltaY;
	register int i;

    DWORD *p1=ecran+largeur*ceil(y1)+ceil(x1); 

    DeltaX = x1 - x2;
	if (DeltaX < 0) DeltaX = -DeltaX;
    DeltaY = y1 - y2;
	if (DeltaY < 0) DeltaY = -DeltaY;

	if (DeltaX > DeltaY)	
        i = DeltaX;
	else
		i = DeltaY;

        i>>=16;
        ++i; // no divide by zero error

	if (DeltaX < DeltaY)
        {       register SlopeX=(x2-x1)/i;
                register t=0;
                --i;
                if ((y2-y1)<0) largeur=-largeur;
		while (i)
			{
			register int i2;
			register int x;			
	
			x = t >> 16;

                        i2 = (t&0xFF00);
                        p1[x+1]  = degrade[i2>>11];
                        i2 ^= 0xFF00;
                        p1[x] = degrade[i2>>11]; 
				
            t += SlopeX; p1+=largeur; --i;
			}
		}	

	else
                {
                register SlopeY = (y2-y1)/i;
                register int t=0, incr=1;
                --i;
                if ((x2-x1)<0) incr=-1;
		while (i)
			{
			register int i2;
			register int y;			

                        y = t >> 16; y*=largeur;
                        
                        i2 = (t&0xFF00);
                        p1[y+largeur] = degrade[i2>>11];
                        i2 ^= 0xFF00;
                        p1[y] = degrade[i2>>11];
				
            t += SlopeY; p1+=incr; --i;
			}
		}
	}
