#ifndef __STRUCTS_H
#define __STRUCTS_H

#include "maxima.h"

// _ = inverse

typedef struct 
{
 float x,y,z;
}vector;

// une matrice est un tableau par convention float nom_matrice[3*3];

typedef struct
{
 int clip; // booleen si la vertex sort de l'ecran apres la projection 3d->2d
 int counter; // permet de savoir si la vertex a deja subis les rotations

 int y;      // ceil(p.y); pour la routine de rasterisation
 vector pos; // coordonnees originales
 vector t;   // coordonees transformees
 vector p;   // point projete sur l'ecran (p.z=1.0/t.z)

 float um,vm;   // coordonnees de mapping originales
 float _u,_v;   // um*p.z vm*p.z
 vector intensite; // intensite lumineuse pour le gouro rgb
 vector normal; // utile pour le gouraud, l'envmap
}vertex;

typedef struct
{
 int type;   // flat, dot , wireframe, transparence...
 vertex *vertices; // le tablo de vertices le meme pour tous les polys d'un objet
 int n; // nombre de vertices du poly
 int p[MAX_VERTICES_PAR_FACE]; // les indices des vertices dans le tablo des vertices
 int map; // la map dans la table des textures de l'objet
 vector normal; // la normale a la face pour le backface culling
}M3D_polygon;

// le tablo vert2polys permet de retrouver les polys qui utilisent la vertex
typedef struct
{
 int n; // nombre de polygones utilises par cette vertice
 int p[MAX_FACES_PAR_VERTEX];
}vertice2polygons;

typedef struct
{
 vector pos; // on ajoute a tous les objets la position de la camera
 vector dir; // c'est les coeficients de rotations de la camera (lookat pt)
 float fov,roll; 

 short num_rolls_keys;
 short num_fovs_keys;
 short num_lookats_keys;
 short num_positions_keys;

 vector positions[MAX_KEYS];
 short positions_times[MAX_KEYS];
 vector lookats[MAX_KEYS];
 short lookats_times[MAX_KEYS];
 float fovs[MAX_KEYS];
 short fovs_times[MAX_KEYS];
 float rolls[MAX_KEYS];
 short rolls_times[MAX_KEYS];
}camera;

typedef struct
{
 short num_positions_keys;
 short num_intensites_keys;
 vector pos;
 vector intensite; // les intensites rgb

 vector positions[MAX_KEYS];
 short positions_times[MAX_KEYS];
 vector intensites[MAX_KEYS]; // vector = (r,g,b)
 short intensites_times[MAX_KEYS];
}ponctual;

typedef struct
{
 short num_positions_keys;
 short num_lookats_keys;
 short num_intensites_keys;
 short num_fovs_keys;
 vector pos;
 vector dir;
 float  fov;
 vector intensite;

 vector positions[MAX_KEYS];
 short positions_times[MAX_KEYS];
 vector lookats[MAX_KEYS];
 short lookats_times[MAX_KEYS];
 vector intensites[MAX_KEYS];
 short intensites_times[MAX_KEYS]; 
 float fovs[MAX_KEYS];
 short fovs_times[MAX_KEYS];
}spot;

typedef struct
{
 short num_keys_positions;
 short type; // flare lensflare etc
 short taille;
 short map; // la map dans la table textures
 short radius;

 vector pos; // la position originale
 vector p;   //la position projetee

 vector positions[MAX_KEYS];
 short positions_times[MAX_KEYS];
}flare;

typedef struct
{
 int num_vertices;
 int num_polygons;
 int num_more_polys;
 int num_more_verts;
 int num_keys_position;
 int num_keys_angle;
 int num_keys_morphing;
 int num_flares;

 float  rayon;      // le rayon de la sphere englobante
 vector position;   // translation ds l'espace
 vector angle;      // les trois angles de rotations pour contruire la matrice de rot

 vertex  *vertices; // le tablo de vertices
 M3D_polygon *polygons; // le tablo de polygones
 vector  *morph_vertices; // toutes les etapes si morphing les unes a la suite des autres
 vertice2polygons *vert2polys; // permet de connaitre les indices des polygones
                             // qui utilisent chaque vertex (normales aux vertices)

 vector keys_position[MAX_KEYS]; // le path a interpoler avec une spline
 short   keys_position_times[MAX_KEYS]; // le temps ecoule entre chaque cle
 vector keys_angle[MAX_KEYS];   // permet de trouver la matrice de rotation
 short   keys_angle_times[MAX_KEYS];
 short   keys_morphing_times[MAX_KEYS]; // les temps entre chaque objets cles

 // un objet peut etre constitue de polys mais aussi de ...
 flare flares[MAX_FLARES];
}object;

// la structure globales qui contient les infos de la scene courante
// on pourais faire un tablo de scene si on rend plusieurs scenes en
// meme temps

typedef struct
{
 short num_cameras_keys;
 int num_OBJECTS;
 int num_PONCTUALS;
 int num_SPOTS;
 int num_CAMERAS;
 int num_FLARES;
// int num_LENSFLARES;
 int num_MIRORS;
 int num_PROJECTORS;
// int BOOL_PVT;
 int RENDERING; // type du rendu (motion blur, wireframe, ...)
 
 int frame; // le compteur d'images rendue

 // la distance au plan -> utiliser une matrice de scaling plutot
 float DIST_PLANEX;  // = (fsqrt(fsqr(SXDIV2/fcos((M_PI-(FieldOfView*M_PI/180.0))*0.5))+SXDIV2*SXDIV2));
 float DIST_PLANEY;  // = (ASPECT_RATIO*DIST_PLANEX);
 
 float CMATRIX[3*3]; // la matrice de rotation de la camera
 camera *curentCamera; // la camera active

 void *textures[MAX_TEXTURES];  // alignee sur 256k
 object objets[MAX_OBJECTS]; // donees mise a jour au loading de l'objet

 // camera track
 short cameras_num[MAX_KEYS];
 short cameras_keys_times[MAX_KEYS];

 // donnees globales -> la (les) camera(s) et les lumieres
 camera cameras[MAX_CAMERAS];
 ponctual ponctuals[MAX_PONCTUALS];
 spot spots[MAX_SPOTS];
 flare flares[MAX_FLARES];
}scene;

#endif
