// les vertices et les coordonees de textures sont en float (0->1)

//#include "mytypes.h"
#include "loadscn.h"
#include "normals.h"
#include "tinymath.h"
#include "screen.h"
#include "maxima.h"
#include "typebits.h"

// format un peu aproximatif donc utiliser votre editeur Hex sur les .scn :-)

/*
format des .brl :

nombre de vertexs
nombre de faces
rayon de la sphere englobante
byte_info
byte de numero de texture pour tous les polys de l'objet
byte de type commun  pour tous les polys
nombre de keys du track position (une key = position fixe)
nombre de keys du track rotation (une key = orientation fixe)
nombre de keys du track morphing (une key = pas de morphing)
nombre de flares
liste des flares (x,y,z,type,taille,map)
liste des vertices (X Y Z)
liste des faces (3 words)
liste des coordonnees de textures (2*short)
liste du numero de texture de chaque polygone (BYTE)
liste du type de chaque polygone (BYTE)
liste des keys position (X Y Z)
liste des temps (Word)
liste des keys d'angles (X Y Z)
liste des temps (Word)
*/

/*
format simplifie des scn:

nombre d'objets
nombre de lights ponctueles
nombre de spots
nombre de cameras
nombre de flares
nombre de lensflares
nombre de mirrors
byte PVT ?

nombre de keys du track camera active (lerp)
liste des numeros de camera (WORD)
liste des keys time (WORD)

lights: nombre de keys position  (1 = position fixe)
        liste des keys positions ( 3 WORDS)
        liste des key time
        nombre de keys intensite  (1 = fixe)
        liste des keys intensite (WORD) lerp
        liste des key time

spots: nombre de keys position (1 = position fixe)
       liste des keys positions ( 3 WORDS)
       liste des key time
       nombre de keys lookat    (1 = point fixe)
       liste des keys lookat ( 3 WORDS)
       liste des keys time
       nombre de keys intensite (1 = fixe) lerp
       liste des keys intensites (WORD)
       liste des key time
       nombre de keys FOV (1 = fixe) lerp
       liste des keys FOV (WORD)
       liste des key time

camera: nombre de keys position  (1 = position fixe)
        liste des keys positions ( 3 WORDS)
        liste des keys time
        nombre de keys lookat    (1 = point fixe)
        liste des keys lookat ( 3 WORDS)
        liste des keys time
        nombre de keys FOV/roll  (1 = fixe)
        liste des keys FOV/roll ( 3 WORDS)
        liste des keys time

flares: type du flare
        taille du flare (WORD) zoom
        numero de texture
        nombre de keys position  (1 = position fixe)
        liste des keys positions ( 3 WORDS)
        liste des key time

le contenus de tous les fichiers .brl corespondants aux objets

PVT encode en RLE (si specifie dans le header)
*/

// fonction d'allocation d'un objet

int alloc_brl(object *objet)
{
 if (!(objet->vertices=(vertex*)malloc((MORE_VERTS+objet->num_vertices)*sizeof(vertex)))) return -1;
 if (!(objet->polygons=(M3D_polygon*)malloc((MORE_POLYS+objet->num_polygons)*sizeof(M3D_polygon)))) return -1;
 if (!(objet->vert2polys=(vertice2polygons*)malloc((objet->num_vertices)*sizeof(vertice2polygons)))) return -1;
/*
 if (objet->num_keys_morphing)
  if (!(objet->morph_vertices=(vector*)malloc(objet->num_keys_morphing*objet->num_vertices*sizeof(vector)))) return -1;
*/
 return 0;
}

// fonction de desallocation d'un objet

void dealloc_brl(object *objet)
{
 free(objet->vertices);
 free(objet->polygons); 
 free(objet->vert2polys); 
/*
 if (objet->num_keys_morphing) 
  free(objet->morph_vertices);
*/
}

// desalocation d'une scene

void unload_scn(scene *scene3d)
{
 register int i;
 for (i=0; i<scene3d->num_OBJECTS; ++i)
  dealloc_brl(&(scene3d->objets[i]));
}

// lis un objet et remplis sa structure
int load_brl(object *objet,FILE *fp)
{
    short  header[16];
    char  *load_buffer2;
    short *load_buffer;
    float *load_buffer3;

    int i,j,a,indice;
    short info,texture,type;
    int size2,size,size3;

 if(fread(header,sizeof(short),10,fp)!=10) return -1;
 objet->num_vertices=header[0];
 objet->num_polygons=header[1];
 objet->rayon=header[2]; // le rayon de la sphere englobante
 info=header[3];
 texture=header[4];
 type=header[5];
 objet->num_keys_position=header[6];
 objet->num_keys_angle=header[7];
 objet->num_keys_morphing=header[8];
 objet->num_flares=header[9];

 printf("verts: %d polys: %d\n",objet->num_vertices,objet->num_polygons);
 if (alloc_brl(objet)) return -1; // on alloue la place necessaire

 //on calcule la taille des tableaux 

 // les donnees float
 size3=(header[0]+objet->num_flares)*3;
 //if (header[8]) size3+=(header[8]-1)*header[0]*3; // les vertices
 if (info&1) size3+=header[0]*2; // coordonees de texture

 // les donnees words
 size=header[1]*3; // les indices de vertices pour les polys

 // les donnees bytes
 size2=0;
 if (info&2) size2+=header[1]; // numeros de texture
 if (info&4) size2+=header[1]; // types de polygone

 // on fait un gros malloc
 if (!(load_buffer3=(float*)malloc(size3*sizeof(float)))) return -1;
 if (!(load_buffer=(short*)malloc(size*sizeof(short)))) return -1;
 if (size2) if (!(load_buffer2=(char*)malloc(size2))) return -1;


 //on lis les flares

/*
 if (fread(load_buffer3,sizeof(float),objet->num_flares*3,fp)!=objet->num_flares*3) return -1;
 if (fread(load_buffer,sizeof(short),objet->num_flares*3,fp)!=objet->num_flares*3) return -1;

 for (indice=i=0;i<objet->num_flares;++i,indice+=3)
 {
  objet->flares[i].num_keys_positions=1;

  objet->flares[i].pos.x=load_buffer3[indice];
  objet->flares[i].pos.y=load_buffer3[indice+1];
  objet->flares[i].pos.z=load_buffer3[indice+2];

  objet->flares[i].type=load_buffer[indice];
  objet->flares[i].taille=load_buffer[indice+1];
  objet->flares[i].map=load_buffer[indice+2];
 }
*/

 // calcul de la taille des vertices+vertices de morph
 //size3-=objet->num_flares*3;
 if (info&1) size3-=header[0]*2; // coordonees de texture

 // on lis les coordonees de vertices
 if (fread(load_buffer3,sizeof(float),size3,fp)!=size3) return -1;

 // rempli le tablo des vertices
 for (indice=i=0;i<objet->num_vertices;indice+=3,++i)
 {
  objet->vertices[i].pos.x=load_buffer3[indice];
  objet->vertices[i].pos.y=load_buffer3[indice+1];
  objet->vertices[i].pos.z=load_buffer3[indice+2];
  objet->vertices[i].counter=0;
 }

/*
 if (objet->num_keys_morphing)
 {
  //copier
  for (i=0;i<objet->num_vertices;++i)
  {
   objet->morph_vertices[i].x=objet->vertices[i].pos.x;
   objet->morph_vertices[i].y=objet->vertices[i].pos.y;
   objet->morph_vertices[i].z=objet->vertices[i].pos.z;
  }
 
  // pour tous les tablos de morphings
  for (a=objet->num_vertices,j=1;j<objet->num_keys_morphing;++j,a+=objet->num_vertices)
  {
   //copier
   for (i=0;i<objet->num_vertices;++i,indice+=3)
   {
    objet->morph_vertices[a+i].x=load_buffer3[indice];
    objet->morph_vertices[a+i].y=load_buffer3[indice+1];
    objet->morph_vertices[a+i].z=load_buffer3[indice+2];
   }
  }
 }
*/

 // on lis les indices de vertices pour chaque poly (3 indices)
 if (fread(load_buffer,sizeof(short),size,fp)!=size) return -1;

 // rempli le tablo des polygones
 for (indice=i=0;i<objet->num_polygons;++i,indice+=3)
 {
  objet->polygons[i].n=3; 
  objet->polygons[i].p[0]=load_buffer[indice];
  objet->polygons[i].p[1]=load_buffer[indice+1];
  objet->polygons[i].p[2]=load_buffer[indice+2];
  // important pour le clipping 2d: last point=first point
  objet->polygons[i].p[3]=load_buffer[indice];
  //initialisation des pointeurs vers le tablo des vertices pour chaque poly
  objet->polygons[i].vertices=objet->vertices;
 }

 //#define TEXTURE_UV 1     // les coordonnees de texture sont enregistrees ?

 // les coordonees de texture
 if (info&1) 
 {
  // on lis le fichier
  if (fread(load_buffer3,sizeof(float),objet->num_vertices*2,fp)!=objet->num_vertices*2) return -1;

  for (indice=i=0;i<objet->num_vertices;++i,indice++)
   objet->vertices[i].um=load_buffer3[indice]*256.0;
  for (i=0;i<objet->num_vertices;++i,indice++)
   objet->vertices[i].vm=load_buffer3[indice]*256.0;
 }

 // on lis le fichier
 if (size2) if (fread(load_buffer2,sizeof(char),size2,fp)!=size2) return -1;

 indice=0;

 //#define NUM_TEXTURE 2    // une liste de num de texture pour chaque poly ?

 // les numeros de texture
 if (info&2)
  for (i=0;i<objet->num_polygons;++i,++indice)
   objet->polygons[i].map=load_buffer2[indice];
 else
  for (i=0;i<objet->num_polygons;++i)
   objet->polygons[i].map=texture;

 //#define TYPE 4           // y a il une liste du type de chaque polys ?

 // les types
 if (info&4)
  for (i=0;i<objet->num_polygons;++i,++indice)
   objet->polygons[i].type=load_buffer2[indice];
 else
  for (i=0;i<objet->num_polygons;++i)
   objet->polygons[i].type=type;


 // pos et rot
 size=(objet->num_keys_position+objet->num_keys_angle)*3; // les coordonnees de splines

 // on lis le fichier
 if (fread(load_buffer3,sizeof(float),size,fp)!=size) return -1;

 indice=0;
 for (i=0;i<objet->num_keys_position;++i,indice+=3)
 {
  objet->keys_position[i].x=load_buffer3[indice];
  objet->keys_position[i].y=load_buffer3[indice+1];
  objet->keys_position[i].z=load_buffer3[indice+2];
 }
 for (i=0;i<objet->num_keys_angle;++i,indice+=3)
 {
  objet->keys_angle[i].x=load_buffer3[indice]; //*M_PI/180.0;
  objet->keys_angle[i].y=load_buffer3[indice+1]; //*M_PI/180.0;
  objet->keys_angle[i].z=load_buffer3[indice+2]; //*M_PI/180.0;
 }

 // les temps rot et pos et morph
 size=(objet->num_keys_position+objet->num_keys_angle+objet->num_keys_morphing); 

 // on lis le fichier
 if (fread(load_buffer,sizeof(short),size,fp)!=size) return -1;

 indice=0;
 for (i=0;i<objet->num_keys_position;++i,++indice)
  objet->keys_position_times[i]=load_buffer[indice];

 for (i=0;i<objet->num_keys_angle;++i,++indice)
  objet->keys_angle_times[i]=load_buffer[indice];

 for (i=0;i<objet->num_keys_morphing;++i,++indice)
  objet->keys_morphing_times[i]=load_buffer[indice];

 free(load_buffer);
 free(load_buffer3);
 if (size2) free(load_buffer2);

 // construction des normales aux vertexs et aux faces
 buildVert2Polys(objet);
 calcFacesNormal(objet); 
 calcVertsNormal(objet);

 return 0;
}

// loading d'une scene

void loadCameratrack(scene *scene3d, FILE *fp)
{
    register int i,k;
    short temp;
    short tablo[256];

 fread(&temp,sizeof(short),1,fp);
 scene3d->num_camera_keys=temp;

 fread(tablo,sizeof(short),2*temp,fp);
 for (k=i=0; k<temp; ++k,i+=2)
 {
  scene3d->camera_num[k]=tablo[i];
  scene3d->cameras_keys_times[k]=tablo[i+1];
 }
}

int loadPonctual(ponctual *ponctuals, FILE *fp)
{
    register int i,k;
    short *load_buffer;
    float *load_buffer3;
    short temp;

    // on alloue un buffer qu'on espere suffisant
    if (!(load_buffer=(short*)malloc(8192)))  return -1;
    if (!(load_buffer3=(float*)malloc(8192))) return -1;

 fread(&temp,sizeof(short),1,fp);
 ponctuals->num_positions_keys=temp;

 printf("nbr de keys pos de la ponctual : %d\n",temp);

 fread(load_buffer3,sizeof(float),3*temp,fp);
 for (k=i=0;i<3*temp;i+=3,++k)
 {
  ponctuals->positions[k].x=load_buffer3[i];
  ponctuals->positions[k].y=load_buffer3[i+1];
  ponctuals->positions[k].z=load_buffer3[i+2];
 }

 fread(load_buffer,sizeof(short),temp,fp);
 for (i=0;i<temp;++i)
  ponctuals->positions_times[i]=load_buffer[i];

 fread(&temp,sizeof(short),1,fp);
 ponctuals->num_intensites_keys=temp;

 printf("nbr de keys intensite de la ponctual : %d\n",temp);

 // les intensites rgb
 fread(load_buffer,sizeof(short),temp,fp);
 for (k=i=0;i<temp;++i,k+=3)
 {
  ponctuals->intensites[i].x=load_buffer[k];
  ponctuals->intensites[i].y=load_buffer[k+1];
  ponctuals->intensites[i].z=load_buffer[k+2];
 }

 fread(load_buffer,sizeof(short),temp,fp);
 for (i=0;i<temp;++i)
  ponctuals->intensites_times[i]=load_buffer[i];

 free(load_buffer);
 free(load_buffer3);
 return 0;
}

int loadSpot(spot *spots, FILE *fp)
{
    register int i,k;
    short *load_buffer;
    float *load_buffer3;
    short temp;

    // on alloue un buffer qu'on espere suffisant
    if (!(load_buffer=(short*)malloc(8192)))  return -1;
    if (!(load_buffer3=(float*)malloc(8192))) return -1;

 fread(&temp,sizeof(short),1,fp);
 spots->num_positions_keys=temp;

 fread(load_buffer3,sizeof(float),3*temp,fp);
 for (k=i=0;i<3*temp;i+=3,++k)
 {
  spots->positions[k].x=load_buffer3[i];
  spots->positions[k].y=load_buffer3[i+1];
  spots->positions[k].z=load_buffer3[i+2];
 }

 fread(load_buffer,sizeof(short),temp,fp); 
 for (i=0;i<temp;++i)
  spots->positions_times[i]=load_buffer[i];

 fread(&temp,sizeof(short),1,fp);
 spots->num_lookats_keys=temp;

 fread(load_buffer3,sizeof(float),3*temp,fp);
 for (k=i=0;i<3*temp;i+=3,++k)
 {
  spots->lookats[k].x=load_buffer3[i];
  spots->lookats[k].y=load_buffer3[i+1];
  spots->lookats[k].z=load_buffer3[i+2];
 }

 fread(load_buffer,sizeof(short),temp,fp);
 for (i=0;i<temp;++i)
  spots->lookats_times[i]=load_buffer[i];

 fread(&temp,sizeof(short),1,fp);
 spots->num_intensites_keys=temp;

 // les intensites = floats entre 0 et 1 ??
 fread(load_buffer,sizeof(short),2*temp,fp);
 for (k=i=0;i<temp;++i,k+=3)
 {
  spots->intensites[i].x=load_buffer[k];
  spots->intensites[i].y=load_buffer[k+1];
  spots->intensites[i].z=load_buffer[k+2];
 }
 k=i;
 for (i=0;i<temp;++i,++k)
  spots->intensites_times[i]=load_buffer[k];

 fread(&temp,sizeof(short),1,fp);
 spots->num_fovs_keys=temp;

 fread(load_buffer,sizeof(short),2*temp,fp);
 for (i=0;i<temp;++i)
  spots->fovs[i]=180-load_buffer[i];
 k=i;
 for (i=0;i<temp;++i,++k)
  spots->fovs_times[i]=load_buffer[k];

 free(load_buffer);
 free(load_buffer3);
 return 0;
}

int loadCamera(camera *cameras, FILE *fp)
{
    register int i,k;
    short *load_buffer;
    float *load_buffer3;
    short temp;

    // on alloue un buffer qu'on espere suffisant
    if (!(load_buffer=(short*)malloc(8192)))  return -1;
    if (!(load_buffer3=(float*)malloc(8192))) return -1;

 // lookats
 fread(&temp,sizeof(short),1,fp);
 cameras->num_lookats_keys=temp;

 fread(load_buffer3,sizeof(float),3*temp,fp);
 for (k=i=0;k<temp;i+=3,++k)
 {
  cameras->lookats[k].x=load_buffer3[i];
  cameras->lookats[k].y=load_buffer3[i+1];
  cameras->lookats[k].z=load_buffer3[i+2];
 }

 fread(load_buffer,sizeof(short),temp,fp);
 
 for (i=0;i<temp;++i)
  cameras->lookats_times[i]=load_buffer[i];

 // positions
 fread(&temp,sizeof(short),1,fp);
 cameras->num_positions_keys=temp;

 fread(load_buffer3,sizeof(float),3*temp,fp);
 for (k=i=0;k<temp;i+=3,++k)
 {
  cameras->positions[k].x=load_buffer3[i];
  cameras->positions[k].y=load_buffer3[i+1];
  cameras->positions[k].z=load_buffer3[i+2];
 }

 fread(load_buffer,sizeof(short),temp,fp);

 for (i=0;i<temp;++i)
  cameras->positions_times[i]=load_buffer[i];

 // le roll
 fread(&temp,sizeof(short),1,fp);
 cameras->num_rolls_keys=temp;

 fread(load_buffer3,sizeof(float),temp,fp);
 for (i=0;i<temp;++i)
  cameras->rolls[i]=load_buffer3[i]*(M_PI/180.0);

 fread(load_buffer,sizeof(short),temp,fp);
 for (i=0;i<temp;++i)
  cameras->rolls_times[i]=load_buffer[i];

 // le FOV
 fread(&temp,sizeof(short),1,fp);
 cameras->num_fovs_keys=temp;

 fread(load_buffer3,sizeof(float),temp,fp);
 for (i=0;i<temp;++i)
  cameras->fovs[i]=load_buffer3[i];

 fread(load_buffer,sizeof(short),temp,fp);
 for (i=0;i<temp;++i)
  cameras->fovs_times[i]=load_buffer[i];

 free(load_buffer);
 free(load_buffer3);

 printf("done\n");
 return 0;
}

int loadFlare(flare *flares, FILE *fp)
{
    register int i,k;
    short *load_buffer;
    float *load_buffer3;
    short temp;

    // on alloue un buffer qu'on espere suffisant
    if (!(load_buffer=(short*)malloc(8192)))  return -1;
    if (!(load_buffer3=(float*)malloc(8192))) return -1;

 fread(load_buffer,2,4,fp);
 flares->type=load_buffer[0];
 flares->taille=load_buffer[1];
 flares->map=load_buffer[2];
 flares->num_keys_positions=temp=load_buffer[3];

 printf("nbr de keys pos du flare : %d\n",load_buffer[3]);

 fread(load_buffer3,sizeof(float),3*temp,fp);
 for (k=i=0;i<3*temp;i+=3,++k)
 {
  flares->positions[k].x=load_buffer3[i];
  flares->positions[k].y=load_buffer3[i+1];
  flares->positions[k].z=load_buffer3[i+2];
 }

 fread(load_buffer,sizeof(short),temp,fp);

 for (i=0;i<temp;++i)
  flares->positions_times[i]=load_buffer[i];

 free(load_buffer);
 free(load_buffer3);
 return 0;
}

// remplis la structure globale scene3d

int load_scn(char *strng, scene *scene3d)
{
    char header[8];
    int j;
    FILE *fp;

    if (!(fp=fopen(strng,"rb"))) return -1;    
    if(fread(header,1,8,fp)!=8) return -1; // le header de 8 bytes

scene3d->num_OBJECTS=header[0];
scene3d->num_PONCTUALS=header[1];
scene3d->num_SPOTS=header[2];
scene3d->num_CAMERAS=header[3];
scene3d->num_FLARES=header[4];
//scene3d->num_LENSFLARES=header[5];
scene3d->num_MIRORS=header[6];
//scene3d->BOOL_PVT=header[7];
scene3d->RENDERING=header[7];


// le track de changement de cameras
loadCameratrack(scene3d, fp);

// pour toute les lights
for (j=0;j<scene3d->num_PONCTUALS;++j)
 if (loadPonctual(scene3d->ponctuals+j, fp)) return -1;

// pour tous les spots
for (j=0;j<scene3d->num_SPOTS;++j)
 if (loadSpot(scene3d->spots+j, fp)) return -1;

// pour toute les cameras
for (j=0;j<scene3d->num_CAMERAS;++j)
 if (loadCamera(scene3d->cameras+j, fp)) return -1;

// pour tous les flares
for (j=0;j<scene3d->num_FLARES;++j)
 if (loadFlare(scene3d->flares+j, fp)) return -1;

scene3d->frame=0; // initialisations

printf("Lecture des objets...\n");

for (j=0;j<scene3d->num_OBJECTS;++j)
 if(load_brl(scene3d->objets+j,fp)) 
 {
  fclose(fp);
  return -1;
 }

 fclose(fp);   
 return 0;
}
