#define MAX_LIGHT_DISTANCE 1000
#define DIST_SCALING 0.0001

void lighting(vertex *vert, scene *scene3d)
{
 vector energy; 
 register int i;

 energy.x=energy.y=energy.z=24; // ambiant light

 // les lights ponctuelles
 for(i=0;i<scene3d->num_PONCTUALS;++i)
 {
  float d;
  vector v;

  v=scene3d->ponctuals[i].pos;
  subvectors(&v, &vert->t);
  sqrlength(&d,v);

  //if(d>MAX_LIGHT_DISTANCE) continue;
  
  // la light contribue
  v=scene3d->ponctuals[i].intensite;
  mulvector(&v,1.0/(1.0+d*DIST_SCALING));
  addvectors(&energy, &v);
 }

 // les spots
 for(i=0;i<scene3d->num_SPOTS;++i)
 {
  float d,a;
  vector v;

  v=vert->t;
  subvectors(&v, &scene3d->spots[i].pos);
  sqrlength(&d,v);

  //if(d>MAX_LIGHT_DISTANCE) continue;

  setlength(&v,180.0);
  //normalize(&v);

  dotproduct(&a, &v, &scene3d->spots[i].dir); // la longeur de dir=1

  if(a>scene3d->spots[i].fov) // la light contribue
  {
   v=scene3d->spots[i].intensite;
   mulvector(&v,1.0/(1.0+d*DIST_SCALING));
   addvectors(&energy, &v);
  }
 }

 // convertir energie en luminosite
 if (energy.x>255) energy.x=255;
 if (energy.y>255) energy.y=255;
 if (energy.z>255) energy.z=255;
 vert->intensite=energy;
}
